#include <stdarg.h>
#include <stdio.h>
#include <assert.h>

#include "ee_printf.h"
int 
vsprintf_caller(size_t n, const char* format, ...){
    char buffer[50];
    va_list args;
    int ret;
    va_start (args, format);
    //ee_vsprintf(buffer, format, args);
    ret = ee_vsnprintf(buffer, n, format, args);
    fprintf(stdout, "%s\n", buffer);
    va_end (args);
    return ret;
}

int
glibc_vsnprintf(size_t n, const char *format, ...){
    char buffer[50];
    va_list args;
    int ret;
    va_start (args, format);
    ret = vsnprintf(buffer, n, format, args);
    fprintf(stdout, "%s\n", buffer);
    va_end (args);
    return ret;
}

int
main(){
    char name[] = "Brandon Schaefer";
    char long_string[] = "This is going to be a very very very very very very very very very very very very very very very very very very very verylong string."; 
    int dec_number = 987654321;
    float pi = 3.14159265359;
    size_t size = 10;
    int ret;
    int glibc_ret;

    printf("Test string\n");
    fflush(stdout);
    ret = vsprintf_caller(size, "This is just a test string.");
    glibc_ret = glibc_vsnprintf(size, "This is just a test string.");
    printf("ret: %d glibc_ret: %d\n", ret, glibc_ret);


    size = 7;
    printf("Test %%c\n");
    printf("Characters to print: %d\n", (int)size);
    fflush(stdout);
    ret = vsprintf_caller(size, "Char:-%c\n", name);
    glibc_ret = glibc_vsnprintf(size, "Char:-%C/n", name);
    printf("ret: %d glibc_ret: %d\n", ret, glibc_ret);
    printf("\n");

    printf("Test %%s\n");
    printf("Characters to print: %d\n", (int)size);
    fflush(stdout);
    ret = vsprintf_caller(size, "%s\n", name);
    glibc_ret = glibc_vsnprintf(size, "%s\n", name);
    printf("ret: %d glibc_ret: %d\n", ret, glibc_ret);
    printf("\n");

    size = 5;
    printf("Test %%d\n");
    printf("Characters to print: %d\n", (int)size);
    fflush(stdout);
    ret = vsprintf_caller(size, "%d\n", dec_number);
    glibc_ret = glibc_vsnprintf(size, "%d\n", dec_number);
    printf("ret: %d glibc_ret: %d\n", ret, glibc_ret);
    printf("\n");

    printf("Test %%f\n");
    printf("Characters to print: %d\n", (int)size);
    fflush(stdout);
    ret = vsprintf_caller(size, "%f\n", pi);
    glibc_ret = glibc_vsnprintf(size, "%f\n", pi);
    printf("ret: %d glibc_ret: %d\n", ret, glibc_ret);
    printf("\n");

    size = 15;
    printf("Test %%p\n");
    printf("Characters to print: %d\n", (int)size);
    fflush(stdout);
    ret = vsprintf_caller(size, "%p\n", &pi);
    glibc_ret = glibc_vsnprintf(size, "%p\n", &pi);
    printf("ret: %d glibc_ret: %d\n", ret, glibc_ret);

    size = 60;
    printf("Test size larger than buffer\n");
    printf("Characters to print: %d\n", (int)size);
    fflush(stdout);
    ret = vsprintf_caller(size, "%s\n", long_string);
    glibc_ret = glibc_vsnprintf(size, "%s\n", long_string);
    printf("ret: %d glibc_ret: %d\n", ret, glibc_ret);
}
