// Copyright © 2016 Fluke Corporation. All rights reserved.

/**
 * \file
 * Functions for reading and writing RPMB block of eMMC.
 *
 * Mantis v2 uses the RPMB to store non-volatile parameters such as MAC
 * address and serial number.  These types of things were stored in the
 * EEPROM on mantis v1.  The RPMB (replay protected memory block) is a
 * protected block in the eMMC, separate from the mounted disk partitions
 * and the bootloader blocks.
 *
 * The RPMB must be read and written in 256 byte blocks.
 * At present, this is used for structs NvDataShared and NvDataMantis, which
 * are each 512 bytes.
 */

#pragma once

#include "nvdatastructs.h"

// layout of data in RPMB block
struct CicadaRpmb
{
    struct NvSharedData   nvDataShared;
    struct NvMantisData   nvDataMantis;
};
