/*
 *   vt.c
 *
 *   (C) Richard Drummond 2001-2007
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include "defs.h"
#include "vt.h"
#include <string.h>
#include <errno.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <linux/vt.h>
#include <linux/kd.h>

/*
 * Obtain a handle on the terminal this process is running in
 */
int VT_obtain( VTHandle *vt )
{
  return ( vt->fd = open( "/dev/tty", O_RDWR ) );
}

/*
 * Release a handle on the terminal
 */
void VT_release( VTHandle *vt )
{
  if( vt->fd ) close( vt->fd );
}

/*
 * Detach this process from the terminal its running in
 */
void VT_detach( VTHandle *vt )
{
  ioctl( vt->fd, TIOCNOTTY );
}

/*
 * Bring the specified virtual terminal to the foreground
 */
int VT_switch( VTHandle *vt, int vt_num )
{
   int old_vt=-1;
   struct vt_stat vt_state;

   if( (ioctl( vt->fd, VT_GETSTATE, &vt_state )) == 0 )
   {
     old_vt = vt_state.v_active;

     if( (ioctl( vt->fd, VT_ACTIVATE, vt_num )) == 0 )
     {
       ioctl( vt->fd, VT_WAITACTIVE, vt_num );

       return old_vt;
     }
   }
   return -1;
}
