/*
 *   surface.c
 *
 *   (C) Richard Drummond 2001-2007
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#include "defs.h"
#include "surface.h"
#include "convert.h"

/*
 * Write the visible surface to the specified stream as a PPM file.
 *
 * This function processes the surface a line at a time,
 * converting from its native pixel format/color model to
 * RGB24 ready for output.
 */
void Surface_dumpAsPPM( Surface *s, FILE * stream )
{
  __u32 width  = s->width;
  __u32 height = s->height;
  __u8 buf[ width * 3 ]; /* Buffer for converted row. */

  /* Get ptr to start of the first visible row. */
  __u8 *rowptr = s->buffer + s->top * s->modulo + s->left;
  int   row;

  /* Find a function to convert from surface's
   * pixel format/color model to RGB24. */
  convert_fn_ptr convert_fn = get_convert_fn( s->type, s->clrmodel );

  if( !convert_fn )
    fprintf( stderr, "Error: unsupported framebuffer pixel format.\n" );
  else
  {
    /* Write the PPM header */
    fprintf( stream, "P6 %d %d 255\n", width, height );

    /* For each visible row of the surface . . . */
    for ( row = height; row; row-- )
    {
      /* Call our conversion function to convert this row to RGB24. */
      convert_fn( rowptr, buf, width, s->cmap );

      /* Write out the converted pixels to the stream. */
      fwrite( buf, width * 3, 1, stream );

      /* And get a ptr to the next row. */
      rowptr += s->modulo;
    }
  }
}
