/*
 *   convert.h
 *
 *   (C) Richard Drummond 2001-2007
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#ifndef CONVERT_H
#define CONVERT_H

#include "defs.h"
#include "cmap.h"

typedef void ( *convert_fn_ptr ) ( const __u8*, __u8*, __u32, const ColorMap * ) ;

convert_fn_ptr get_convert_fn( __u32 type, __u32 color_model );

void convert_clut8(                const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );
void convert_directcolor_x1r5g5b5( const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );
void convert_directcolor_r5g6b5(   const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );
void convert_directcolor_r8g8b8(   const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );
void convert_directcolor_x8r8g8b8( const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );
void convert_truecolor_x1r5g5b5(   const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );
void convert_truecolor_r5g6b5(     const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );
void convert_truecolor_r8g8b8(     const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );
void convert_truecolor_x8r8g8b8(   const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );
void convert_vga4(                 const __u8 *src, __u8 *dest, __u32 count, const ColorMap *cmap );

#endif /*CONVERT_H*/
