#ifndef CICADA_TRACE_H
#define CICADA_TRACE_H

/*
 * Cicada Timing Trace
 */

#include <linux/times.h>
#include <linux/spinlock.h>
#include <stdarg.h>

/* single trace entry */
struct cicada_trace_entry
{
	unsigned int	time; /* timestamp in us */
	unsigned int	chan; /* channel bit */
	const char*	msg;  /* printf-like format string */
	unsigned int	arg1; /* arg1 for printf */
	unsigned int	arg2; /* arg2 for printf */
};
    
/* trace state struct */
struct cicada_trace {
	int				enabled;	/* recording now */
	int				save_enabled;	/* save while dumping */
	int				wrap_mode;	/* 0 = stop when full, 1 = wrap */
	int				put_index;	/* current put index*/
	int				get_index;	/* dump can happen in batches */
	uint32_t			initial_time;
	uint32_t			prev_time;
	int				max_entries;	/* max number of entries */
	int				has_wrapped;	/* true after first wrap */
	spinlock_t			lock;		/* spinlock protection */
	struct cicada_trace_entry	entries[0];	/* array of trace entries */
};

#define	CICADA_TRACE_ENTRIES_MAX	(1000)

#endif // CICADA_TRACE_H
