/*
 * Copyright (C) 2011 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "PrintInfo.h"

#include "ArgumentDecoder.h"
#include "ArgumentEncoder.h"
#include "Arguments.h"

#if PLATFORM(GTK)
#include "ArgumentCodersGtk.h"
#endif

namespace WebKit {

PrintInfo::PrintInfo()
    : pageSetupScaleFactor(0)
    , availablePaperWidth(0)
    , availablePaperHeight(0)
{
}

void PrintInfo::encode(CoreIPC::ArgumentEncoder& encoder) const
{
    encoder << pageSetupScaleFactor;
    encoder << availablePaperWidth;
    encoder << availablePaperHeight;

#if PLATFORM(GTK)
    CoreIPC::encode(encoder, printSettings.get());
    CoreIPC::encode(encoder, pageSetup.get());
#endif
}

bool PrintInfo::decode(CoreIPC::ArgumentDecoder& decoder, PrintInfo& info)
{
    if (!decoder.decode(info.pageSetupScaleFactor))
        return false;
    if (!decoder.decode(info.availablePaperWidth))
        return false;
    if (!decoder.decode(info.availablePaperHeight))
        return false;

#if PLATFORM(GTK)
    if (!CoreIPC::decode(decoder, info.printSettings))
        return false;
    if (!CoreIPC::decode(decoder, info.pageSetup))
        return false;
#endif

    return true;
}

}
