//==========================================================================
//
//      hal_soc.h
//
//      SoC chip definitions
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
// Copyright (C) 2002 Gary Thomas
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//========================================================================*/

#ifndef __HAL_SOC_H__
#define __HAL_SOC_H__

#ifdef __ASSEMBLER__

#define REG8_VAL(a)          (a)
#define REG16_VAL(a)         (a)
#define REG32_VAL(a)         (a)

#define REG8_PTR(a)          (a)
#define REG16_PTR(a)         (a)
#define REG32_PTR(a)         (a)

#else /* __ASSEMBLER__ */

extern char HAL_PLATFORM_EXTRA[];
#define REG8_VAL(a)          ((unsigned char)(a))
#define REG16_VAL(a)         ((unsigned short)(a))
#define REG32_VAL(a)         ((unsigned int)(a))

#define REG8_PTR(a)          ((volatile unsigned char *)(a))
#define REG16_PTR(a)         ((volatile unsigned short *)(a))
#define REG32_PTR(a)         ((volatile unsigned int *)(a))
#define readb(a)             (*(volatile unsigned char *)(a))
#define readw(a)             (*(volatile unsigned short *)(a))
#define readl(a)             (*(volatile unsigned int *)(a))
#define writeb(v,a)          (*(volatile unsigned char *)(a) = (v))
#define writew(v,a)          (*(volatile unsigned short *)(a) = (v))
#define writel(v,a)          (*(volatile unsigned int *)(a) = (v))

#endif /* __ASSEMBLER__ */

/*
 * Default Memory Layout Definitions
 */

#define L2CC_BASE_ADDR          0x30000000
#define IRAM_BASE_ADDR          0x10000000

/*
 * AIPS 1
 */
#define AIPS1_BASE_ADDR         0x43F00000
#define AIPS1_CTRL_BASE_ADDR    AIPS1_BASE_ADDR
#define MAX_BASE_ADDR           0x43F04000
#define EVTMON_BASE_ADDR        0x43F08000
#define CLKCTL_BASE_ADDR        0x43F0C000
#define ETB_SLOT4_BASE_ADDR     0x43F10000
#define ETB_SLOT5_BASE_ADDR     0x43F14000
#define ECT_CTIO_BASE_ADDR      0x43F18000
#define I2C_BASE_ADDR           0x43F80000
#define I2C3_BASE_ADDR          0x43F84000
//#define OTG_BASE_ADDR           0x43F88000
#define ATA_BASE_ADDR           0x43F8C000
#define UART1_BASE_ADDR         0x43F90000
#define UART2_BASE_ADDR         0x43F94000
#define I2C2_BASE_ADDR          0x43F98000
#define OWIRE_BASE_ADDR         0x43F9C000
#define SSI1_BASE_ADDR          0x43FA0000
#define CSPI1_BASE_ADDR         0x43FA4000
#define KPP_BASE_ADDR           0x43FA8000
#define IOMUXC_BASE_ADDR        0x43FAC000
//#define UART4_BASE_ADDR         0x43FB0000
//#define UART5_BASE_ADDR         0x43FB4000
#define ECT_IP1_BASE_ADDR       0x43FB8000
#define ECT_IP2_BASE_ADDR       0x43FBC000

/*
 * SPBA
 */
#define SPBA_BASE_ADDR          0x50000000
#define MMC_SDHC1_BASE_ADDR     0x53FB4000
#define MMC_SDHC2_BASE_ADDR     0x53FB8000
#define ESDHC1_REG_BASE         MMC_SDHC1_BASE_ADDR
#define UART3_BASE_ADDR         0x5000C000
#define CSPI2_BASE_ADDR         0x50010000
#define SSI2_BASE_ADDR          0x50014000
//#define SIM_BASE_ADDR           0x50018000
#define ATA_DMA_BASE_ADDR       0x50020000
#define FEC_BASE_ADDR		0x50038000
#define SOC_FEC_BASE		FEC_BASE_ADDR
#define SPBA_CTRL_BASE_ADDR     0x5003C000

/*
 * AIPS 2
 */
#define AIPS2_BASE_ADDR         0x53F00000
#define AIPS2_CTRL_BASE_ADDR    AIPS2_BASE_ADDR
#define CCM_BASE_ADDR           0x53F80000
//#define FIRI_BASE_ADDR          0x53F8C000
#define GPT1_BASE_ADDR          0x53F90000
#define EPIT1_BASE_ADDR         0x53F94000
#define EPIT2_BASE_ADDR         0x53F98000
#define GPIO3_BASE_ADDR         0x53FA4000
#define SCC_BASE                0x53FAC000
//#define SCM_BASE                0x53FAE000
//#define SMN_BASE                0x53FAF000
#define RNGA_BASE_ADDR          0x53FB0000
#define IPU_CTRL_BASE_ADDR      0x53FC0000
#define AUDMUX_BASE             0x53FC4000
//#define MPEG4_ENC_BASE          0x53FC8000
#define GPIO1_BASE_ADDR         0x53FCC000
#define GPIO2_BASE_ADDR         0x53FD0000
#define SDMA_BASE_ADDR          0x53FD4000
#define RTC_BASE_ADDR           0x53FD8000
#define WDOG_BASE_ADDR          0x53FDC000
#define PWM_BASE_ADDR           0x53FE0000
#define RTIC_BASE_ADDR          0x53FEC000
#define IIM_BASE_ADDR           0x53FF0000

/*
 * ROMPATCH and AVIC
 */
#define ROMPATCH_BASE_ADDR      0x60000000
#define AVIC_BASE_ADDR          0x68000000

/*
 * NAND, SDRAM, WEIM, M3IF, EMI controllers
 */
#define EXT_MEM_CTRL_BASE       0xB8000000
#define ESDCTL_BASE             0xB8001000
#define WEIM_BASE_ADDR          0xB8002000
#define WEIM_CTRL_CS0           WEIM_BASE_ADDR
#define WEIM_CTRL_CS1           (WEIM_BASE_ADDR + 0x10)
#define WEIM_CTRL_CS2           (WEIM_BASE_ADDR + 0x20)
#define WEIM_CTRL_CS3           (WEIM_BASE_ADDR + 0x30)
#define WEIM_CTRL_CS4           (WEIM_BASE_ADDR + 0x40)
#define WEIM_CTRL_CS5           (WEIM_BASE_ADDR + 0x50)
#define M3IF_BASE               0xB8003000
#define EMI_BASE		0xB8004000

#define NFC_BASE                0xBB000000

#define ROM_BASE_ADDR		0x0
#define ROM_BASE_ADDR_VIRT	0xF0000000
#define ROM_SI_REV_OFFSET	0x40

/*
 * Memory regions and CS
 */
#define IPU_MEM_BASE_ADDR       0x70000000
#define CSD0_BASE_ADDR          0x80000000
#define CSD1_BASE_ADDR          0x90000000
#define CS0_BASE_ADDR           0xA0000000
#define CS1_BASE_ADDR           0xA8000000
#define CS2_BASE_ADDR           0xB0000000
#define CS3_BASE_ADDR           0xB2000000
#define CS4_BASE_ADDR           0xB4000000
#define CS4_BASE_PSRAM          0xB5000000
#define CS5_BASE_ADDR           0xB6000000

#define INTERNAL_ROM_VA         0xF0000000

/*
 * IRQ Controller Register Definitions.
 */
#define AVIC_NIMASK                     REG32_PTR(AVIC_BASE_ADDR + (0x04))
#define AVIC_INTTYPEH                   REG32_PTR(AVIC_BASE_ADDR + (0x18))
#define AVIC_INTTYPEL                   REG32_PTR(AVIC_BASE_ADDR + (0x1C))

/* L210 */
#define L2CC_BASE_ADDR                  0x30000000
#define L2_CACHE_LINE_SIZE              32
#define L2_CACHE_CTL_REG                0x100
#define L2_CACHE_AUX_CTL_REG            0x104
#define L2_CACHE_SYNC_REG               0x730
#define L2_CACHE_INV_LINE_REG           0x770
#define L2_CACHE_INV_WAY_REG            0x77C
#define L2_CACHE_CLEAN_LINE_REG         0x7B0
#define L2_CACHE_CLEAN_INV_LINE_REG     0x7F0
#define L2_CACHE_DBG_CTL_REG     	0xF40

/* CCM */
#define CLKCTL_CCMR                     0x00
#define CLKCTL_PDR0                     0x04
#define CLKCTL_PDR1                     0x08
#define CLKCTL_PDR2                     0x0C
#define CLKCTL_PDR3                     0x10
#define CLKCTL_PDR4                     0x14
#define CLKCTL_RCSR                     0x18
#define CLKCTL_MPCTL                    0x1C
#define CLKCTL_PPCTL                    0x20
#define CLKCTL_ACMR                     0x24
#define CLKCTL_COSR                     0x28
#define CLKCTL_CGR0                     0x2C
#define CLKCTL_CGR1                     0x30
#define CLKCTL_CGR2                     0x34
#define CLKCTL_CGR3                     0x38


#define FREQ_24MHZ                      24000000
#define PLL_REF_CLK                     FREQ_24MHZ

#define CLKMODE_AUTO		0
#define CLKMODE_CONSUMER	1

/* WEIM - CS0 */
#define CSCRU                           0x00
#define CSCRL                           0x04
#define CSCRA                           0x08

#define CHIP_REV_1_0            0x0      /* PASS 1.0 */
#define CHIP_REV_1_1            0x1      /* PASS 1.1 */
#define CHIP_REV_2_0            0x2      /* PASS 2.0 */
#define CHIP_LATEST             CHIP_REV_1_1

#define IIM_STAT_OFF            0x00
#define IIM_STAT_BUSY           (1 << 7)
#define IIM_STAT_PRGD           (1 << 1)
#define IIM_STAT_SNSD           (1 << 0)
#define IIM_STATM_OFF           0x04
#define IIM_ERR_OFF             0x08
#define IIM_ERR_PRGE            (1 << 7)
#define IIM_ERR_WPE         (1 << 6)
#define IIM_ERR_OPE         (1 << 5)
#define IIM_ERR_RPE         (1 << 4)
#define IIM_ERR_WLRE        (1 << 3)
#define IIM_ERR_SNSE        (1 << 2)
#define IIM_ERR_PARITYE     (1 << 1)
#define IIM_EMASK_OFF           0x0C
#define IIM_FCTL_OFF            0x10
#define IIM_UA_OFF              0x14
#define IIM_LA_OFF              0x18
#define IIM_SDAT_OFF            0x1C
#define IIM_PREV_OFF            0x20
#define IIM_SREV_OFF            0x24
#define IIM_PREG_P_OFF          0x28
#define IIM_SCS0_OFF            0x2C
#define IIM_SCS1_P_OFF          0x30
#define IIM_SCS2_OFF            0x34
#define IIM_SCS3_P_OFF          0x38

#define EPIT_BASE_ADDR          EPIT1_BASE_ADDR
#define EPITCR                  0x00
#define EPITSR                  0x04
#define EPITLR                  0x08
#define EPITCMPR                0x0C
#define EPITCNR                 0x10

#define GPT_BASE_ADDR           GPT1_BASE_ADDR
#define GPTCR                   0x00
#define GPTPR                   0x04
#define GPTSR                   0x08
#define GPTIR                   0x0C
#define GPTOCR1                 0x10
#define GPTOCR2                 0x14
#define GPTOCR3                 0x18
#define GPTICR1                 0x1C
#define GPTICR2                 0x20
#define GPTCNT                  0x24

/* ESDCTL */
#define ESDCTL_ESDCTL0                  0x00
#define ESDCTL_ESDCFG0                  0x04
#define ESDCTL_ESDCTL1                  0x08
#define ESDCTL_ESDCFG1                  0x0C
#define ESDCTL_ESDMISC                  0x10

#define ESDCTL_SDE	(1<<31)		// SDRAM controller enable
#define ESDCTL_SMODE(x)	(((x) & 0x7) << 28)	// operating mode
#define ESD_SMODE_NORMAL	0	// normal read/write
#define ESD_SMODE_PRECHARGE	1	// precharge command
#define ESD_SMODE_AUTO_REFSH	2	// auto-refresh command
#define ESD_SMODE_LOAD_MODE	3	// load mode register command
#define ESD_SMODE_MAN_REFSH	4	// manual self-refresh command
#define ESD_ESDCTL_SP	(1<<27)			// supervisor protect
#define ESDCTL_ROW(x)	(((x) & 0x7) << 24)	// row address width
#define ESD_ROW_11		0	// 11 row addresses
#define ESD_ROW_12		1	// 12 row addresses
#define ESD_ROW_13		2	// 13 row addresses
#define ESD_ROW_14		3	// 14 row addresses
#define ESD_ROW_15		4	// 15 row addresses
#define ESDCTL_COL(x)	(((x) & 0x3) << 20)	// column address width
#define ESD_COL_8		0	// 8 column addresses
#define ESD_COL_9		1	// 9 column addresses
#define ESD_COL_10		2	// 10 column addresses
#define ESD_COL_INCR		1	// increment column for DDR
#define ESDCTL_DSIZ(x)	(((x) & 0x3) << 16)	// data width
#define ESD_DSIZ_16_HIGH	0	// 16 bits on D[31:16]
#define ESD_DSIZ_16_LOW		1	// 16 bits on D[15:0]
#define ESD_DSIZ_32		2	// 32 bits
#define ESDCTL_SREFR(x)	(((x) & 0x7) << 13)	// refresh rate
#define ESD_SREFR_DISABLE	0	// refresh disabled
#define ESD_SREFR_1_2048	1	// 1 row, 2048 rows
#define ESD_SREFR_2_4096	2	// 2 rows, 4096 rows
#define ESD_SREFR_4_8192	3	// 4 rows, 8192 rows
#define ESD_SREFR_8_16384	4	// 8 rows, 16384 rows
#define ESD_SREFR_16_32768	5	// 16 rows, 32768 rows
#define ESDCTL_PWDT(x)	(((x) & 0x3) << 10)	// power down timeout
#define ESD_PWDT_DISABLE	0	// timeout disabled
#define ESD_PWDT_NOBANKS_ACT	1	// when no banks are active
#define ESD_PWDT_64_CLOCKS	2	// 64 HCLK cycles after last access
#define ESD_PWDT_128_CLOCKS	3	// 128 HCLK cycles after last access
#define ESDCTL_FP	(1<<8)		// Full-page mode
#define ESDCTL_BL_4	(0<<7)		// Burst-length of 4
#define ESDCTL_BL_8	(1<<7)		// Burst-length of 8
#define ESDCTL_PRCT(x)	(((x) & 0x7e) >> 1)	// precharge timer

#define ESDCFG_tXP(x)	(((x) & 0x3) << 21)	// LPDDR exit power down dly
#define ESDCFG_tWTR	(1<<20)			// write to read dly
#define ESDCFG_tRP(x)	(((x) & 0x3) << 18)	// precharge dly
#define ESDCFG_tMRD(x)	(((x) & 0x3) << 16)	// load mode to ACTIVE
#define ESDCFG_tWR	(1<<15)			// WRITE to PRECHARGE
#define ESDCFG_tRAS(x)	(((x) & 0x7) << 12)	// ACTIVE to PRECHARGE
#define ESDCFG_tRRD(x)	(((x) & 0x3) << 10)	// ACTIVE bank to bank
#define ESDCFG_tCAS(x)	(((x) & 0x3) << 8)	// CAS latency
#define ESDCFG_tRCD(x)	(((x) & 0x7) << 4)	// row to column dly
#define ESDCFG_tRC(x)	(((x) & 0xF) << 0)	// row cycle dly

#define ESDMISC_SDRAMDRY	(1<<31)	// external memory device status
#define ESDMISC_LHD		(1<<5)	// latency hiding disable
#define ESDMISC_MDDR_MDIS	(1<<4)	// LPDDR dly line meas disable
#define ESDMISC_MDDR_DL_RST	(1<<3)	// LPDDR dly line soft reset
#define ESDMISC_MDDREN		(1<<2)	// enable LPDDR operation
#define ESDMISC_RST		(1<<1)	// local module soft reset

#if (PLL_REF_CLK != 24000000)
#error Wrong PLL reference clock! The following macros will not work.
#endif

/* Assuming 24MHz input clock */
/*                            PD             MFD              MFI          MFN */
#define MPCTL_PARAM_399     (((1-1) << 26) + ((16-1) << 16) + (8  << 10) + (5 << 0))
#define MPCTL_PARAM_532     ((1 << 31) + ((1-1) << 26) + ((12-1) << 16) + (11  << 10) + (1 << 0))
#define MPCTL_PARAM_665     (((1-1) << 26) + ((48-1) << 16) + (13  << 10) + (41 << 0))

/* UPCTL                      PD             MFD              MFI          MFN */
#define PPCTL_PARAM_300     (((1-1) << 26) + ((4-1) << 16) + (6  << 10) + (1  << 0))

#define NFC_V1_1

#define NAND_REG_BASE                   (NFC_BASE + 0x1E00)
#define NFC_BUFSIZE_REG_OFF             (0 + 0x00)
#define RAM_BUFFER_ADDRESS_REG_OFF      (0 + 0x04)
#define NAND_FLASH_ADD_REG_OFF          (0 + 0x06)
#define NAND_FLASH_CMD_REG_OFF          (0 + 0x08)
#define NFC_CONFIGURATION_REG_OFF       (0 + 0x0A)
#define ECC_STATUS_RESULT_REG_OFF       (0 + 0x0C)
#define ECC_RSLT_MAIN_AREA_REG_OFF      (0 + 0x0E)
#define ECC_RSLT_SPARE_AREA_REG_OFF     (0 + 0x10)
#define NF_WR_PROT_REG_OFF              (0 + 0x12)
#define NAND_FLASH_WR_PR_ST_REG_OFF     (0 + 0x18)
#define NAND_FLASH_CONFIG1_REG_OFF      (0 + 0x1A)
#define NAND_FLASH_CONFIG2_REG_OFF      (0 + 0x1C)
#define UNLOCK_START_BLK_ADD_REG_OFF    (0 + 0x20)
#define UNLOCK_END_BLK_ADD_REG_OFF      (0 + 0x22)
#define RAM_BUFFER_ADDRESS_RBA_3        0x3
#define NFC_BUFSIZE_1KB                 0x0
#define NFC_BUFSIZE_2KB                 0x1
#define NFC_CONFIGURATION_UNLOCKED      0x2
#define ECC_STATUS_RESULT_NO_ERR        0x0
#define ECC_STATUS_RESULT_1BIT_ERR      0x1
#define ECC_STATUS_RESULT_2BIT_ERR      0x2
#define NF_WR_PROT_UNLOCK               0x4
#define NAND_FLASH_CONFIG1_FORCE_CE     (1 << 7)
#define NAND_FLASH_CONFIG1_RST          (1 << 6)
#define NAND_FLASH_CONFIG1_BIG          (1 << 5)
#define NAND_FLASH_CONFIG1_INT_MSK      (1 << 4)
#define NAND_FLASH_CONFIG1_ECC_EN       (1 << 3)
#define NAND_FLASH_CONFIG1_SP_EN        (1 << 2)
#define NAND_FLASH_CONFIG2_INT_DONE     (1 << 15)
#define NAND_FLASH_CONFIG2_FDO_PAGE     (0 << 3)
#define NAND_FLASH_CONFIG2_FDO_ID       (2 << 3)
#define NAND_FLASH_CONFIG2_FDO_STATUS   (4 << 3)
#define NAND_FLASH_CONFIG2_FDI_EN       (1 << 2)
#define NAND_FLASH_CONFIG2_FADD_EN      (1 << 1)
#define NAND_FLASH_CONFIG2_FCMD_EN      (1 << 0)
#define FDO_PAGE_SPARE_VAL              0x8
#define NAND_BUF_NUM	8

#define MXC_NAND_BASE_DUMMY             0x00000000
#define MXC_MMC_BASE_DUMMY              0x00000000
#define NOR_FLASH_BOOT                  0
#define NAND_FLASH_BOOT                 0x10000000
#define SDRAM_NON_FLASH_BOOT            0x20000000
#define MMC_FLASH_BOOT                  0x40000000
#define MXCBOOT_FLAG_REG                (AVIC_BASE_ADDR + 0x100)
#define MXCFIS_NOTHING                  0x00000000
#define MXCFIS_NAND                     0x10000000
#define MXCFIS_NOR                      0x20000000
#define MXCFIS_MMC                      0x40000000
#define MXCFIS_FLAG_REG                 (AVIC_BASE_ADDR + 0x104)

/* CSCRU Bit Defines for Chip Selects */
#define CSCRU_SP         (1<<31)              // Supervisor Protect
#define CSCRU_WP         (1<<30)              // Write Protect
#define CSCRU_BCD(x)     (((x) & 0x3) << 28)  // Burst Clock Divisor
#define CSCRU_BCS(x)     (((x) & 0xF) << 24)  // Burst Clock Start
#define CSCRU_PSZ(x)     (((x) & 0x3) << 22)  // Page Size
#define CSCRU_PME        (1<<21)              // Page Mode Emulation
#define CSCRU_SYNC       (1<<20)              // Synchronous Burst Mode Enable
#define CSCRU_DOL(x)     (((x) & 0xF) << 16)  // Data Output Length
#define CSCRU_CNC(x)     (((x) & 0x3) << 14)  // Chip Select Negation Clock Cycles
#define CSCRU_WSC(x)     (((x) & 0x3F) << 8)  // Wait State Control
#define CSCRU_EW         (1<<7)               // ECB/WAIT
#define CSCRU_WWS(x)     (((x) & 0x7) << 4)   // Write Wait State
#define CSCRU_EDC(x)     (((x) & 0xF) << 0)   // Extra Dead Cycles 

/* CSCRL Bit Defines for Chip Selects */
#define CSCRL_OEA(x)     (((x) & 0xF) << 28)  // OE* Assert - 1/2 AHB Clock cycles
#define CSCRL_OEN(x)     (((x) & 0xF) << 24)  // OE* Negate - 1/2 AHB Clock cycles
#define CSCRL_EBWA(x)    (((x) & 0xF) << 20)  // Enable Byte Write Assert - 1/2 AHB 
#define CSCRL_EBWN(x)    (((x) & 0xF) << 16)  // Enable Byte Write Negate - 1/2 AHB 
#define CSCRL_CSA(x)     (((x) & 0xF) << 12)  // Chip Select Assert - 1/2 AHB delays
#define CSCRL_EBC        (1<<11)              // Enable Byte Control
#define CSCRL_DSZ(x)     (((x) & 0x7) << 8)   // Data Port Size
#define CSCRL_CSN(x)     (((x) & 0xF) << 4)   // Chip Select Negate - 1/2 AHB delays
#define CSCRL_PSR        (1<<3)               // Pseudo SRAM Enable (Burst Write Enable)
#define CSCRL_CRE        (1<<2)               // Control Register Enable
#define CSCRL_WRAP       (1<<1)               // Wrap memory mode
#define CSCRL_CSEN       (1<<0)               // Chip Select Enable

/* CSCRA Bit Defines for Chip Selects */
#define CSCRA_EBRA(x)    (((x) & 0xF) << 28)  // Enable Byte Read Assert - 1/2 AHB clk
#define CSCRA_EBRN(x)    (((x) & 0xF) << 24)  // Enable Byte Read Negate - 1/2 AHB clk
#define CSCRA_RWA(x)     (((x) & 0xF) << 20)  // Read/Write Assertion - 1/2 AHB clk
#define CSCRA_RWN(x)     (((x) & 0xF) << 16)  // Read/Write Negation - 1/2 AHB clk
#define CSCRA_MUM        (1<<15)              // Muxed Mode
#define CSCRA_LAH(x)     (((x) & 0x3) << 13)  // LBA* to Address Hold - 1/2 AHB clk
#define CSCRA_LBN(x)     (((x) & 0x7) << 10)  // LBA* Negation - 1/2 AHB clk
#define CSCRA_LBA(x)     (((x) & 0x3) << 8)   // LBA* Assertion - 1/2 AHB clk
#define CSCRA_DWW(x)     (((x) & 0x3) << 6)   // Decrease Write Wait State
#define CSCRA_DCT(x)     (((x) & 0x3) << 4)   // DTACK* Check Time - 1/2 AHB clk
#define CSCRL_WWU        (1<<3)               // Write Wrap Unmask
#define CSCRL_AGE        (1<<2)               // Acknowledge Gllue Enable
#define CSCRL_CNC2       (1<<1)               // CNC bit 2
#define CSCRL_FCE        (1<<0)               // Feedbck Clock Enable

#define IS_BOOTING_FROM_NAND()          (readl(MXCBOOT_FLAG_REG) == NAND_FLASH_BOOT)
#define IS_BOOTING_FROM_NOR()           (readl(MXCBOOT_FLAG_REG) == NOR_FLASH_BOOT)
#define IS_BOOTING_FROM_SDRAM()         (readl(MXCBOOT_FLAG_REG) == SDRAM_NON_FLASH_BOOT)
#define IS_BOOTING_FROM_MMC()           (readl(MXCBOOT_FLAG_REG) == MMC_FLASH_BOOT)

#ifndef MXCFLASH_SELECT_NAND
#define IS_FIS_FROM_NAND()              0
#else
#define IS_FIS_FROM_NAND()              (readl(MXCFIS_FLAG_REG) == MXCFIS_NAND)
#endif

#ifndef MXCFLASH_SELECT_MMC
#define IS_FIS_FROM_MMC()               0
#else
#define IS_FIS_FROM_MMC()               (readl(MXCFIS_FLAG_REG) == MXCFIS_MMC)
#endif

#ifndef MXCFLASH_SELECT_NOR
#define IS_FIS_FROM_NOR()               0
#else
#define IS_FIS_FROM_NOR()               (readl(MXCFIS_FLAG_REG) == MXCFIS_NOR)
#endif

#define MXC_ASSERT_NOR_BOOT()           do {writel(MXCFIS_NOR, MXCFIS_FLAG_REG);\
                                            writel(NOR_FLASH_BOOT, MXCBOOT_FLAG_REG);} while(0)
#define MXC_ASSERT_NAND_BOOT()          writel(MXCFIS_NAND, MXCFIS_FLAG_REG)
#define MXC_ASSERT_MMC_BOOT()           writel(MXCFIS_MMC, MXCFIS_FLAG_REG)

/*
 * This macro is used to get certain bit field from a number
 */
#define MXC_GET_FIELD(val, len, sh)          ((val >> sh) & ((1 << len) - 1))

/*
 * This macro is used to set certain bit field inside a number
 */
#define MXC_SET_FIELD(val, len, sh, nval)    ((val & ~(((1 << len) - 1) << sh)) | (nval << sh))

#define L1CC_ENABLED
#define L2CC_ENABLED

#define UART_WIDTH_32         /* internal UART is 32bit access only */

#if !defined(__ASSEMBLER__)
void cyg_hal_plf_serial_init(void);
void cyg_hal_plf_serial_stop(void);
void hal_delay_us(unsigned int usecs);
#define HAL_DELAY_US(n)     hal_delay_us(n)

enum plls {
        MCU_PLL = CCM_BASE_ADDR + CLKCTL_MPCTL,
        PER_PLL = CCM_BASE_ADDR + CLKCTL_PPCTL,
};

enum main_clocks {
        CPU_CLK,
        AHB_CLK,
        IPG_CLK,
        IPG_PER_CLK,
        NFC_CLK,
        USB_CLK,
        HSP_CLK,
};

enum peri_clocks {
        UART1_BAUD,
        UART2_BAUD,
        UART3_BAUD,
        SSI1_BAUD,
        SSI2_BAUD,
        CSI_BAUD,
        MSHC_CLK,
        ESDHC1_CLK,
        ESDHC2_CLK,
        ESDHC3_CLK,
        SPDIF_CLK,
        SPI1_CLK = CSPI1_BASE_ADDR,
        SPI2_CLK = CSPI2_BASE_ADDR,
};

unsigned int pll_clock(enum plls pll);

unsigned int get_main_clock(enum main_clocks clk);

unsigned int get_peri_clock(enum peri_clocks clk);

typedef unsigned int nfc_setup_func_t(unsigned int, unsigned int, unsigned int, unsigned int);

#endif //#if !defined(__ASSEMBLER__)

#define HAL_MMU_OFF() \
CYG_MACRO_START          \
    asm volatile (                                                      \
        "mcr p15, 0, r0, c7, c14, 0;"                                   \
        "mcr p15, 0, r0, c7, c10, 4;" /* drain the write buffer */      \
        "mcr p15, 0, r0, c7, c5, 0;" /* invalidate I cache */           \
        "mrc p15, 0, r0, c1, c0, 0;" /* read c1 */                      \
        "bic r0, r0, #0x7;" /* disable DCache and MMU */                \
        "bic r0, r0, #0x1000;" /* disable ICache */                     \
        "mcr p15, 0, r0, c1, c0, 0;" /*  */                             \
        "nop;" /* flush i+d-TLBs */                                     \
        "nop;" /* flush i+d-TLBs */                                     \
        "nop;" /* flush i+d-TLBs */                                     \
        :                                                               \
        :                                                               \
        : "r0","memory" /* clobber list */);                            \
CYG_MACRO_END

#endif /* __HAL_SOC_H__ */
