//==========================================================================
//
//      board_misc.c
//
//      HAL misc board support code for the board
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//========================================================================*/

#include <pkgconf/hal.h>
#include <pkgconf/system.h>
#include <redboot.h>
#include CYGBLD_HAL_PLATFORM_H

#include <cyg/infra/cyg_type.h>         // base types
#include <cyg/infra/cyg_trac.h>         // tracing macros
#include <cyg/infra/cyg_ass.h>          // assertion macros

#include <cyg/hal/hal_io.h>             // IO macros
#include <cyg/hal/hal_arch.h>           // Register state info
#include <cyg/hal/hal_diag.h>
#include <cyg/hal/hal_intr.h>           // Interrupt names
#include <cyg/hal/hal_cache.h>
#include <cyg/hal/hal_soc.h>            // Hardware definitions
#include <cyg/hal/fsl_board.h>          // Platform specifics

#include <cyg/infra/diag.h>             // diag_printf

// All the MM table layout is here:
#include <cyg/hal/hal_mm.h>

externC void* memset(void *, int, size_t);
static void mxc_serial_setup(void);
static void mxc_gpio_setup(void);
extern int set_console_baud_rate(int rate);

void hal_mmu_init(void)
{
    unsigned long ttb_base = SRAM_BASE_ADDR + 0x4000;
    unsigned long i;

    /*
     * Set the TTB register
     */
    asm volatile ("mcr  p15,0,%0,c2,c0,0" : : "r"(ttb_base) /*:*/);

    /*
     * Set the Domain Access Control Register
     */
    i = ARM_ACCESS_DACR_DEFAULT;
    asm volatile ("mcr  p15,0,%0,c3,c0,0" : : "r"(i) /*:*/);

    /*
     * First clear all TT entries - ie Set them to Faulting
     */
    memset((void *)ttb_base, 0, ARM_FIRST_LEVEL_PAGE_TABLE_SIZE);

    /*              Actual   Virtual  Size   Attributes                                                    Function  */
    /*              Base     Base     MB     cached?           buffered?        access permissions                 */
    /*              xxx00000 xxx00000                                                                                */
    X_ARM_MMU_SECTION(0x000, 0xF00,   0x1,   ARM_UNCACHEABLE, ARM_UNBUFFERABLE, ARM_ACCESS_PERM_RW_RW); /* Internal ROM */
    X_ARM_MMU_SECTION(0x100, 0x100,   0x1,   ARM_UNCACHEABLE, ARM_UNBUFFERABLE, ARM_ACCESS_PERM_RW_RW); /* Internal iRAM */
    X_ARM_MMU_SECTION(0x300, 0x300,   0x1,   ARM_UNCACHEABLE, ARM_UNBUFFERABLE, ARM_ACCESS_PERM_RW_RW); /* L2CC */
    X_ARM_MMU_SECTION(0x400, 0x400,   0x400, ARM_UNCACHEABLE, ARM_UNBUFFERABLE, ARM_ACCESS_PERM_RW_RW); /* Internal Regsisters upto SDRAM*/
    X_ARM_MMU_SECTION(0x800, 0x000,   0x80,  ARM_CACHEABLE,   ARM_BUFFERABLE,   ARM_ACCESS_PERM_RW_RW); /* xDRAM  0:128M*/
    X_ARM_MMU_SECTION(0x800, 0x800,   0x80,  ARM_CACHEABLE,   ARM_BUFFERABLE,   ARM_ACCESS_PERM_RW_RW); /* xDRAM 0:128M*/
    X_ARM_MMU_SECTION(0x800, 0x880,   0x80,  ARM_UNCACHEABLE, ARM_UNBUFFERABLE, ARM_ACCESS_PERM_RW_RW); /* xDRAM 0:128M*/
    X_ARM_MMU_SECTION(0xA00, 0xA00,   0x80,  ARM_CACHEABLE,   ARM_BUFFERABLE,   ARM_ACCESS_PERM_RW_RW); /* CS0 - Flash */
    X_ARM_MMU_SECTION(0xB20, 0xB20,   0x1E0, ARM_UNCACHEABLE, ARM_UNBUFFERABLE,ARM_ACCESS_PERM_RW_RW); /* ESDCTL, WEIM, M3IF, EMI, NFC, External I/O */
}

//
// Platform specific initialization
//

unsigned int g_clock_src;

void plf_hardware_init(void)
{
    g_clock_src = FREQ_24MHZ;

    mxc_serial_setup();
    mxc_gpio_setup();
}

static void mxc_serial_setup(void)
{
    // UART1
     /*RXD1*/
     writel(0, IOMUXC_BASE_ADDR + 0x188);
     // 1.8v, hyst ena, 100k PU, not ODrain, slow slew, norm drive
     writel(0x21E0, IOMUXC_BASE_ADDR + 0x5CC);

     /*TXD1*/
     writel(0, IOMUXC_BASE_ADDR + 0x18C);
     // 1.8v, no hyst, no PU, not ODrain, slow slew, norm drive
     writel(0x1000, IOMUXC_BASE_ADDR + 0x5D0);
}

void mxc_i2c_init(unsigned int module_base)
{
	switch(module_base) {
	case I2C_BASE_ADDR:
            // using default iomux and pad
            // I2C1_CLK, I2C1_DAT
            break;
	case I2C2_BASE_ADDR:
		break;
	case I2C3_BASE_ADDR:
	default:
		break;
	}
}

void mxc_mmc_init(unsigned int base_address)
{
    switch(base_address) {
    case MMC_SDHC1_BASE_ADDR:
        // all pins default alt mode 0
        
        // SD1_CMD
        // 3.3v, hyst ena, 47k PU, not ODrain, fast slew, max drive
        writel (0x1D3, IOMUXC_BASE_ADDR + 0x694);
        // SD1_CLK
        // 3.3v, hyst disable, 47k PU, not ODrain, fast slew, max drive
        writel (0x0D3, IOMUXC_BASE_ADDR + 0x698);
        // SD1_DATA0
        // 3.3v, hyst ena, 47k PU, not ODrain, fast slew, max drive
        writel (0x1D3, IOMUXC_BASE_ADDR + 0x69c);
        // SD1_DATA1
        // 3.3v, hyst ena, 47k PU, not ODrain, fast slew, max drive
        writel (0x1D3, IOMUXC_BASE_ADDR + 0x6a0);
        // SD1_DATA2
        // 3.3v, hyst ena, 47k PU, not ODrain, fast slew, max drive
        writel (0x1D3, IOMUXC_BASE_ADDR + 0x6a4);
        // SD1_DATA3
        // 3.3v, hyst ena, 100k PU, not ODrain, fast slew, max drive
        writel (0x1C3, IOMUXC_BASE_ADDR + 0x6a8);
        break;
    case MMC_SDHC2_BASE_ADDR:
        break;
    default:
        break;
    }
}

static void mxc_gpio_setup(void)
{
    // GPIO2_24
    // HWID-2
    writel(5, IOMUXC_BASE_ADDR + 0x02a8);
    writel(0x01e0, IOMUXC_BASE_ADDR + 0x070c);
    writel(0x0001, IOMUXC_BASE_ADDR + 0x08a8);  // select input daisy chain routing

    // GPIO1_31
    // HWID-1
    writel(5, IOMUXC_BASE_ADDR + 0x010c);
    writel(0x21e0, IOMUXC_BASE_ADDR + 0x0550);

    // GPIO1_28
    // HWID-0
    writel(5, IOMUXC_BASE_ADDR + 0x0100);
    writel(0x21e0, IOMUXC_BASE_ADDR + 0x0544);

    // GPIO3_13
    // HWREV-3
    writel(5, IOMUXC_BASE_ADDR + 0x01a4);
    writel(0x21e0, IOMUXC_BASE_ADDR + 0x05e8);

    // GPIO3_12
    // HWREV-2
    writel(5, IOMUXC_BASE_ADDR + 0x01a0);
    writel(0x21e0, IOMUXC_BASE_ADDR + 0x05e4);

    // GPIO3_11
    // HWREV-1
    writel(5, IOMUXC_BASE_ADDR + 0x019c);
    writel(0x21e0, IOMUXC_BASE_ADDR + 0x05e0);

    // GPIO3_10
    // HWREV-0
    writel(5, IOMUXC_BASE_ADDR + 0x0198);
    writel(0x21e0, IOMUXC_BASE_ADDR + 0x05dc);
}

int mxc_hwrev(void)
{
    return ~(readl(GPIO3_BASE_ADDR) >> 10) & 0x0f;
}

int mxc_hwid(void)
{
    int val1 = readl(GPIO1_BASE_ADDR);
    int val2 = readl(GPIO2_BASE_ADDR);
    return (~(val2 >> 22) & 0x04) | (~(val1 >> 30) & 0x02) |
           (~(val1 >> 28) & 0x01) ;
}

int mxc_get_memsize(void)
{
    if (mxc_hwid() == 1 || mxc_hwrev() < 2)
        return 0x08000000;

    return 0x10000000;
}

static void display_hw_rev(void)
{
    diag_printf("\n");
    diag_printf("Hardware Version %d, Id %d\n", mxc_hwrev(), mxc_hwid());
}
RedBoot_init(display_hw_rev, RedBoot_INIT_LAST);

#include CYGHWR_MEMORY_LAYOUT_H

typedef void code_fun(void);

void board_program_new_stack(void *func)
{
    register CYG_ADDRESS stack_ptr asm("sp");
    register CYG_ADDRESS old_stack asm("r4");
    register code_fun *new_func asm("r0");
    old_stack = stack_ptr;
    stack_ptr = CYGMEM_REGION_ram + CYGMEM_REGION_ram_SIZE - sizeof(CYG_ADDRESS);
    new_func = (code_fun*)func;
    new_func();
    stack_ptr = old_stack;
}

static void display_clock_src(void)
{
    diag_printf("\n");
    if (g_clock_src == FREQ_24MHZ) {
        diag_printf("Clock input is 24 MHz");
    } else {
        diag_printf("Unknown clock input source. Something is wrong!");
    }
}
RedBoot_init(display_clock_src, RedBoot_INIT_LAST);

static void init_console_rate(void)
{
    set_console_baud_rate(115200);
}
RedBoot_init(init_console_rate, 101);

// ------------------------------------------------------------------------
