/****************************************************************************
**
** Copyright (C) 2015 The Qt Company Ltd.
** Contact: http://www.qt.io/licensing/
**
** This file is part of the plugins of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL21$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 or version 3 as published by the Free
** Software Foundation and appearing in the file LICENSE.LGPLv21 and
** LICENSE.LGPLv3 included in the packaging of this file. Please review the
** following information to ensure the GNU Lesser General Public License
** requirements will be met: https://www.gnu.org/licenses/lgpl.html and
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** As a special exception, The Qt Company gives you certain additional
** rights. These rights are described in The Qt Company LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** $QT_END_LICENSE$
**
****************************************************************************/
/****************************************************************************
** Copyright © 2012,2013,2016 Fluke Corporation. All rights reserved.
**
** derived from:
** qt-everywhere-opensource-src-5.6.1/qtbase/src/plugins/platforms/linuxfb/
****************************************************************************/

#include "qlinuxfbintegration.h"

#if MANTIS_VERSION == 1
#include "v1/qlinuxfbscreen.h"
#else
#include "v2/qlinuxfbscreen.h"
#endif //MANTIS_VERSION

#include <QtPlatformSupport/private/qgenericunixfontdatabase_p.h>
#include <QtPlatformSupport/private/qgenericunixservices_p.h>
#include <QtPlatformSupport/private/qgenericunixeventdispatcher_p.h>

#include <QtPlatformSupport/private/qfbvthandler_p.h>
#include <QtPlatformSupport/private/qfbbackingstore_p.h>
#include <QtPlatformSupport/private/qfbwindow_p.h>
#include <QtPlatformSupport/private/qfbcursor_p.h>

#include <QtGui/private/qguiapplication_p.h>
#include <qpa/qplatforminputcontextfactory_p.h>

#define QT_NO_LIBINPUT

#ifndef QT_NO_LIBINPUT
#include <QtPlatformSupport/private/qlibinputhandler_p.h>
#endif

#if !defined(QT_NO_EVDEV) && (!defined(Q_OS_ANDROID) || defined(Q_OS_ANDROID_NO_SDK))
#include <QtPlatformSupport/private/qevdevmousemanager_p.h>
#include <QtPlatformSupport/private/qevdevkeyboardmanager_p.h>
#include <QtPlatformSupport/private/qevdevtouchmanager_p.h>
#endif

#if !defined(QT_NO_TSLIB) && (!defined(Q_OS_ANDROID) || defined(Q_OS_ANDROID_NO_SDK))
#include <QtPlatformSupport/private/qtslib_p.h>
#endif

//#define LINUXFB_DEBUG

#ifdef LINUXFB_DEBUG
#define prDebug(fmt, ...) \
    printf("FnetLinuxFbIntegration::%s " fmt, __func__, ##__VA_ARGS__);

#else
#define prDebug(...)

#endif

QT_BEGIN_NAMESPACE

FnetLinuxFbIntegration::FnetLinuxFbIntegration(const QStringList &paramList)
    : m_fontDb(new QGenericUnixFontDatabase),
      m_services(new QGenericUnixServices)
{
    prDebug("\n");

    m_primaryScreen = new FnetLinuxFbScreen(paramList);
}

FnetLinuxFbIntegration::~FnetLinuxFbIntegration()
{
    destroyScreen(m_primaryScreen);
}

void FnetLinuxFbIntegration::initialize()
{
    prDebug("\n");

    if (m_primaryScreen->initialize())
        screenAdded(m_primaryScreen);
    else
        qWarning("linuxfb: Failed to initialize screen");

    m_inputContext = QPlatformInputContextFactory::create();

    m_nativeInterface.reset(new QPlatformNativeInterface);

    m_vtHandler.reset(new QFbVtHandler);

    if (!qEnvironmentVariableIntValue("QT_QPA_FB_DISABLE_INPUT"))
        createInputHandlers();
}

bool FnetLinuxFbIntegration::hasCapability(QPlatformIntegration::Capability cap) const
{
    switch (cap) {
    case ThreadedPixmaps: return true;
    case WindowManagement: return false;
    default: return QPlatformIntegration::hasCapability(cap);
    }
}

QPlatformBackingStore *FnetLinuxFbIntegration::createPlatformBackingStore(QWindow *window) const
{
    prDebug("\n");

    return new QFbBackingStore(window);
}

QPlatformWindow *FnetLinuxFbIntegration::createPlatformWindow(QWindow *window) const
{
    prDebug("\n");

    return new QFbWindow(window);
}

QAbstractEventDispatcher *FnetLinuxFbIntegration::createEventDispatcher() const
{
    prDebug("\n");

   return createUnixEventDispatcher();
}

QList<QPlatformScreen *> FnetLinuxFbIntegration::screens() const
{
    prDebug("\n");

    QList<QPlatformScreen *> list;
    list.append(m_primaryScreen);
    return list;
}

QPlatformFontDatabase *FnetLinuxFbIntegration::fontDatabase() const
{
   return m_fontDb.data();
}

QPlatformServices *FnetLinuxFbIntegration::services() const
{
    prDebug("\n");

    return m_services.data();
}

void FnetLinuxFbIntegration::createInputHandlers()
{
    prDebug("\n");

#ifndef QT_NO_LIBINPUT
    if (!qEnvironmentVariableIntValue("QT_QPA_FB_NO_LIBINPUT")) {
        new QLibInputHandler(QLatin1String("libinput"), QString());
        return;
    }
#endif

#if !defined(QT_NO_EVDEV) && (!defined(Q_OS_ANDROID) || defined(Q_OS_ANDROID_NO_SDK))
    new QEvdevKeyboardManager(QLatin1String("EvdevKeyboard"), QString(), this);
    new QEvdevMouseManager(QLatin1String("EvdevMouse"), QString(), this);
#ifndef QT_NO_TSLIB
    const bool useTslib = qEnvironmentVariableIntValue("QT_QPA_FB_TSLIB");
    if (useTslib)
        new QTsLibMouseHandler(QLatin1String("TsLib"), QString());
    else
#endif // QT_NO_TSLIB
        new QEvdevTouchManager(QLatin1String("EvdevTouch"), QString() /* spec */, this);
#endif
}

QPlatformNativeInterface *FnetLinuxFbIntegration::nativeInterface() const
{
    return m_nativeInterface.data();
}

QT_END_NAMESPACE
