/*
 * Copyright (c) (2011) Fluke Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __LINUX_I2C_CICADA_GASGAUGE_H
#define __LINUX_I2C_CICADA_GASGAUGE_H

#include <linux/i2c.h>

// cicada_gassgauge_state.status (SB_BatteryStatus register)
// bit definitions from Smart Battery Data Specification.
#define SB_STATUS_OVER_CHARGED_ALARM		0x8000
#define SB_STATUS_TERMINATE_CHARGE_ALARM	0x4000
#define SB_STATUS_OVER_TEMP_ALARM		0x1000
#define SB_STATUS_TERMINATE_DISCHARGE_ALARM	0x0800
#define SB_STATUS_REMAINING_CAPACITY_ALARM	0x0200
#define SB_STATUS_REMAINING_TIME_ALARM		0x0100
#define SB_STATUS_INITIALIZED			0x0080
#define SB_STATUS_DISCHARGING			0x0040
#define SB_STATUS_FULLY_CHARGED			0x0020
#define SB_STATUS_FULLY_DISCHARGED		0x0010
#define SB_STATUS_ERROR_MASK			0x000f

// cicada_gassgauge_info.mode (SB_BatteryMode register)
// bit definitions from Smart Battery Data Specification.
#define SB_MODE_CAPACITY_MODE			0x8000
#define SB_MODE_CHARGER_MODE			0x4000
#define SB_MODE_ALARM_MODE			0x2000
#define SB_MODE_PRIMARY_BATTERY			0x0200
#define SB_MODE_CHARGE_CONTROLLER_ENABLED	0x0100
#define SB_MODE_CONDITION_FLAG			0x0080
#define SB_MODE_PRIMARY_BATTERY_SUPPORT		0x0002
#define SB_MODE_INTERNAL_CHARGE_CONTROLLER	0x0001

#define SBS_BLOCK_MAX		(I2C_SMBUS_BLOCK_MAX + 2)

// Smart Battery Data Specification for units, etc.
struct cicada_battery_data {
	bool present;
	
	// info
	char manufacturer_name[SBS_BLOCK_MAX];
	u8 manufacturer_data[SBS_BLOCK_MAX];
	char device_name[SBS_BLOCK_MAX];
	char device_chemistry[SBS_BLOCK_MAX];
	u16 serial_number;
	char serial_number_str[6];
	u16 manufacturer_date; /* year (bits 9..15 + 1980),
				  month (bits 5..8), day (bits 0..4) */
	char manufacturer_date_str[11];
	u16 full_charge_capacity;
	u16 design_capacity;
	u16 design_voltage;
	u16 mode;		/* bit maped SB_MODE_* */
	u16 cycle_count;
	u16 spec;

	// current state
	u16 temp_now;		/* units of .1 K */
	u16 voltage_now;
	s16 current_now;
	s16 current_avg;
	u16 capacity_now;
	u16 state_of_charge;	/* percentage */
	u16 time_to_empty;
	u16 time_to_empty_avg;
	u16 time_to_full_avg;
	u16 status;		/* bit maped SB_STATUS_* */
};

int cicada_gasgauge_get(struct cicada_battery_data *bat);
int cicada_gasgauge_get_state(struct cicada_battery_data *bat);

/* return codes for cicada_charger_status */
enum {
	CICADA_CHARGER_STATUS_UNKNOWN = 0,
	CICADA_CHARGER_STATUS_NOTCHARGING,
	CICADA_CHARGER_STATUS_BATTERYFAULT,
	CICADA_CHARGER_STATUS_CHARGING,
	CICADA_CHARGER_STATUS_TEMPFAULT,
};

#endif /*  __LINUX_I2C_CICADA_GASGAUGE_H */
