/*
 *   surface.h
 *
 *   (C) Richard Drummond 2001-2007
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#ifndef SURFACE_H
#define SURFACE_H

#include "defs.h"
#include <linux/fb.h>
#include "cmap.h"

#define PIXEL_TYPE_UNKNOWN           0
#define PIXEL_TYPE_VGA4              1
#define PIXEL_TYPE_CLUT8             2
#define PIXEL_TYPE_x1r5g5b5          3
#define PIXEL_TYPE_r5g6b5            4
#define PIXEL_TYPE_r8g8b8            5
#define PIXEL_TYPE_x8r8g8b8          6

typedef struct
{
   __u32     left, top, width, height; /* Rectangular dimensions of surface */
   __u8     *buffer;                   /* The pixel data */
   __u32     type;                     /* Pixel format (framebuffer type) */
   __u32     bpp;                      /* Bits per pixel */
   __u32     clrmodel;                 /* Colour model (framebuffer visual) */
   __u32     modulo;                   /* Line length of buffer */
   ColorMap *cmap;                     /* Color map for this surface */
} Surface;


void Surface_dumpAsPPM( Surface *s, FILE * stream );

#endif /* SURFACE_H */
