//
// non-volatile (EEPROM/RPMB) data structures
//

#pragma once

//replaces static_assert as it isn't available in C
#define BUILD_BUG_ON(condition) ((void)sizeof(char[1 - 2*!!(condition)]))

#define NVHDR_MAGIC     0xcafefeed
#define NVHDR_HDRVER    1

#define NVHDR_TYPE_INVALID           0
#define NVHDR_TYPE_NVDATA_OLD_MANTIS 1  // pre-1.0 development units only
#define NVHDR_TYPE_EECONFIG2         2
#define NVHDR_TYPE_NVDATA_SHARED     3
#define NVHDR_TYPE_NVDATA_MANTIS     4
#define NVHDR_TYPE_NVDATA_FUTURE     5

// common header struct
struct NvHdr
{
    uint32_t	magic;           // the same for all NvHdr's
    uint32_t    hdrVersion;
    uint32_t	dataType;        // identifies the containing struct (e.g. NvData1)
    uint32_t	size;            // header plus data
    uint32_t	dataCrc;         // CRC of non-header data
    uint32_t	hdrCrc;          // CRC of rest of NvHdr
};

#define INSTRINFO_STRLEN 255 // not including terminating null
#define MAC_ADDR_STRLEN 17 // not including terminating null

const size_t NV_STRUCT_SIZE = 512;

//
// each of the NvX structs below should be NV_STRUCT_SIZE (512) bytes
//
// instead of changing any of these structs, define a new struct (with a new NVHDR_TYPE_)
// to occupy the same location in EEPROM
//

// shared between all products (mantis, lantis etc.)
//
// uses NVHDR_TYPE_NVDATA_SHARED
//
struct NvSharedData
{
    struct NvHdr nvHdr;
    uint32_t     bootGroup;
    char	 enetAddr[MAC_ADDR_STRLEN + 3]; // null-terminated string, aa:bb:cc:dd:ee:ff
    char	 instrString[INSTRINFO_STRLEN + 1];
    char         unused[208];
};

/* sizeof in static assert not valid in C */
//static_assert(sizeof(NvSharedData) == NV_STRUCT_SIZE, "wrong size");

// new mantis only
//
// uses NVHDR_TYPE_NVDATA_MANTIS
//
struct NvMantisData
{
    struct NvHdr nvHdr;
    uint32_t	 userLevel;
    uint32_t	 unused1;
    uint32_t	 sysconfBits;
    char	 mantisString[INSTRINFO_STRLEN + 1];
    char         unused[220];
};

//static_assert(sizeof(NvMantisData) == NV_STRUCT_SIZE, "wrong size");

// placeholder for future
//
// uses NVHDR_TYPE_NVDATA_FUTURE
//
struct NvFutureData
{
    struct NvHdr nvHdr;
    char         unused[488];
};

//static_assert(sizeof(NvFutureData) == NV_STRUCT_SIZE, "wrong size");
