/*
 * Copyright (C) 2014-2016 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <config.h>

/* DDR script */

/* NOTE: for this platform the DDR clock frequency will be 400MHz
   for any version of silicon.  This could be elevated to 533 MHz
   if there was a performance requirement assumning TO1.2 and
   later silicon is always used for this platform. */
.macro imx7d_ddr_freq_setting
	/* Change to 400Mhz */
	ldr r0, =ANATOP_BASE_ADDR               /* 0x3036_0000 */
	ldr r1, =0x70
	ldr r2, =0x00703021
	str r2, [r0, r1]
	ldr r1, =0x90
	ldr r2, =0x0
	str r2, [r0, r1]
	ldr r1, =0x70
	ldr r2, =0x00603021
	str r2, [r0, r1]

	ldr r3, =0x80000000
333:
	ldr r2, [r0, r1]
	and r2, r3
	cmp r2, r3
	bne 333b

	ldr r0, =CCM_BASE_ADDR                  /* 0x3038_0000 */
	ldr r1, =0x9880
	ldr r2, =0x1
	str r2, [r0, r1]

222:    
.endm

.macro imx7d_cicada_ddr_setting
	/* check whether it is a LPSR resume */
	ldr	r1, =IOMUXC_LPSR_GPR_BASE_ADDR
	ldr	r7, [r1]
	cmp	r7, #0
	beq	16f

	/* disable wdog powerdown counter */
	ldr	r0, =WDOG1_BASE_ADDR
	ldrh	r1, =0x0
	strh	r1, [r0, #0x8]

	/* initialize AIPs 1-3 port */
	ldr	r0, =AIPS1_ON_BASE_ADDR
	ldr	r1, =0x77777777
	str	r1, [r0]
	str	r1, [r0, #0x4]
	ldr	r1, =0x0
	str	r1, [r0, #0x40]
	str	r1, [r0, #0x44]
	str	r1, [r0, #0x48]
	str	r1, [r0, #0x4c]
	str	r1, [r0, #0x50]

	ldr	r0, =AIPS2_ON_BASE_ADDR
	ldr	r1, =0x77777777
	str	r1, [r0]
	str	r1, [r0, #0x4]
	ldr	r1, =0x0
	str	r1, [r0, #0x40]
	str	r1, [r0, #0x44]
	str	r1, [r0, #0x48]
	str	r1, [r0, #0x4c]
	str	r1, [r0, #0x50]

	ldr	r0, =AIPS3_ON_BASE_ADDR
	ldr	r1, =0x77777777
	str	r1, [r0]
	str	r1, [r0, #0x4]
	ldr	r1, =0x0
	str	r1, [r0, #0x40]
	str	r1, [r0, #0x44]
	str	r1, [r0, #0x48]
	str	r1, [r0, #0x4c]
	str	r1, [r0, #0x50]

	imx7d_ddr_freq_setting

	ldr	r1,  =ANATOP_BASE_ADDR          /* 0x3036_0000 */
	ldr	r2,  =SRC_BASE_ADDR             /* 0x3039_0000 */
	ldr	r3,  =DDRC_IPS_BASE_ADDR        /* 0x307A_0000 */
	ldr	r4,  =DDRPHY_IPS_BASE_ADDR      /* 0x3079_0000 */
	ldr	r10, =CCM_BASE_ADDR             /* 0x3038_0000 */
	ldr	r11, =IOMUXC_GPR_BASE_ADDR      /* 0x3034_0000 */

	/* turn on ddr power.  NOTE: other sections of code indicate
           that this is the SNVS_MISC_CTRL register but it is not
           documented in the reference manual! */
	ldr	r7, =(0x1 << 29)
	str	r7, [r1, #0x388]

	ldr	r6, =50
1:
	subs	r6, r6, #0x1
	bne	1b

	/* clear ddr_phy reset at 0x30391000 */
	ldr	r6, =0x1000
	ldr	r7, [r2, r6]
	orr	r7, r7, #0x3
	str	r7, [r2, r6]
	ldr	r7, [r2, r6]
	bic	r7, r7, #0x1
	str	r7, [r2, r6]

	/* restore DDRC */
	ldr	r6, =0x0
	ldr	r7, =0x01040001
	str	r7, [r3, r6]

	ldr	r6, =0x1a0
	ldr	r7, =0x80400003
	str	r7, [r3, r6]

	ldr	r6, =0x1a4
	ldr	r7, =0x00100020
	str	r7, [r3, r6]

	ldr	r6, =0x1a8
	ldr	r7, =0x80100004
	str	r7, [r3, r6]

	ldr	r6, =0x64
	ldr	r7, =0x00300034
	str	r7, [r3, r6]

	ldr	r6, =0xd0
	ldr	r7, =0xc0020062
	str	r7, [r3, r6]

	ldr	r6, =0xd4
	ldr	r7, =0x4F0000
	str	r7, [r3, r6]

	ldr	r6, =0xdc
	ldr	r7, =0x9300004
	str	r7, [r3, r6]

	ldr	r6, =0xe0
	ldr	r7, =0x4080000
	str	r7, [r3, r6]

	ldr	r6, =0xe4
	ldr	r7, =0x100004
	str	r7, [r3, r6]

	ldr	r6, =0xf4
	ldr	r7, =0x0000033F
	str	r7, [r3, r6]

	ldr	r6, =0x100
	ldr	r7, =0x8060D07
	str	r7, [r3, r6]

	ldr	r6, =0x104
	ldr	r7, =0x5020A
	str	r7, [r3, r6]

	ldr	r6, =0x108
	ldr	r7, =0x3040407
	str	r7, [r3, r6]

	ldr	r6, =0x10c
	ldr	r7, =0x2006
	str	r7, [r3, r6]

	ldr	r6, =0x110
	ldr	r7, =0x3020204
	str	r7, [r3, r6]

	ldr	r6, =0x114
	ldr	r7, =0x3030202
	str	r7, [r3, r6]

	ldr	r6, =0x120
	ldr	r7, =0x803
	str	r7, [r3, r6]

	ldr	r6, =0x180
	ldr	r7, =0x600018
	str	r7, [r3, r6]

	ldr	r6, =0x190
	ldr	r7, =0x2098204
	str	r7, [r3, r6]

	ldr	r6, =0x194
	ldr	r7, =0x30303
	str	r7, [r3, r6]

	ldr	r6, =0x200
	ldr	r7, =0x16
	str	r7, [r3, r6]

	ldr	r6, =0x204
	ldr	r7, =0x171717
	str	r7, [r3, r6]

	ldr	r6, =0x210
	ldr	r7, =0x00000f0f
	str	r7, [r3, r6]

	ldr	r6, =0x214
	ldr	r7, =0x4040404
	str	r7, [r3, r6]

	ldr	r6, =0x218
	ldr	r7, =0xf040404
	str	r7, [r3, r6]

	ldr	r6, =0x240
	ldr	r7, =0x6000604
	str	r7, [r3, r6]

	ldr	r6, =0x244
	ldr	r7, =0x1
	str	r7, [r3, r6]

        /* set SELFREF_SW then clear DFI_INIT_COMPLETE_EN */
	ldr	r7, =0x20
	str	r7, [r3, #0x30]
	ldr	r7, =0x0
	str	r7, [r3, #0x1b0]

	/* do PHY, clear ddr_phy reset */
	ldr	r6, =0x1000
	ldr	r7, [r2, r6]
	bic	r7, r7, #0x2
	str	r7, [r2, r6]

	/* clear/set bit30 of SNVS_MISC_CTRL to ensure exit from ddr retention */
        /* register at 0x3036_0380 is undocumented in the reference manual and
           there is no mention of a SNVS_MISC_CTRL register!! */
	ldr	r7, =(0x1 << 30)
	str	r7, [r1, #0x388]
	ldr	r7, =(0x1 << 30)
	str	r7, [r1, #0x384]

	/* need to delay ~5mS */
	ldr	r6, =0x100000
3:
	subs	r6, r6, #0x1
	bne	3b

	/* restore DDR PHY */
	ldr	r6, =0x0
	ldr	r7, =0x17420f40
	str	r7, [r4, r6]

	ldr	r6, =0x4
	ldr	r7, =0x10210100
	str	r7, [r4, r6]

	ldr	r6, =0x10
	ldr	r7, =0x60807
	str	r7, [r4, r6]

	ldr	r6, =0xb0
	ldr	r7, =0x1010007e
	str	r7, [r4, r6]

	ldr	r6, =0x9c
	ldr	r7, =0xd6e
	str	r7, [r4, r6]

#if 0
	ldr	r6, =0x7c
	ldr	r7, =0x18181818
	str	r7, [r4, r6]

	ldr	r6, =0x80
	ldr	r7, =0x18181818
	str	r7, [r4, r6]

	ldr	r6, =0x84
	ldr	r7, =0x40401818
	str	r7, [r4, r6]

	ldr	r6, =0x88
	ldr	r7, =0x00000040
	str	r7, [r4, r6]

	ldr	r6, =0x6c
	ldr	r7, =0x40404040
	str	r7, [r4, r6]
#endif

	ldr	r6, =0x20
	ldr	r7, =0x8080808
	str	r7, [r4, r6]

	ldr	r6, =0x30
	ldr	r7, =0x8080808
	str	r7, [r4, r6]

	ldr	r6, =0x50
	ldr	r7, =0x1000010
	str	r7, [r4, r6]

	ldr	r6, =0x50
	ldr	r7, =0x10
	str	r7, [r4, r6]

        /* set Zq drive strength to 48 ohms */
	ldr	r6, =0xc0
	ldr	r7, =0xe407304
	str	r7, [r4, r6]

	ldr	r6, =0xc0
	ldr	r7, =0xe447304
	str	r7, [r4, r6]

	ldr	r6, =0xc0
	ldr	r7, =0xe447306
	str	r7, [r4, r6]

        /* now enable the Zq clock */
	ldr	r6, =0xc0
	ldr	r7, =0xe4c7304
	str	r7, [r4, r6]

	ldr	r6, =0xc0
	ldr	r7, =0xe487306
	str	r7, [r4, r6]

        
	ldr	r7, =0x0
	add	r9, r10, #0x4000
	str	r7, [r9, #0x130]

	ldr	r7, =0x178
	orr	r7, r7, #0x8
	str	r7, [r11, #0x20]

	ldr	r7, =0x2
	add	r9, r10, #0x4000
	str	r7, [r9, #0x130]

	ldr	r7, =0xf
	str	r7, [r4, #0x18]

	/* wait until self-refresh mode entered */
11:
	ldr	r7, [r3, #0x4]
	and	r7, r7, #0x3
	cmp	r7, #0x3
	bne	11b
        
        /* set indicators that programming is complete */
	ldr	r7, =0x0
	str	r7, [r3, #0x320]
	ldr	r7, =0x1
	str	r7, [r3, #0x1b0]
	ldr	r7, =0x1
	str	r7, [r3, #0x320]

12:     /* wait for the acknowledge bit to be set */
	ldr	r7, [r3, #0x324]
	and	r7, r7, #0x1
	cmp	r7, #0x1
	bne	12b

13:     /* loop until self refresh type indicates non-automatic SR */
	ldr	r7, [r3, #0x4]
	and	r7, r7, #0x20
	cmp	r7, #0x20
	bne	13b

	/* let DDR out of self-refresh */
	ldr	r7, =0x0
	str	r7, [r3, #0x30]
14:     /* loop until self refresh type indicates no SR */
	ldr	r7, [r3, #0x4]
	and	r7, r7, #0x30
	cmp	r7, #0x0
	bne	14b

15:     /* loop until operating mode is normal */
	ldr	r7, [r3, #0x4]
	and	r7, r7, #0x3
	cmp	r7, #0x1
	bne	15b

	/* enable port */
	ldr	r7, =0x1
	str	r7, [r3, #0x490]

	/* jump to kernel resume */
	ldr	r1, =0x30270000
	ldr	r7, [r1]

	mov	pc, r7
/**************** end of LPSR resume section *******************/

        
16:     
	imx7d_ddr_freq_setting

	/* Configure ocram_epdc on cold boot */
	ldr r0, =IOMUXC_GPR_BASE_ADDR           /* 0x3034_0000 */
	ldr r1, =0x4f400005
	str r1, [r0, #0x4]

	/* clear/set bit30 of SNVS_MISC_CTRL to ensure exit from ddr retention */
        /* register at 0x3036_0380 is undocumented in the reference manual and
           there is no mention of a SNVS_MISC_CTRL register!! */
	ldr r0, =ANATOP_BASE_ADDR
	ldr r1, =(0x1 << 30)
	str r1, [r0, #0x388]
	str r1, [r0, #0x384]
        
	ldr r0, =SRC_BASE_ADDR                  /* 0x3039_0000 */
	ldr r1, =0x2
	ldr r2, =0x1000
	str r1, [r0, r2]

	ldr r0, =DDRC_IPS_BASE_ADDR             /* 0x307A_0000 */
	ldr r1, =0x01040001
	str r1, [r0]
	ldr r1, =0x80400003
	str r1, [r0, #0x1a0]
	ldr r1, =0x00100020
	str r1, [r0, #0x1a4]
	ldr r1, =0x80100004
	str r1, [r0, #0x1a8]
	ldr r1, =0x00300034
	str r1, [r0, #0x64]
	ldr r1, =0x1
	str r1, [r0, #0x490]
	ldr r1, =0x00020062
	str r1, [r0, #0xd0]
	ldr r1, =0x004F0000
	str r1, [r0, #0xd4]
	ldr r1, =0x09300004
	str r1, [r0, #0xdc]
	ldr r1, =0x04080000
	str r1, [r0, #0xe0]
	ldr r1, =0x00100004
	str r1, [r0, #0xe4]
	ldr r1, =0x33f
	str r1, [r0, #0xf4]
	ldr r1, =0x08060D07
	str r1, [r0, #0x100]
	ldr r1, =0x0005020A
	str r1, [r0, #0x104]
	ldr r1, =0x03040407
	str r1, [r0, #0x108]
	ldr r1, =0x00002006
	str r1, [r0, #0x10c]
	ldr r1, =0x03020204
	str r1, [r0, #0x110]
	ldr r1, =0x03030202
	str r1, [r0, #0x114]
	ldr r1, =0x00000803
	str r1, [r0, #0x120]
	ldr r1, =0x00600018
	str r1, [r0, #0x180]
/*	ldr r1, =0x02000100  */
/*	str r1, [r0, #0x184] */
	ldr r1, =0x02098204
	str r1, [r0, #0x190]
	ldr r1, =0x00030303
	str r1, [r0, #0x194]

	ldr r1, =0x00000016
	str r1, [r0, #0x200]
	ldr r1, =0x00171717
	str r1, [r0, #0x204]
	ldr r1, =0x00000f0f
	str r1, [r0, #0x210]
	ldr r1, =0x04040404
	str r1, [r0, #0x214]
	ldr r1, =0x0f040404
	str r1, [r0, #0x218]

	ldr r1, =0x06000604
	str r1, [r0, #0x240]
	ldr r1, =0x00000001
	str r1, [r0, #0x244]

	ldr r0, =SRC_BASE_ADDR                  /* 0x3039_0000 */
	mov r1, #0x0
	ldr r2, =0x1000
	str r1, [r0, r2]

	ldr r0, =DDRPHY_IPS_BASE_ADDR           /* 0x3079_0000 */
	ldr r1, =0x17420f40
	str r1, [r0]
	ldr r1, =0x10210100
	str r1, [r0, #0x4]
	ldr r1, =0x00060807
	str r1, [r0, #0x10]
	ldr r1, =0x1010007e
	str r1, [r0, #0xb0]
        
	ldr r1, =0xd6e
	str r1, [r0, #0x9c]

#if 0
	ldr r1, =0x18181818
	str r1, [r0, #0x7c]
	ldr r1, =0x18181818
	str r1, [r0, #0x80]
	ldr r1, =0x40401818
	str r1, [r0, #0x84]
	ldr r1, =0x00000040
	str r1, [r0, #0x88]
	ldr r1, =0x40404040
	str r1, [r0, #0x6c]
#endif

	ldr r1, =0x08080808
	str r1, [r0, #0x20]
	ldr r1, =0x08080808
	str r1, [r0, #0x30]
	ldr r1, =0x01000010
	str r1, [r0, #0x50]
	ldr r1, =0x00000010
	str r1, [r0, #0x50]

	ldr r1, =0x0e407304
	str r1, [r0, #0xc0]
	ldr r1, =0x0e447304
	str r1, [r0, #0xc0]
	ldr r1, =0x0e447306
	str r1, [r0, #0xc0]

wait_zq:
	ldr r1, [r0, #0xc4]
	tst r1, #0x1
	beq wait_zq

	ldr r1, =0x0e447304
	str r1, [r0, #0xc0]
	ldr r1, =0x0e407304
	str r1, [r0, #0xc0]

	ldr r0, =CCM_BASE_ADDR                  /* 0x3038_0000 */
	mov r1, #0x0
	ldr r2, =0x4130
	str r1, [r0, r2]
	ldr r0, =IOMUXC_GPR_BASE_ADDR           /* 0x3034_0000 */
	mov r1, #0x178
	str r1, [r0, #0x20]
	ldr r0, =CCM_BASE_ADDR                  /* 0x3038_0000 */
	mov r1, #0x2
	ldr r2, =0x4130
	str r1, [r0, r2]
	ldr r0, =DDRPHY_IPS_BASE_ADDR           /* 0x3079_0000 */
	ldr r1, =0x0000000f
	str r1, [r0, #0x18]

	ldr r0, =DDRC_IPS_BASE_ADDR             /* 0x307A_0000 */
wait_stat:
	ldr r1, [r0, #0x4]
	tst r1, #0x1
	beq wait_stat
.endm

.macro imx7_clock_gating
.endm

.macro imx7_qos_setting
.endm

.macro imx7_ddr_setting
	imx7d_cicada_ddr_setting
.endm

/* include the common plugin code here */
#include <asm/arch/mx7_plugin.S>
