/*
 * Copyright (C) 2015 Freescale Semiconductor, Inc.
 *
 * SPDX-License-Identifier:	GPL-2.0+
 */

#include <asm/arch/clock.h>
#include <asm/arch/imx-regs.h>
#include <asm/arch/mx7-pins.h>
#include <asm/arch/sys_proto.h>
#include <asm/gpio.h>
#include <asm/imx-common/iomux-v3.h>
#include <asm/imx-common/boot_mode.h>
#include <asm/io.h>
#include <linux/sizes.h>
#include <common.h>
#include <fsl_esdhc.h>
#include <mmc.h>
#include <miiphy.h>
#include <netdev.h>
#include <power/pmic.h>
#include <power/pfuze300_pmic.h>
#include "../common/pfuze.h"
#include <i2c.h>
#include <asm/imx-common/mxc_i2c.h>
#include <asm/arch/crm_regs.h>
#include <mantis/rpmb.h>
#include <jsmn.h>

DECLARE_GLOBAL_DATA_PTR;

/* Drive Strength */
#define PAD_CTL_DSE_X1			(0 << 0) /* default */
#define PAD_CTL_DSE_X4			(1 << 0)
#define PAD_CTL_DSE_X2			(2 << 0)
#define PAD_CTL_DSE_X6			(3 << 0)

/* I2C1 for PMIC */
struct i2c_pads_info i2c_pad_info1 = {
	.scl = {
		.i2c_mode = MX7D_PAD_I2C1_SCL__I2C1_SCL | MUX_PAD_CTRL(PAD_CTL_HYS | PAD_CTL_DSE_X4) | MUX_MODE_SION,
		.gpio_mode = MX7D_PAD_I2C1_SCL__GPIO4_IO8 | MUX_PAD_CTRL(PAD_CTL_HYS | PAD_CTL_DSE_X4) | MUX_MODE_SION,
		.gp = IMX_GPIO_NR(4, 8),
	},
	.sda = {
		.i2c_mode = MX7D_PAD_I2C1_SDA__I2C1_SDA | MUX_PAD_CTRL(PAD_CTL_HYS | PAD_CTL_DSE_X4) | MUX_MODE_SION,
		.gpio_mode = MX7D_PAD_I2C1_SDA__GPIO4_IO9 | MUX_PAD_CTRL(PAD_CTL_HYS | PAD_CTL_DSE_X4) | MUX_MODE_SION,
		.gp = IMX_GPIO_NR(4, 9),
	},
};

int dram_init(void)
{
	gd->ram_size = PHYS_SDRAM_SIZE;
	return 0;
}

static iomux_v3_cfg_t const wdog_pads[] = {
	MX7D_PAD_GPIO1_IO00__WDOG1_WDOG_B | MUX_PAD_CTRL(NO_PAD_CTRL),
};

static iomux_v3_cfg_t const uart1_pads[] = {
	MX7D_PAD_UART1_TX_DATA__UART1_DCE_TX | MUX_PAD_CTRL(PAD_CTL_DSE_X2),
	MX7D_PAD_UART1_RX_DATA__UART1_DCE_RX | MUX_PAD_CTRL(PAD_CTL_PUS_PU100KOHM),
};

static iomux_v3_cfg_t const usdhc3_emmc_pads[] = {
	MX7D_PAD_SD3_CLK__SD3_CLK | MUX_PAD_CTRL(PAD_CTL_PUS_PD100KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_CMD__SD3_CMD | MUX_PAD_CTRL(PAD_CTL_PUS_PU47KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_DATA0__SD3_DATA0 | MUX_PAD_CTRL(PAD_CTL_PUS_PU47KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_DATA1__SD3_DATA1 | MUX_PAD_CTRL(PAD_CTL_PUS_PU47KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_DATA2__SD3_DATA2 | MUX_PAD_CTRL(PAD_CTL_PUS_PU47KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_DATA3__SD3_DATA3 | MUX_PAD_CTRL(PAD_CTL_PUS_PU47KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_DATA4__SD3_DATA4 | MUX_PAD_CTRL(PAD_CTL_PUS_PU47KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_DATA5__SD3_DATA5 | MUX_PAD_CTRL(PAD_CTL_PUS_PU47KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_DATA6__SD3_DATA6 | MUX_PAD_CTRL(PAD_CTL_PUS_PU47KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_DATA7__SD3_DATA7 | MUX_PAD_CTRL(PAD_CTL_PUS_PU47KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),
	MX7D_PAD_SD3_STROBE__SD3_STROBE	 | MUX_PAD_CTRL(PAD_CTL_PUS_PD100KOHM | PAD_CTL_HYS | PAD_CTL_DSE_X6),

	MX7D_PAD_SD3_RESET_B__GPIO6_IO11 | MUX_PAD_CTRL(PAD_CTL_DSE_X2),
};

#ifdef CONFIG_USE_400MHZ_DDR
static const int ddrFreq = 400;
#elif defined(CONFIG_USE_533MHZ_DDR)
static const int ddrFreq = 533;
#else
#error "Selection of DDR3 clock frequency is mandatory!!"
#endif

#ifdef CONFIG_USE_PLUGIN
#ifdef CONFIG_USE_LPSR_MODE
static const char * ddrInitMode = "PLUGIN+LPSR";
#else
static const char * ddrInitMode = "PLUGIN";
#endif
#else
static const char * ddrInitMode = "DCD";
#endif

#ifdef CONFIG_FSL_ESDHC

/* emmc reset */
#define USDHC3_PWR_GPIO IMX_GPIO_NR(6, 11)

static struct fsl_esdhc_cfg usdhc_cfg[3] = {
	{USDHC1_BASE_ADDR, 0, 4},
	{USDHC2_BASE_ADDR},
	{USDHC3_BASE_ADDR},
};

int board_mmc_getcd(struct mmc *mmc)
{
	/* card detect */
	struct fsl_esdhc_cfg *cfg = (struct fsl_esdhc_cfg *)mmc->priv;
	int ret = 0;

	switch (cfg->esdhc_base) {
	case USDHC1_BASE_ADDR:
		break;
	case USDHC2_BASE_ADDR:
		break;
	case USDHC3_BASE_ADDR:
		ret = 1; /* Assume uSDHC3 emmc is always present */
		break;
	}

	return ret;
}

int board_mmc_init(bd_t *bis)
{
	int i = 2, ret;
	/*
	 * According to the board_mmc_init() the following map is done:
	 * (U-boot device node)    (Physical Port)
	 * mmc0                    USDHC1
	 * mmc2                    USDHC3 (eMMC)
	 */
	imx_iomux_v3_setup_multiple_pads(usdhc3_emmc_pads, ARRAY_SIZE(usdhc3_emmc_pads));
	gpio_request(USDHC3_PWR_GPIO, "usdhc3_pwr");
	gpio_direction_output(USDHC3_PWR_GPIO, 0);
	udelay(500);
	gpio_direction_output(USDHC3_PWR_GPIO, 1);
	usdhc_cfg[i].sdhc_clk = mxc_get_clock(MXC_ESDHC3_CLK);

	ret = fsl_esdhc_initialize(bis, &usdhc_cfg[i]);
	if (ret)
		return ret;

	return 0;
}

int mmc_get_env_devno(void)
{
	return CONFIG_SYS_MMC_ENV_DEV;
}

uint mmc_get_env_part(struct mmc *mmc)
{
	return CONFIG_SYS_MMC_ENV_PART;
}

void board_late_mmc_init(void)
{
}

/* Helper functions copied from net/eth.c */
void eth_parse_enetaddr(const char *addr, uchar *enetaddr)
{
	char *end;
	int i;

	for (i = 0; i < 6; ++i) {
		enetaddr[i] = addr ? simple_strtoul(addr, &end, 16) : 0;
		if (addr)
			addr = (*end) ? end + 1 : end;
	}
}

int eth_getenv_enetaddr(char *name, uchar *enetaddr)
{
	eth_parse_enetaddr(getenv(name), enetaddr);
	return is_valid_ether_addr(enetaddr);
}

int eth_setenv_enetaddr(char *name, const uchar *enetaddr)
{
	char buf[30];
	sprintf(buf, "0x%02x,0x%02x,0x%02x,0x%02x,0x%02x,0x%02x",
		enetaddr[0],
		enetaddr[1],
		enetaddr[2],
		enetaddr[3],
		enetaddr[4],
		enetaddr[5]);

	return setenv(name, buf);
}

static void read_rpmb(struct NvSharedData *nvdata)
{
	struct mmc *mmc;
	int curr_device = -1;
	int n;
	u16 blk = 0;
	char original_part;

	/* Compile time check of struct size */
	BUILD_BUG_ON(sizeof(struct NvSharedData) == NV_STRUCT_SIZE ? 0 : 1);

	/* Get MMC Device */
	if (get_mmc_num() > 0) {
		curr_device = 0;
	} else {
		puts("No MMC device available\n");
		return;
	}

	mmc = find_mmc_device(curr_device);
	if (!mmc) {
		printf("no mmc device at slot %x\n", curr_device);
		return;
	}
	if (mmc_init(mmc))
		mmc = NULL;
	if (!mmc)
		return;

	/* Switch to RPMB Partition */
	original_part = mmc->part_num;
	if (mmc->part_num != MMC_PART_RPMB) {
		if (mmc_switch_part(curr_device, MMC_PART_RPMB) != 0)
			return;
		mmc->part_num = MMC_PART_RPMB;
	}

	/* rpmb is 256 bytes/blk, nvdata should be 512 bytes */
	n = mmc_rpmb_read(mmc, nvdata, blk, sizeof(*nvdata)/256, NULL);
	if (n != sizeof(*nvdata)/256) {
		printf("ERR: failed to read mac from rpmb\n");
		goto cleanup;
	}

cleanup:
	/* Return to original part */
	if (mmc->part_num != original_part) {
		if (mmc_switch_part(curr_device, original_part) != 0)
			return;
		mmc->part_num = original_part;
	}
}

static int jsoneq(const char *json, jsmntok_t *tok, const char *s)
{
	if (tok->type == JSMN_STRING && (int) strlen(s) == tok->end - tok->start
	    && strncmp(json + tok->start, s, tok->end - tok->start) == 0) {
		return 0;
	}
	return -1;
}

int get_json_token(char *json_str, const char *key, char *token)
{
	int token_len, i, r;

	/* parse instr json string for key : value pair */
	jsmn_parser p;
	jsmntok_t t[20];
	jsmn_init(&p);
	r = jsmn_parse(&p, json_str, INSTRINFO_STRLEN, t,
		       sizeof(t)/sizeof(t[0]));
	if (r < 0) {
		printf("Failed to parse JSON: %d\n", r);
		return -1;
	}

	if ( r < 1 || t[0].type != JSMN_OBJECT) {
		printf("Object expected\n");
		return -1;
	}

	/* Loop over all keys of the root object */
	for (i=1; i < r; i++) {
		if (jsoneq(json_str, &t[i], key) == 0) {
			token_len = t[i+1].end - t[i+1].start;
			snprintf(token, token_len + 1, "%.*s", token_len,
				 json_str + t[i+1].start);
			return token_len;
		}
	}
	return -1;
}
#endif

int board_eth_init(bd_t *bis)
{
	return 0;
}


int board_early_init_f(void)
{
	imx_iomux_v3_setup_multiple_pads(uart1_pads, ARRAY_SIZE(uart1_pads));

	void *snvsbase = (void *)SNVS_BASE_ADDR;
#ifdef CONFIG_USE_LPSR_MODE
	/* Communication with an i.MX Community user named Jacob
	   Postman provided information from Freescale that helped him get
	   transitions on GPIO1 to trigger exit from LPSR mode.  The RM shows
	   that this is the LPTDCR (SNVS_LP Tamper Dectectors Configuration),
	   and the bit being set is the "wire mesh tampering 1 enable" but
	   there is no description of why this is related to GPIO1
	*/
	__raw_writel(0x80, snvsbase + 0x48);

	/* This is a complete hack job to try to handle pad control
	   of signals that are connected to GPIO1_IO8...GPIO1_IO15 which appear
	   to have a special method of configuring their pad control.  See the
	   RM sections on IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR20 (0x3027_0050) and
	   IOMUXC_LPSR_GPR_IOMUXC_LPSR_GPR21 (0x3027_0054).
	*/

	/* GPIO1_IO11 (KEY-HOME*)   - input, 47k pu+pe, hyst, slow, X1
	   GPIO1_IO10               - pad ctl from SOC IOMUX
	   GPIO1_IO09 (KEY-TEST*)   - input, 47k pu+pe, hyst, slow, X1
	   GPIO1_IO08 (PC-XRESET*)  - output, no pu/pd, slow, X1
	*/
	void *gprbase = (void *)IOMUXC_LPSR_GPR_BASE_ADDR;
	u32 pad_ctrl = 0xdc00dc84;
	__raw_writel(pad_ctrl, gprbase + 0x50);    /* GPR20, bits 11..8 */

	/* This is for Rev006 PCAs
	   GPIO1_IO15               - pad ctl from SOC IOMUX
	   GPIO1_IO14               - pad ctl from SOC IOMUX
	   GPIO1_IO13 (PCAP-INT*)   - input, 47k pu+pe, hyst, slow, X1
	   GPIO1_IO12 (PCAP-RESET*) - output, no pu/pd, slow, X1
	*/
	pad_ctrl = 0x0000dc84;
	__raw_writel(pad_ctrl, gprbase + 0x54);    /* GPR21, bits 15..12 */
#else
	/* make sure the wire mesh tampering 1 enable bit is cleared,
	   because if it is set in a non-LPSR system then a power-off
	   simply results in the system powering up again.
	*/
	__raw_writel(0x0, snvsbase + 0x48);
#endif

	setup_i2c(0, CONFIG_SYS_I2C_SPEED, 0x7f, &i2c_pad_info1);

	return 0;
}

int board_init(void)
{
	int ret;

	/* address of boot parameters */
	gd->bd->bi_boot_params = PHYS_SDRAM + 0x00200100;

	ret = set_clk_enet(ENET_50MHz);
	if (ret)
		return ret;

	return 0;
}

#ifdef CONFIG_CMD_BMODE
static const struct boot_mode board_boot_modes[] = {
	/* 4 bit bus width */
	{"sd1", MAKE_CFGVAL(0x10, 0x10, 0x00, 0x00)},
	{"emmc", MAKE_CFGVAL(0x10, 0x2a, 0x00, 0x00)},
	{NULL,   0},
};
#endif

#ifdef CONFIG_POWER
#define I2C_PMIC	0
int power_init_board(void)
{
	struct pmic *p;
	int ret;
	unsigned int reg, regm, rev_id;

	ret = power_pfuze300_init(I2C_PMIC);
	if (ret)
		return ret;

	p = pmic_get("PFUZE300");
	ret = pmic_probe(p);
	if (ret)
		return ret;

	pmic_reg_read(p, PFUZE300_DEVICEID, &reg);
	pmic_reg_read(p, PFUZE300_REVID, &rev_id);
	printf("PMIC: PFUZE300 DEV_ID=0x%x REV_ID=0x%x\n", reg, rev_id);

	/* disable Low Power Mode during standby mode */
	pmic_reg_read(p, PFUZE300_LDOGCTL, &reg);
	reg |= 0x1;
	pmic_reg_write(p, PFUZE300_LDOGCTL, reg);

	/* SW1A/1B mode set to APS/APS for normal/stby states*/
	reg = 0x8;
	pmic_reg_write(p, PFUZE300_SW1AMODE, reg);
	pmic_reg_write(p, PFUZE300_SW1BMODE, reg);

	/* SW1A standby voltage set to 1.000V */
	pmic_reg_read(p, PFUZE300_SW1ASTBY, &reg);
	reg &= ~0x1f;
	reg |= PFUZE300_SW1AB_SETP(1000);
	pmic_reg_write(p, PFUZE300_SW1ASTBY, reg);

#ifdef STBY_NO_VLDO4
	/* LDO4 powers the LCD, so turn it off when in
	   standby to save extra power.
	*/
	pmic_reg_read(p, PFUZE300_VLDO4CTL, &reg);
	regm = reg | 0x20;
	pmic_reg_write(p, PFUZE300_VLDO4CTL, regm);
#endif

#ifdef CONFIG_USE_LPSR_MODE
	/* we only use LPSR mode with the plugin,
	   so leave the DDR memory powered as well
	   as the VLDO1 and VLDO3 power supplies
	*/
	pmic_reg_read(p, PFUZE300_SW3MODE, &reg);
	regm = reg | 0x20;
	pmic_reg_write(p, PFUZE300_SW3MODE, regm);

	pmic_reg_read(p, PFUZE300_VLDO1CTL, &reg);
	regm = reg | 0x80;
	pmic_reg_write(p, PFUZE300_VLDO1CTL, regm);

	pmic_reg_read(p, PFUZE300_VLDO3CTL, &reg);
	regm = reg | 0x80;
	pmic_reg_write(p, PFUZE300_VLDO3CTL, regm);
#endif

	/* turn off the following regulators as they
	   are not used in this design */
	pmic_reg_read(p, PFUZE300_VCC_SDCTL, &reg);
	regm = reg & ~0x10;
	pmic_reg_write(p, PFUZE300_VCC_SDCTL, regm);

	pmic_reg_read(p, PFUZE300_VLDO2CTL, &reg);
	regm = reg & ~0x10;
	pmic_reg_write(p, PFUZE300_VLDO2CTL, regm);

	/* enable coin cell charger */
	/* bit values
		0x08	enable
		0x06	charger voltage == +3.2V
		0x07	charger voltage == +3.3V
	*/
	reg = 0x0e;
	pmic_reg_write(p, PFUZE300_COINCTL, reg);

	return 0;
}
#endif

int board_late_init(void)
{
#ifdef CONFIG_CMD_BMODE
	add_board_boot_modes(board_boot_modes);
#endif

#ifdef CONFIG_ENV_IS_IN_MMC
	board_late_mmc_init();
#endif

	imx_iomux_v3_setup_multiple_pads(wdog_pads, ARRAY_SIZE(wdog_pads));

#ifdef CONFIG_ENV_RPMB
	struct NvSharedData nvdata;
	uchar enetaddr[6];
	char regdomain[5];
	int n = 0;

	read_rpmb(&nvdata);
	/* If magic doesn't match, do nothing */
	if (nvdata.nvHdr.magic != NVHDR_MAGIC) {
		return 0;
	}

	/* Set ethaddr */
	eth_parse_enetaddr(nvdata.enetAddr, enetaddr);
	if (is_valid_ether_addr(enetaddr))
		eth_setenv_enetaddr("ethaddr", enetaddr);

	/* Set regdomain */
	n = get_json_token(nvdata.instrString, "reg_domain", regdomain);
	if (n > 0)
		setenv("regdomain", regdomain);
#endif
	return 0;
}

int misc_init_r(void)
{
	return 0;
}

int checkboard(void)
{
	printf("Board: i.MX7D Heartland Board Rev0\n");
	printf("DDR3L: %dMHz, init mode %s\n", ddrFreq, ddrInitMode);

	return 0;
}

