#ifndef _DT_BINDINGS_PINCTRL_IMX35_H
#define _DT_BINDINGS_PINCTRL_IMX35_H

#define NO_PAD_CTRL			(1 << 31)
#define PAD_CTL_DVS			(1 << 13)
#define PAD_CTL_HYS			(1 << 8)

#define PAD_CTL_PKE			(1 << 7)
#define PAD_CTL_PUE			(1 << 6 | PAD_CTL_PKE)
#define PAD_CTL_PUS_100K_DOWN		(0 << 4 | PAD_CTL_PUE)
#define PAD_CTL_PUS_47K_UP		(1 << 4 | PAD_CTL_PUE)
#define PAD_CTL_PUS_100K_UP		(2 << 4 | PAD_CTL_PUE)
#define PAD_CTL_PUS_22K_UP		(3 << 4 | PAD_CTL_PUE)

#define PAD_CTL_ODE			(1 << 3)

#define PAD_CTL_DSE_LOW			(0 << 1)
#define PAD_CTL_DSE_MED			(1 << 1)
#define PAD_CTL_DSE_HIGH		(2 << 1)
#define PAD_CTL_DSE_MAX			(3 << 1)

#define PAD_CTL_SRE_FAST		(1 << 0)
#define PAD_CTL_SRE_SLOW		(0 << 0)

#define IOMUX_CONFIG_SION		(1 << 30)

#if 0
/* see Documentation/devicetree/bindings/pinctrl/fsl,imx35-pinctrl.txt */
#define PAD_CTL_DRIVE_VOLAGAGE_18	(1 << 13)
#define PAD_CTL_DRIVE_VOLAGAGE_33	(0 << 13)
#define PAD_CTL_HYS			(1 << 8)
#define PAD_CTL_PKE			(1 << 7)
#define PAD_CTL_PUE			(1 << 6)
#define PAD_CTL_PUS_100K_DOWN		(0 << 4)
#define PAD_CTL_PUS_47K_UP		(1 << 4)
#define PAD_CTL_PUS_100K_UP		(2 << 4)
#define PAD_CTL_PUS_22K_UP		(3 << 4)
#define PAD_CTL_ODE_CMOS		(0 << 3)
#define PAD_CTL_ODE_OPENDRAIN		(1 << 3)
#define PAD_CTL_DSE_NOMINAL		(0 << 1)
#define PAD_CTL_DSE_HIGH		(1 << 1)
#define PAD_CTL_DSE_MAX			(2 << 1)
#define PAD_CTL_SRE_FAST		(1 << 0)
#define PAD_CTL_SRE_SLOW		(0 << 0)
#endif

/* There's a off-by-one betweem the gpio bank number and the gpiochip */
/* range e.g. GPIO_1_5 is gpio 5 under linux */
#define IMX_GPIO_NR(bank, nr)		(((bank) - 1) * 32 + (nr))

#endif
