/* fileargs.h - routines to expand command line @ references
   
   The idea here is that wherever you can put a file name on
   a command line you should be able to substitute a reference
   to a list of files of the form @<list_file>. Here
   <list_file> contains a list of newline seperated files.
   Trailing whitespace on each line is ignored.

   For example

   ar mylib.a @myfiles
 */

/* a file_list is simply a linked list of file names
  
   as usual an object, flist, of type file_list is an "iterator"
   that points into the list: the file name at that point is
   flist -> str; the iterator can be advanced one step with
   flist = flist -> next; advancing one step past the final
   node results in (!flist). */

typedef struct tag_file_list_node
  { 
    struct tag_file_list_node *next;
	char *str;
	
  } file_list_node, *file_list;


/* take a command line argument which can either be a filename
   or an @ reference and returns a file list in which any @ reference
   has been expanded. */
  
extern file_list get_file_list_from_arg (char *arg);

/* takes an array of names and returns an array in which
   @ references have been expanded. */

extern char **expand_file_list (char **files);

