/*
  Seeeduino XIAO Digital I/O Demo
  xiao-digital-io-test.ino
  Displays operation of XIAO digital inputs and outputs
  Results displayed on serial monitor

  DroneBot Workshop 2020
  https://dronebotworkshop.com
*/

// Pushbutton input
#define BUTTON 7

// LED output
#define LED 9

// Variable to hold state of pushbutton
boolean buttonState;

void setup()
{
    // Setup the pushbutton as an input and enable internal pullup
    pinMode(BUTTON, INPUT_PULLUP);
    
    // Setup the LED as an output
    pinMode(LED, OUTPUT);
    
    // Also define the builtin LED as an output
    pinMode(LED_BUILTIN, OUTPUT);
    
    // Setup Serial Port
    SerialUSB.begin(9600);

}

void loop()
{
    // Get the pushbutton state and assign it to the variable
    buttonState = digitalRead(BUTTON);
    
    // Print pushbutton state to serial monitor
    SerialUSB.println(buttonState);
    
    // Set the LED according to pushbutton state
    digitalWrite(LED, buttonState);
    
     // Set the builtin LED according to pushbutton state
    digitalWrite(LED_BUILTIN, buttonState);
    
}
    
    
    
