/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.tk.quantum.GestureRecognizers;
import com.sun.javafx.tk.quantum.GlassEventUtils;
import com.sun.javafx.tk.quantum.GlassPrismInputMethodEvent;
import com.sun.javafx.tk.quantum.GlassPrismKeyEvent;
import com.sun.javafx.tk.quantum.GlassPrismMouseEvent;
import com.sun.javafx.tk.quantum.GlassSceneDnDEventHandler;
import com.sun.javafx.tk.quantum.PaintCollector;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.SwipeGestureRecognizer;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.javafx.tk.quantum.WindowStage;
import com.sun.prism.impl.PrismSettings;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.input.RotateEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.SwipeEvent;
import javafx.scene.input.TouchPoint;
import javafx.scene.input.TransferMode;
import javafx.scene.input.ZoomEvent;

public class GlassViewEventHandler
extends View.EventHandler {
    private static boolean verbose = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("quantum.verbose");
        }
    });
    private ViewScene scene;
    private int initialWidth;
    private int initialHeight;
    private final GlassSceneDnDEventHandler dndHandler;
    private GestureRecognizers gestures = new GestureRecognizers();
    private final QuantumToolkit toolkit = (QuantumToolkit)QuantumToolkit.getToolkit();
    private final PaintCollector collector = PaintCollector.getInstance();
    private boolean dragPerformed = false;
    private int mouseButtonPressedMask = 0;
    private ClipboardAssistance dropSourceAssistant;

    public GlassViewEventHandler(ViewScene viewScene) {
        this.scene = viewScene;
        this.initialWidth = 0;
        this.initialHeight = 0;
        this.dndHandler = new GlassSceneDnDEventHandler(viewScene, null, verbose);
        if (PlatformUtil.isWindows()) {
            this.gestures.add(new SwipeGestureRecognizer(viewScene));
        }
    }

    private boolean allowableFullScreenKeys(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    private boolean checkFullScreenKeyEvent(int n, int n2, char[] cArray, int n3) {
        if (!this.scene.getWindowStage().isTrustedFullScreen()) {
            return this.allowableFullScreenKeys(n2);
        }
        return true;
    }

    private boolean toolkit() {
        GlassViewEventHandler glassViewEventHandler = this;
        return glassViewEventHandler.toolkit.getFxUserThread() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleKeyEvent(View view, long l, int n, int n2, char[] cArray, int n3) {
        if (!this.toolkit()) {
            return;
        }
        GlassPrismKeyEvent glassPrismKeyEvent = null;
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            switch (n) {
                case 111: {
                    if (n2 == 27 && view.isInFullscreen() && windowStage != null) {
                        windowStage.exitFullScreen();
                    }
                }
                case 112: 
                case 113: {
                    if (view.isInFullscreen() && !this.checkFullScreenKeyEvent(n, n2, cArray, n3)) {
                        return;
                    } else {
                        if (this.scene.sceneListener == null) return;
                        glassPrismKeyEvent = new GlassPrismKeyEvent(this.scene, n, n2, cArray, n3);
                        this.scene.sceneListener.keyEvent(glassPrismKeyEvent);
                        return;
                    }
                }
                default: {
                    if (!verbose) return;
                    System.out.println("handleKeyEvent: unhandled type: " + n);
                    return;
                }
            }
        }
        catch (RuntimeException runtimeException) {
            if (!verbose) throw runtimeException;
            runtimeException.printStackTrace();
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (!verbose) throw new RuntimeException(throwable);
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    @Override
    public void handleMouseEvent(View view, long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, boolean bl2) {
        int n9;
        if (!this.toolkit()) {
            return;
        }
        boolean bl3 = this.dragPerformed;
        GlassPrismMouseEvent glassPrismMouseEvent = null;
        switch (n2) {
            case 212: {
                n9 = 32;
                break;
            }
            case 214: {
                n9 = 128;
                break;
            }
            case 213: {
                n9 = 64;
                break;
            }
            default: {
                n9 = 0;
            }
        }
        switch (n) {
            case 224: {
                if (n2 == 211) break;
                return;
            }
            case 222: {
                if ((this.mouseButtonPressedMask & n9) == 0) {
                    return;
                }
                this.mouseButtonPressedMask &= ~n9;
                break;
            }
            case 223: {
                this.dragPerformed = true;
                break;
            }
            case 221: {
                this.dragPerformed = false;
                this.mouseButtonPressedMask |= n9;
                break;
            }
            case 225: 
            case 226: {
                break;
            }
            default: {
                if (!verbose) break;
                System.out.println("handleMouseEvent: unhandled type: " + n);
            }
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            if (this.scene.sceneListener != null) {
                glassPrismMouseEvent = new GlassPrismMouseEvent(this.scene, n, n2, n3, n4, n5, n6, n7, n8, bl, bl2, 0.0);
                this.scene.sceneListener.mouseEvent(glassPrismMouseEvent);
            }
            if (n == 222 && !bl3 && this.scene.sceneListener != null && this.toolkit()) {
                glassPrismMouseEvent = new GlassPrismMouseEvent(this.scene, 227, n2, n3, n4, n5, n6, n7, n8, bl, bl2, 0.0);
                this.scene.sceneListener.mouseEvent(glassPrismMouseEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    @Override
    public void handleMenuEvent(View view, int n, int n2, int n3, int n4, boolean bl) {
        if (!this.toolkit()) {
            return;
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.menuEvent(n, n2, n3, n4, bl);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    @Override
    public void handleScrollEvent(View view, long l, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, int n7, int n8, int n9, double d3, double d4) {
        if (!this.toolkit()) {
            return;
        }
        Object var21_16 = null;
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            if (windowStage != null) {
                windowStage.setInEventHandler(true);
            }
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.scrollEvent(ScrollEvent.SCROLL, d, d2, 0.0, 0.0, d3, d4, 0, n7, n6, n9, n8, n, n2, n3, n4, (n5 & 1) != 0, (n5 & 4) != 0, (n5 & 8) != 0, (n5 & 0x10) != 0, false, false);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            if (windowStage != null) {
                windowStage.setInEventHandler(false);
            }
        }
    }

    @Override
    public void handleInputMethodEvent(long l, String string, int[] nArray, int[] nArray2, byte[] byArray, int n, int n2) {
        try {
            if (this.scene.sceneListener != null && this.toolkit()) {
                GlassPrismInputMethodEvent glassPrismInputMethodEvent = new GlassPrismInputMethodEvent(this.scene, string, nArray, nArray2, byArray, n, n2);
                this.scene.sceneListener.inputMethodEvent(glassPrismInputMethodEvent);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public double[] getInputMethodCandidatePos(int n) {
        Point2D point2D = this.scene.inputMethodRequests.getTextLocation(n);
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        return dArray;
    }

    @Override
    public int handleDragEnter(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = this.dndHandler.handleDragEnter(n, n2, n3, n4, n5, clipboardAssistance);
        return GlassSceneDnDEventHandler.TransferModeToAction(transferMode);
    }

    @Override
    public void handleDragLeave(View view, ClipboardAssistance clipboardAssistance) {
        this.dndHandler.handleDragLeave(clipboardAssistance);
    }

    @Override
    public int handleDragDrop(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = this.dndHandler.handleDragDrop(n, n2, n3, n4, n5, clipboardAssistance);
        return GlassSceneDnDEventHandler.TransferModeToAction(transferMode);
    }

    @Override
    public int handleDragOver(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        TransferMode transferMode = this.dndHandler.handleDragOver(n, n2, n3, n4, n5, clipboardAssistance);
        return GlassSceneDnDEventHandler.TransferModeToAction(transferMode);
    }

    @Override
    public void handleDragStart(View view, int n, int n2, int n3, int n4, int n5, ClipboardAssistance clipboardAssistance) {
        this.dropSourceAssistant = clipboardAssistance;
        this.dndHandler.handleDragStart(n, n2, n3, n4, n5, clipboardAssistance);
    }

    @Override
    public void handleDragEnd(View view, int n) {
        this.dndHandler.handleDragEnd(n, this.dropSourceAssistant);
    }

    @Override
    public void handleViewEvent(View view, long l, int n) {
        if (verbose) {
            System.err.println("handleViewEvent(" + System.nanoTime() + "): " + GlassEventUtils.getViewEventString(n) + PaintCollector.sceneSize(this.scene) + " closed: " + view.isClosed());
        }
        if (this.scene.sceneListener == null || !this.toolkit()) {
            return;
        }
        try {
            switch (n) {
                case 431: {
                    Window window = view.getWindow();
                    if (window != null && window.getMinimumWidth() == view.getWidth() && !window.isVisible()) break;
                    this.scene.entireSceneNeedsRepaint();
                    if (PlatformUtil.isMac()) {
                        this.collector.liveRepaintRenderJob(this.scene);
                    }
                    break;
                }
                case 432: {
                    if (PrismSettings.verbose) {
                        System.out.println("RESIZE: " + System.nanoTime() + " w: " + view.getWidth() + " h: " + view.getHeight());
                    }
                    this.scene.sceneListener.changedSize(view.getWidth(), view.getHeight());
                    this.scene.entireSceneNeedsRepaint();
                    break;
                }
                case 433: {
                    this.scene.sceneListener.changedLocation(view.getX(), view.getY());
                    break;
                }
                case 441: 
                case 442: {
                    if (this.scene.getWindowStage() != null) {
                        this.scene.getWindowStage().fullscreenChanged(n == 441);
                    }
                    break;
                }
                case 411: 
                case 412: 
                case 421: 
                case 422: {
                    break;
                }
                default: {
                    throw new RuntimeException("handleViewEvent: unhandled type: " + n);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public void handleScrollGestureEvent(View view, long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, double d, double d2, double d3, double d4) {
        if (!this.toolkit()) {
            return;
        }
        Object var21_16 = null;
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            windowStage.setInEventHandler(true);
            if (this.scene.sceneListener != null) {
                EventType<ScrollEvent> eventType = ScrollEvent.SCROLL;
                switch (n) {
                    case 1: {
                        eventType = ScrollEvent.SCROLL_STARTED;
                        break;
                    }
                    case 2: {
                        eventType = ScrollEvent.SCROLL;
                        break;
                    }
                    case 3: {
                        eventType = ScrollEvent.SCROLL_FINISHED;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown scroll event type: " + n);
                    }
                }
                this.scene.sceneListener.scrollEvent(eventType, d, d2, d3, d4, 1.0, 1.0, n3, 0, 0, 0, 0, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, n7 == Integer.MAX_VALUE ? Double.NaN : (double)n7, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl, bl2);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            windowStage.setInEventHandler(false);
        }
    }

    @Override
    public void handleZoomGestureEvent(View view, long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, double d, double d2, double d3, double d4) {
        if (!this.toolkit()) {
            return;
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            windowStage.setInEventHandler(true);
            if (this.scene.sceneListener != null) {
                EventType<ZoomEvent> eventType = ZoomEvent.ZOOM;
                switch (n) {
                    case 1: {
                        eventType = ZoomEvent.ZOOM_STARTED;
                        break;
                    }
                    case 2: {
                        eventType = ZoomEvent.ZOOM;
                        break;
                    }
                    case 3: {
                        eventType = ZoomEvent.ZOOM_FINISHED;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown scroll event type: " + n);
                    }
                }
                this.scene.sceneListener.zoomEvent(eventType, d, d3, n3 == Integer.MAX_VALUE ? Double.NaN : (double)n3, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl, bl2);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            windowStage.setInEventHandler(false);
        }
    }

    @Override
    public void handleRotateGestureEvent(View view, long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, double d, double d2) {
        if (!this.toolkit()) {
            return;
        }
        Object var16_13 = null;
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            windowStage.setInEventHandler(true);
            if (this.scene.sceneListener != null) {
                EventType<RotateEvent> eventType = RotateEvent.ROTATE;
                switch (n) {
                    case 1: {
                        eventType = RotateEvent.ROTATION_STARTED;
                        break;
                    }
                    case 2: {
                        eventType = RotateEvent.ROTATE;
                        break;
                    }
                    case 3: {
                        eventType = RotateEvent.ROTATION_FINISHED;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown scroll event type: " + n);
                    }
                }
                this.scene.sceneListener.rotateEvent(eventType, d, d2, n3 == Integer.MAX_VALUE ? Double.NaN : (double)n3, n4 == Integer.MAX_VALUE ? Double.NaN : (double)n4, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl, bl2);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            windowStage.setInEventHandler(false);
        }
    }

    @Override
    public void handleSwipeGestureEvent(View view, long l, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (!this.toolkit()) {
            return;
        }
        Object var14_13 = null;
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            windowStage.setInEventHandler(true);
            if (this.scene.sceneListener != null) {
                EventType<SwipeEvent> eventType = null;
                switch (n4) {
                    case 1: {
                        eventType = SwipeEvent.SWIPE_UP;
                        break;
                    }
                    case 2: {
                        eventType = SwipeEvent.SWIPE_DOWN;
                        break;
                    }
                    case 3: {
                        eventType = SwipeEvent.SWIPE_LEFT;
                        break;
                    }
                    case 4: {
                        eventType = SwipeEvent.SWIPE_RIGHT;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown swipe event direction: " + n4);
                    }
                }
                this.scene.sceneListener.swipeEvent(eventType, n3, n5 == Integer.MAX_VALUE ? Double.NaN : (double)n5, n6 == Integer.MAX_VALUE ? Double.NaN : (double)n6, n7 == Integer.MAX_VALUE ? Double.NaN : (double)n7, n8 == Integer.MAX_VALUE ? Double.NaN : (double)n8, (n2 & 1) != 0, (n2 & 4) != 0, (n2 & 8) != 0, (n2 & 0x10) != 0, bl);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            windowStage.setInEventHandler(false);
        }
    }

    @Override
    public void handleBeginTouchEvent(View view, long l, int n, boolean bl, int n2) {
        if (!this.toolkit()) {
            return;
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            windowStage.setInEventHandler(true);
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.touchEventBegin(l, n2, bl, (n & 1) != 0, (n & 4) != 0, (n & 8) != 0, (n & 0x10) != 0);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            windowStage.setInEventHandler(false);
        }
        this.gestures.notifyBeginTouchEvent(l, n, bl, n2);
    }

    @Override
    public void handleNextTouchEvent(View view, long l, int n, long l2, int n2, int n3, int n4, int n5) {
        if (!this.toolkit()) {
            return;
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            windowStage.setInEventHandler(true);
            if (this.scene.sceneListener != null) {
                TouchPoint.State state = null;
                switch (n) {
                    case 811: {
                        state = TouchPoint.State.PRESSED;
                        break;
                    }
                    case 812: {
                        state = TouchPoint.State.MOVED;
                        break;
                    }
                    case 814: {
                        state = TouchPoint.State.STATIONARY;
                        break;
                    }
                    case 813: {
                        state = TouchPoint.State.RELEASED;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown touch state: " + (Object)((Object)state));
                    }
                }
                this.scene.sceneListener.touchEventNext(state, l2, n2, n3, n4, n5);
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            windowStage.setInEventHandler(false);
        }
        this.gestures.notifyNextTouchEvent(l, n, l2, n2, n3, n4, n5);
    }

    @Override
    public void handleEndTouchEvent(View view, long l) {
        if (!this.toolkit()) {
            return;
        }
        WindowStage windowStage = this.scene.getWindowStage();
        try {
            windowStage.setInEventHandler(true);
            if (this.scene.sceneListener != null) {
                this.scene.sceneListener.touchEventEnd();
            }
        }
        catch (RuntimeException runtimeException) {
            if (verbose) {
                runtimeException.printStackTrace();
            }
            throw runtimeException;
        }
        catch (Throwable throwable) {
            if (verbose) {
                throwable.printStackTrace();
            }
            throw new RuntimeException(throwable);
        }
        finally {
            windowStage.setInEventHandler(false);
        }
        this.gestures.notifyEndTouchEvent(l);
    }
}

