/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.spi;

import com.sun.xml.internal.ws.api.BindingID;
import com.sun.xml.internal.ws.api.WSService;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.server.BoundEndpoint;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import com.sun.xml.internal.ws.api.server.Module;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.client.WSServiceDelegate;
import com.sun.xml.internal.ws.developer.MemberSubmissionEndpointReference;
import com.sun.xml.internal.ws.model.wsdl.WSDLModelImpl;
import com.sun.xml.internal.ws.resources.ProviderApiMessages;
import com.sun.xml.internal.ws.transport.http.server.EndpointImpl;
import com.sun.xml.internal.ws.util.ServiceFinder;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import com.sun.xml.internal.ws.wsdl.parser.RuntimeWSDLParser;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.spi.Invoker;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.spi.ServiceDelegate;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class ProviderImpl
extends Provider {
    private static final JAXBContext eprjc = ProviderImpl.getEPRJaxbContext();
    public static final ProviderImpl INSTANCE = new ProviderImpl();

    @Override
    public Endpoint createEndpoint(String string, Object object) {
        return new EndpointImpl(string != null ? BindingID.parse(string) : BindingID.parse(object.getClass()), object, new WebServiceFeature[0]);
    }

    public ServiceDelegate createServiceDelegate(URL uRL, QName qName, Class clazz) {
        return new WSServiceDelegate(uRL, qName, (Class<? extends Service>)clazz);
    }

    public ServiceDelegate createServiceDelegate(URL uRL, QName qName, Class clazz, WebServiceFeature ... webServiceFeatureArray) {
        if (webServiceFeatureArray.length > 0) {
            throw new WebServiceException("Doesn't support any Service specific features");
        }
        return new WSServiceDelegate(uRL, qName, (Class<? extends Service>)clazz);
    }

    @Override
    public Endpoint createAndPublishEndpoint(String string, Object object) {
        EndpointImpl endpointImpl = new EndpointImpl(BindingID.parse(object.getClass()), object, new WebServiceFeature[0]);
        ((Endpoint)endpointImpl).publish(string);
        return endpointImpl;
    }

    @Override
    public Endpoint createEndpoint(String string, Object object, WebServiceFeature ... webServiceFeatureArray) {
        return new EndpointImpl(string != null ? BindingID.parse(string) : BindingID.parse(object.getClass()), object, webServiceFeatureArray);
    }

    @Override
    public Endpoint createAndPublishEndpoint(String string, Object object, WebServiceFeature ... webServiceFeatureArray) {
        EndpointImpl endpointImpl = new EndpointImpl(BindingID.parse(object.getClass()), object, webServiceFeatureArray);
        ((Endpoint)endpointImpl).publish(string);
        return endpointImpl;
    }

    public Endpoint createEndpoint(String string, Class clazz, Invoker invoker, WebServiceFeature ... webServiceFeatureArray) {
        return new EndpointImpl(string != null ? BindingID.parse(string) : BindingID.parse(clazz), clazz, invoker, webServiceFeatureArray);
    }

    @Override
    public EndpointReference readEndpointReference(final Source source) {
        return AccessController.doPrivileged(new PrivilegedAction<EndpointReference>(){

            @Override
            public EndpointReference run() {
                try {
                    Unmarshaller unmarshaller = eprjc.createUnmarshaller();
                    return (EndpointReference)unmarshaller.unmarshal(source);
                }
                catch (JAXBException jAXBException) {
                    throw new WebServiceException("Error creating Marshaller or marshalling.", jAXBException);
                }
            }
        });
    }

    @Override
    public <T> T getPort(EndpointReference endpointReference, Class<T> clazz, WebServiceFeature ... webServiceFeatureArray) {
        if (endpointReference == null) {
            throw new WebServiceException(ProviderApiMessages.NULL_EPR());
        }
        WSEndpointReference wSEndpointReference = new WSEndpointReference(endpointReference);
        WSEndpointReference.Metadata metadata = wSEndpointReference.getMetaData();
        if (metadata.getWsdlSource() == null) {
            throw new WebServiceException("WSDL metadata is missing in EPR");
        }
        WSServiceDelegate wSServiceDelegate = new WSServiceDelegate(metadata.getWsdlSource(), metadata.getServiceName(), Service.class);
        return ((WSService)wSServiceDelegate).getPort(wSEndpointReference, clazz, webServiceFeatureArray);
    }

    @Override
    public W3CEndpointReference createW3CEndpointReference(String string, QName qName, QName qName2, List<Element> list, String string2, List<Element> list2) {
        return this.createW3CEndpointReference(string, null, qName, qName2, list, string2, list2, null, null);
    }

    @Override
    public W3CEndpointReference createW3CEndpointReference(String string, QName qName, QName qName2, QName qName3, List<Element> list, String string2, List<Element> list2, List<Element> list3, Map<QName, String> map) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Container container = ContainerResolver.getInstance().getContainer();
        if (string == null) {
            if (qName2 == null || qName3 == null) {
                throw new IllegalStateException(ProviderApiMessages.NULL_ADDRESS_SERVICE_ENDPOINT());
            }
            object5 = container.getSPI(Module.class);
            if (object5 != null) {
                object4 = ((Module)object5).getBoundEndpoints();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (BoundEndpoint)object3.next();
                    object = object2.getEndpoint();
                    if (!((WSEndpoint)object).getServiceName().equals(qName2) || !((WSEndpoint)object).getPortName().equals(qName3)) continue;
                    try {
                        string = object2.getAddress().toString();
                    }
                    catch (WebServiceException webServiceException) {}
                    break;
                }
            }
            if (string == null) {
                throw new IllegalStateException(ProviderApiMessages.NULL_ADDRESS());
            }
        }
        if (qName2 == null && qName3 != null) {
            throw new IllegalStateException(ProviderApiMessages.NULL_SERVICE());
        }
        object5 = null;
        if (string2 != null) {
            try {
                object4 = XmlUtil.createDefaultCatalogResolver();
                object3 = new URL(string2);
                object2 = RuntimeWSDLParser.parse((URL)object3, (Source)new StreamSource(((URL)object3).toExternalForm()), (EntityResolver)object4, true, container, ServiceFinder.find(WSDLParserExtension.class).toArray());
                if (qName2 != null) {
                    WSDLPort wSDLPort;
                    object = ((WSDLModelImpl)object2).getService(qName2);
                    if (object == null) {
                        throw new IllegalStateException(ProviderApiMessages.NOTFOUND_SERVICE_IN_WSDL(qName2, string2));
                    }
                    if (qName3 != null && (wSDLPort = object.get(qName3)) == null) {
                        throw new IllegalStateException(ProviderApiMessages.NOTFOUND_PORT_IN_WSDL(qName3, qName2, string2));
                    }
                    object5 = qName2.getNamespaceURI();
                } else {
                    object = ((WSDLModelImpl)object2).getFirstServiceName();
                    object5 = ((QName)object).getNamespaceURI();
                }
            }
            catch (Exception exception) {
                throw new IllegalStateException(ProviderApiMessages.ERROR_WSDL(string2), exception);
            }
        }
        return new WSEndpointReference(AddressingVersion.fromSpecClass(W3CEndpointReference.class), string, qName2, qName3, qName, list, string2, (String)object5, list2, list3, map).toSpec(W3CEndpointReference.class);
    }

    private static JAXBContext getEPRJaxbContext() {
        return AccessController.doPrivileged(new PrivilegedAction<JAXBContext>(){

            @Override
            public JAXBContext run() {
                try {
                    return JAXBContext.newInstance(MemberSubmissionEndpointReference.class, W3CEndpointReference.class);
                }
                catch (JAXBException jAXBException) {
                    throw new WebServiceException("Error creating JAXBContext for W3CEndpointReference. ", jAXBException);
                }
            }
        });
    }
}

