/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.ui;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.uitoolkit.ui.UIFactory;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.VersionID;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.JavaFXRuntimeDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.ui.AutoDownloadPrompt;
import com.sun.javaws.util.JfxHelper;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class SecureStaticVersioning {
    private static final String SSV2VERSION_KEY = "ssv.version.allowed";
    private static final String SSV2LATEST_VALUE = "ssv.latest.allowed";
    private static HashMap session = new HashMap();

    public static boolean promptDownload(Object object, LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, String string, String string2) {
        String string3 = ResourceManager.getString((String)"javaws.ssv.title");
        String string4 = ResourceManager.getString((String)"javaws.ssv.download.masthead");
        String string5 = ResourceManager.getString((String)"javaws.ssv.download.bullet", (String)string, (String)string2);
        String string6 = ResourceManager.getString((String)"javaws.ssv.download.button");
        String string7 = ResourceManager.getString((String)"common.cancel_btn");
        UIFactory uIFactory = ToolkitStore.getUI();
        AppInfo appInfo = launchDesc.getAppInfo();
        ToolkitStore.getUI();
        int n = uIFactory.showMessageDialog(object, appInfo, 3, string3, null, string4, string5, string6, string7, null);
        ToolkitStore.getUI();
        if (n == 0) {
            if (localApplicationProperties != null) {
                localApplicationProperties.put(SSV2VERSION_KEY, string);
                try {
                    localApplicationProperties.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean promptUse(Component component, AppInfo appInfo, LocalApplicationProperties localApplicationProperties, String string) throws ExitException {
        if (Config.getStringProperty((String)"deployment.insecure.jres").equals("NEVER")) {
            return false;
        }
        if (localApplicationProperties != null && SSV2LATEST_VALUE.equals(localApplicationProperties.get(SSV2VERSION_KEY))) {
            return false;
        }
        if (SecureStaticVersioning.showSSV2Dialog(component, appInfo, string)) {
            if (localApplicationProperties != null) {
                localApplicationProperties.put(SSV2VERSION_KEY, string);
                try {
                    localApplicationProperties.store();
                }
                catch (IOException iOException) {
                    Trace.ignoredException((Exception)iOException);
                }
            }
            return true;
        }
        if (localApplicationProperties != null) {
            localApplicationProperties.put(SSV2VERSION_KEY, SSV2LATEST_VALUE);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        return false;
    }

    public static boolean promptRequired(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl, String string) {
        if (launchDesc.getSecurityModel() != 0 || !SecureStaticVersioning.isOlderVersion(string) || Config.getStringProperty((String)"deployment.insecure.jres").equals("ALWAYS") || SecurityBaseline.satisfiesSecurityBaseline((String)string)) {
            return false;
        }
        if (bl) {
            return true;
        }
        return localApplicationProperties == null || !string.equals(localApplicationProperties.get(SSV2VERSION_KEY));
    }

    public static boolean canAutoDownload(LaunchDesc launchDesc, JREDesc jREDesc, boolean bl) throws ExitException {
        Object object;
        boolean bl2;
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)launchDesc.getCanonicalHome());
        String string = Config.getStringProperty((String)"deployment.javaws.autodownload");
        if (bl || string != null && string.equalsIgnoreCase("NEVER")) {
            SecureStaticVersioning.showCannotUseDialog(null, launchDesc.getAppInfo(), localApplicationProperties, jREDesc.getVersion());
            return false;
        }
        if (launchDesc.getSecurityModel() == 0 && "NEVER".equals(Config.getStringProperty((String)"deployment.insecure.jres"))) {
            return false;
        }
        String string2 = jREDesc.getSource();
        URL uRL = jREDesc.getHref();
        boolean bl3 = bl2 = uRL == null;
        if (bl2) {
            object = Config.getStringProperty((String)"deployment.javaws.installURL");
            try {
                uRL = new URL((String)object);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ExitException(malformedURLException, 3);
            }
        }
        object = launchDesc.getJavaFXRuntimeDescriptor();
        String string3 = DownloadEngine.getAvailableVersion((URL)uRL, (String)jREDesc.getVersion(), (boolean)bl2, (String)JREInfo.getKnownPlatforms(), (String)(object == null ? null : ((JavaFXRuntimeDesc)object).getVersion()));
        if (string3 != null) {
            JREInfo[] jREInfoArray = JREInfo.getAll();
            for (int i = 0; i < jREInfoArray.length; ++i) {
                if (!jREInfoArray[i].getProductVersion().equals((Object)new VersionID(string3))) continue;
                Trace.println((String)("JRE " + string3 + " is already installed " + "in local system, should not auto-install it again"), (TraceLevel)TraceLevel.EXTENSIONS);
                string3 = null;
                break;
            }
        }
        if (string3 != null) {
            if (launchDesc.getSecurityModel() == 0 && !SecurityBaseline.satisfiesSecurityBaseline((String)string3)) {
                string3 = null;
            }
        }
        if (string3 == null) {
            SecureStaticVersioning.showCannotUseDialog(null, launchDesc.getAppInfo(), localApplicationProperties, jREDesc.getVersion());
            return false;
        }
        if (SecureStaticVersioning.promptRequired(launchDesc, localApplicationProperties, true, string3)) {
            if (!SecureStaticVersioning.promptDownload(null, launchDesc, localApplicationProperties, string3, string2)) {
                return false;
            }
        } else if (string != null && string.equalsIgnoreCase("PROMPT") && !AutoDownloadPrompt.prompt(null, launchDesc)) {
            SecureStaticVersioning.showCannotUseDialog(null, launchDesc.getAppInfo(), localApplicationProperties, jREDesc.getVersion());
            return false;
        }
        return true;
    }

    public static boolean canUse(LaunchDesc launchDesc, String string) throws ExitException {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)launchDesc.getCanonicalHome());
        if (launchDesc.needFX() && !JfxHelper.isCompatibleRuntime(launchDesc.getHomeJRE(), launchDesc.getSelectedJRE())) {
            SecureStaticVersioning.showCannotUseDialog(null, launchDesc.getAppInfo(), localApplicationProperties, string);
            return false;
        }
        if (SecureStaticVersioning.promptRequired(launchDesc, localApplicationProperties, false, string)) {
            return SecureStaticVersioning.promptUse(null, launchDesc.getAppInfo(), localApplicationProperties, string);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean canUse(AppInfo appInfo, String string) throws ExitException {
        Object object;
        if (!SecureStaticVersioning.isOlderVersion(string) || Config.getStringProperty((String)"deployment.insecure.jres").equals("ALWAYS") || SecurityBaseline.satisfiesSecurityBaseline((String)string)) {
            return true;
        }
        String string2 = appInfo.getFrom().toString() + "/" + appInfo.getTitle();
        HashMap hashMap = session;
        synchronized (hashMap) {
            object = (String)session.get(string2);
            if (string != null && string.equals(object)) {
                return true;
            }
            if (SSV2LATEST_VALUE.equals(object)) {
                return false;
            }
        }
        boolean bl = SecureStaticVersioning.promptUse(null, appInfo, null, string);
        object = session;
        synchronized (object) {
            session.put(string2, bl ? string : SSV2LATEST_VALUE);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAcceptedVersion(URL uRL) {
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties((URL)uRL);
        if (localApplicationProperties != null) {
            localApplicationProperties.put(SSV2VERSION_KEY, null);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
        HashMap hashMap = session;
        synchronized (hashMap) {
            if (uRL != null) {
                session.remove(uRL.toString());
            }
        }
    }

    private static boolean isOlderVersion(String string) {
        VersionID versionID;
        VersionID versionID2 = new VersionID(SecurityBaseline.getCurrentVersion() + "+");
        return !versionID2.match(versionID = new VersionID(string));
    }

    private static boolean showSSV2Dialog(Component component, AppInfo appInfo, String string) throws ExitException {
        String string2 = ResourceManager.getString((String)"deployment.ssv2.title");
        String string3 = ResourceManager.getString((String)"deployment.ssv2.masthead");
        String string4 = ResourceManager.getString((String)"deployment.ssv2.risk");
        String string5 = ResourceManager.getString((String)"deployment.ssv2.moreText");
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string6 = ResourceManager.getString((String)"deployment.ssv2.choice");
        String string7 = ResourceManager.getString((String)"deployment.ssv2.choice1");
        String string8 = ResourceManager.getString((String)"deployment.ssv2.choice2", (String)string);
        String string9 = ResourceManager.getString((String)"deployment.ssv2.run.button");
        String string10 = ResourceManager.getString((String)"common.cancel_btn");
        int n = ToolkitStore.getUI().showSSVDialog((Object)component, appInfo, string2, string3, string4, string5, uRL, string6, string7, string8, string9, string10);
        ToolkitStore.getUI();
        if (n == 0) {
            return true;
        }
        ToolkitStore.getUI();
        if (n == 2) {
            return false;
        }
        throw new ExitException(null, 0);
    }

    private static void showCannotUseDialog(Component component, AppInfo appInfo, LocalApplicationProperties localApplicationProperties, String string) throws ExitException {
        if (localApplicationProperties != null && SSV2LATEST_VALUE.equals(localApplicationProperties.get(SSV2VERSION_KEY))) {
            return;
        }
        String string2 = ResourceManager.getString((String)"deployment.ssv2.nodl.title");
        String string3 = ResourceManager.getString((String)"deployment.ssv2.nodl.masthead", (String)string);
        String string4 = ResourceManager.getString((String)"deployment.ssv2.nodl.button");
        String string5 = ResourceManager.getString((String)"common.cancel_btn");
        String string6 = ResourceManager.getString((String)"deployment.ssv2.moreText");
        URL uRL = null;
        try {
            uRL = new URL("http://java.com/access_old_java");
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIFactory uIFactory = ToolkitStore.getUI();
        ToolkitStore.getUI();
        int n = uIFactory.showMessageDialog((Object)component, appInfo, 2, string2, string3, null, null, string4, string5, null, uRL, string6);
        ToolkitStore.getUI();
        if (n != 0) {
            throw new ExitException(null, 0);
        }
        if (localApplicationProperties != null) {
            localApplicationProperties.put(SSV2VERSION_KEY, SSV2LATEST_VALUE);
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                Trace.ignoredException((Exception)iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showNoCanDo(AppInfo appInfo, String string) throws ExitException {
        String string2 = appInfo.getFrom().toString() + "/" + appInfo.getTitle();
        HashMap hashMap = session;
        synchronized (hashMap) {
            String string3 = (String)session.get(string2);
            if (string3 != null && string3.equals(SSV2LATEST_VALUE)) {
                return;
            }
        }
        SecureStaticVersioning.showCannotUseDialog(null, appInfo, null, string);
        hashMap = session;
        synchronized (hashMap) {
            session.put(string2, SSV2LATEST_VALUE);
        }
    }
}

