with (new JavaImporter(com.deltawalker.script)) {

/**
 * This sample demonstrates performing a two-way text comparison and reporting
 * the result both as in PDF and in HTML formats.
 */

var comp,
    // App is the top-level object in DeltaWalker's scripting object model
    comps = App.comparisons, deltas,
    /*
     * On OS X, copy the Extras/samples folder from the mounted DeltaWalker DMG
     * to a folder where you have read/write privileges such as
     * '/Users/username/test/samples' as starting with Yosemite all files inside
     * an app bundle must be signed making them non-modifiable.
     * On Windows and Linux you can copy the "/samples" folder
     * located inside DW's installation to <user.home>/test
     * The result files (if any) will be saved in "<user.home>" directly.
     */
    TEST_DIR = App.getProperty('user.home') + '/test',
	IN = TEST_DIR + '/samples',
    OUT = TEST_DIR,
    ix, 
    prop, 
    value, 
    page = App.settings.page, 
    printer = App.settings.printer, 
    printers = printer.installedPrinters;


/*
 * Create a 2-way text comparison passing the paths of files of interest in the
 * following order: Role.REF (reference file), Role.ONE (modified file)
 */
comp = comps.create(Comparison.Type.TEXT, [ IN + '/q0.txt', IN + '/q1.txt' ],
        null);

comp.compare();

// Display printer info (if there are printers)
if (printer.installedPrinters.length > 0) {
	// List available printer properties/settings
	print('\nPRINTER settings:\n');
	for (prop in printer) {
	    if ((typeof printer[prop] !== 'function') && (prop !== 'class')) {
	        value = printer[prop];
	        if (value instanceof Array) {
	            print('Listing values of the following array: ' + prop + '\n');
	            for (ix in value) {
	                print('	' + value[ix] + '\n');
	            }
	        } else {
	            print(prop + '=' + printer[prop] + '\n');
	        }
	    }
	}
	
	// List available page properties/settings
	print('\n\nPAGE settings:\n');
	for (prop in page) {
	    if ((typeof page[prop] !== 'function') && (prop !== 'class')) {
	        value = printer[prop];
	        if (value instanceof Array) {
	            print('Listing values of the following array: ' + prop + '\n');
	            for (ix in value) {
	                print('	' + value[ix] + '\n');
	            }
	        } else {
	            print(prop + '=' + page[prop] + '\n');
	        }
	    }
	}
	
	// Print to PDF file is supported on Mac OS X only
	if (App.getProperty('os.name').contains('Mac')) {
	    // Print to a file
	    // Set up page and print parameters
	    page.orientation = PageOrientation.LANDSCAPE;
	    printer.printToFile = true;
	    printer.filePath = OUT + '/dw-print-test.pdf';
	
	    // Print
	    comp.print();
	}
} else {
	print('No printers installed\n');
}

// Generate an HTML report
comp.report(OUT + '/dw-file-comparison.html', ReportKind.HTML, null);
}