with (new JavaImporter(com.deltawalker.script)) {

var comp,
    // App is the top-level object in DeltaWalker's scripting object model
    comps = App.comparisons, 
    deltas,
    /*
     * On OS X, copy the Extras/samples folder from the mounted DeltaWalker DMG
     * to a folder where you have read/write privileges such as
     * '/Users/username/test/samples' as starting with Yosemite all files inside
     * an app bundle must be signed making them non-modifiable.
     * On Windows and Linux you can copy the "/samples" folder
     * located inside DW's installation to <user.home>/test
     * The result files (if any) will be saved in "<user.home>" directly.
     */
    TEST_DIR = App.getProperty('user.home') + '/test',
    IN = TEST_DIR + '/samples',
    OUT = TEST_DIR;


/*
 * Create a 3-way text comparison passing the paths of files of interest in the
 * following order: Role.ONE (first modified file), Role.TWO (second modified
 * file), Role.REF (reference/common ancestor file)
 */
comp = comps.create(Comparison.Type.TEXT, [ IN + '/q1.txt', IN + '/q2.txt',
        IN + '/q0.txt' ], null);

comp.compare();

/*
 * Merge all non-conflicting blocks of text from Role.ONE and Role.TWO into
 * Role.REF
 */
comp.merge(MergeOp.MERGE, comp.allDeltas, null, Role.REF, null);

/*
 * Save the merge results in Role.REF to a new file, thus preserving the
 * original common ancestor: 'q0.txt'. Save it to OUT folder as there might be
 * insufficient write permissions for IN.
 */
comp.save(Role.REF, OUT + '/merged.txt', null);
}