with (new JavaImporter(com.deltawalker.script)) {

/**
 * This sample illustrates the use of folder comparison filters. 
 */

var comp,
    // App is the top-level object in DeltaWalker's scripting object model
    comps = App.comparisons,
    filter,
    filters,
    deltas,
    /*
     * On OS X, copy the Extras/samples folder from the mounted DeltaWalker DMG
     * to a folder where you have read/write privileges such as
     * '/Users/username/test/samples' as starting with Yosemite all files inside
     * an app bundle must be signed making them non-modifiable.
     * On Windows and Linux you can copy the "/samples" folder
     * located inside DW's installation to <user.home>/test
     * The result files (if any) will be saved in "<user.home>" directly.
     */
    TEST_DIR = App.getProperty('user.home') + '/test',
    IN = TEST_DIR + '/samples';


/*
 * Create a folder comparison passing the paths of folders of interest, Role.REF
 * first:
 */
comp = comps.create(Comparison.Type.FOLDER, [ IN + '/f0', IN + '/f1' ], null);

/*
 * Specify desired comparison method; multiple choices can be specified as an
 * array of comparison method values
 */
comp.settings.set(SettingKey.D_COMP_METHOD, [ Comparison.Method.DATE_MODIFIED,
        Comparison.Method.SIZE, Comparison.Method.ATTRIBUTES ]);

// Trigger comparison
comp.compare();

// Print result of comparison (#nodes) before adding a path filter
print('Total node count before applying a JS exclusion filter: '
        + comp.deltaCount + '\n\n');

// Create a path filter with the goal to exclude all java files
filters = comp.settings.filters(Comparison.Type.FOLDER);

/*
 * Add a new Path filter; adding it will also apply it and trigger a partial or
 * a full re-comparison as the case might be
 */
filter = filters.addPathFilter(true, FolderFilter.Target.FILES, '*.js', false,
        false, 'Exclude all JavaScript files');

// Print info about each filter
for each (var filter in filters.all) {
    print('Filter:' + filter + '\n');
};
// Alternative ways:
//var jsArray = Java.from(filters.all);
//jsArray.forEach(function(filter) {
//    print('Filter:' + filter + '\n');
//});
//for (var i = 0; i < filters.all.length; i++) {
//    print('Filter:' + filters.all[i] + '\n');
//}

// Print result of comparison (#nodes) after adding a path filter
print('\nTotal node count after applying a JS exclusion filter: '
        + comp.deltaCount + '\n');

// If you need to remove the newly added filter, uncomment the line below.
// filters.remove(filter);
}