with (new JavaImporter(com.deltawalker.script)) {

/*
 * This sample shows how to perform a 2-way folder comparison, followed by sync
 * operations such as copy, delete, mirror.
 */

var comp,
    // App is the top-level object in DeltaWalker's scripting object model
    comps = App.comparisons,
    /*
     * On OS X, copy the Extras/samples folder from the mounted DeltaWalker DMG
     * to a folder where you have read/write privileges such as
     * '/Users/username/test/samples' as starting with Yosemite all files inside
     * an app bundle must be signed making them non-modifiable.
     * On Windows and Linux you can copy the "/samples" folder
     * located inside DW's installation to <user.home>/test
     * The result files (if any) will be saved in "<user.home>" directly.
     */
    TEST_DIR = App.getProperty('user.home') + '/test',
	IN = TEST_DIR + '/samples',
    node,
    nodes,
    roles,
	res;

/*
 * Create a folder comparison passing the paths of folders of interest, Role.REF
 * first:
 */
comp = comps.create(Comparison.Type.FOLDER, [ IN + '/f0', IN + '/f1' ], null);

// Specify desired comparison method
comp.settings.set(SettingKey.D_COMP_METHOD, [ Comparison.Method.DATE_MODIFIED,
        Comparison.Method.SIZE, Comparison.Method.ATTRIBUTES ]);

// Start comparison
comp.compare();

// print the number of nodes
print('Total node count for this comparison: ' + comp.deltaCount + '\n');

// Print info about all nodes
nodes = comp.allDeltas;
for each(node in nodes) {
    print(node + '\n');
};

roles = comp.roles;

// Print some info about the actual resources
var nodeIx = 0;
for each(node in nodes) {
    for each(role in roles) {
        res = node.resource(role);
        if (res) {
            print('Resource at ' + nodeIx + ', role=' + role + ': ' + res + ' size=' + res.size);
        }
    };
	nodeIx++;
};

/*
 * Assuming you have a node at index 3 and it has a resource in Role.ONE, delete
 * it
 */
node = nodes[3];
/*
 * Uncomment out if you want to delete the resource at Role.ONE in node with
 * index 3 Note that the "/samples" folder inside the DeltaWalker installation
 * folder may not have permissions to write/delete files so next code will
 * report an error "No permissions"
 */
// print('\n Deleting resource ' + node);
// comp.deleteResource([node], [Role.ONE], null);
// Uncomment out if you want to COPY the resource from Role.ONE to Role.REF in
// node with index 3
// comp.sync(SyncOp.COPY, ([node], Role.ONE, Role.REF, null);
// Uncomment out if you want to MIRROR all nodes Role.ONE to Role.REF
// comp.sync(SyncOp.MIRROR, nodes, Role.ONE, Role.REF, null);

}