with (new JavaImporter(com.deltawalker.script)) {

/**
 * This sample demonstrates three-way comparison and synchronization of
 * non-conflicting differences.
 */

var comp,
    // App is the top-level object in DeltaWalker's scripting object model
    comps = App.comparisons,
    deltas,
    /*
     * On OS X, copy the Extras/samples folder from the mounted DeltaWalker DMG
     * to a folder where you have read/write privileges such as
     * '/Users/username/test/samples' as starting with Yosemite all files inside
     * an app bundle must be signed making them non-modifiable.
     * On Windows and Linux you can copy the "/samples" folder
     * located inside DW's installation to <user.home>/test
     * The result files (if any) will be saved in "<user.home>" directly.
     */
    TEST_DIR = App.getProperty('user.home') + '/test',
	IN = TEST_DIR + '/samples';


/*
 * Create a 3-way folder comparison passing the paths of folders of interest in
 * the following order: Role.ONE (first modified folder), Role.TWO (second
 * modified folder), Role.REF (reference/ancestor folder)
 */
comp = comps.create(Comparison.Type.FOLDER, [ IN + '/f1', IN + '/f2',
        IN + '/f0' ], null);

/*
 * Specify desired comparison method. Multiple choices can be specified as an
 * array of comparison method values, for instance
 * [Comparison.Method.DATE_MODIFIED, Comparison.Method.SIZE,
 * Comparison.Method.ATTRIBUTES]. The concepts of a 3-way comparison and
 * conflicts however make most sense when comparing files as text using a text
 * comparison algorithm and rules.
 */
comp.settings.set(SettingKey.D_COMP_METHOD, Comparison.Method.AS_TEXT);

// Start comparison
comp.compare();

// Print the number of nodes
print('Total node count for this comparison: ' + comp.deltaCount + '\n');

// Print info about all nodes
nodes = comp.allDeltas;
for each(node in nodes) {
    print(node + '\n');
};

roles = comp.roles;

// Print some info about the actual resources
for each(node in nodes) {
    for each(role in roles) {
        resource = node.resource(role);
        if (resource) {
            print('resource: ' + resource + ' size=' + resource.size + '\n');
        }
    };
};

// Sync all files with non-conflicting differences from Role.ONE and Role.TWO
// into Role.REF
comp.sync(SyncOp.SYNC, nodes, null, Role.REF, null);
}