with (new JavaImporter(com.deltawalker.script)) {

/**
 * This sample showcases the simplicity of performing remote comparisons.
 */

var comp,
    // App is the top-level object in DeltaWalker's scripting object model
    comps = App.comparisons, // App is the top-level object in DeltaWalker's scripting object model
    /*
     * On OS X, copy the Extras/samples folder from the mounted DeltaWalker DMG
     * to a folder where you have read/write privileges such as
     * '/Users/username/test/samples' as starting with Yosemite all files inside
     * an app bundle must be signed making them non-modifiable.
     * On Windows and Linux you can copy the "/samples" folder
     * located inside DW's installation to <user.home>/test
     * The result files (if any) will be saved in "<user.home>" directly.
     */
    TEST_DIR = App.getProperty('user.home') + '/test',
	IN = TEST_DIR + '/samples',
    uriInfo1,
    uriInfo2;

// First folder is on an FTP server; server URL is required
uriInfo1 = new UriInfo('ftp://speedtest.tele2.net/');

// In the case of an SFTP server, a username and a password will be required:
//uriInfo1 = new UriInfo('sftp://your_sftp.com', {UriInfo.Key.USERNAME: 'YOUR USERNAME', UriInfo.Key.PASSWORD: 'YOUR PASSWORD'});

// Second folder is folder on a local disk; only the folder path is required
uriInfo2 = new UriInfo(IN + '/f0');

// Create the folder comparison, passing the URI info objects
comp = comps.createEx(Comparison.Type.FOLDER, [uriInfo1, uriInfo2], null);

// Trigger the actual comparison
comp.compare();
}