with (new JavaImporter(com.deltawalker.script)) {
/**
 * This sample demonstrates some of the actions that can be performed on the
 * App's window object such as minimize, maximize, show/hide, resize.
 */

// App is the top-level object in DeltaWalker's scripting object model
// Print info about the current app window state
print('App.window.maximized=' + App.window.maximized + '\n');
print('App.window.minimized=' + App.window.minimized + '\n');
print('App.window.fullScreen=' + App.window.fullScreen + '\n');
print('App.window.visible=' + App.window.visible + '\n');
print('App.window.bounds=' + App.window.bounds + '\n');

// Set a few app window properties...
// First, maximize the app
App.window.maximized = true;

// Finally, resize the main app window
App.window.setBounds(new Rectangle(200, 200, 1000, 800));
}