<?xml version="1.0" encoding="UTF-8" ?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;" >
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" />

<xsl:template match="report">
  <xsl:variable name="title" select="'Deltopia DeltaWalker Comparison Report'" />
  <html>
    <head>
      <style type="text/css">
        /*
         * The general styles for content including and not limited to structure
         * and text comparison i.e. they set the styles of the titles of the
         * sections, the descriptive texts outside any of the structure and text
         * comparison tables, the tables listing the configuration preferences
         * and the summaries, etc.  
         */

        body, th, td {
          font-family: Verdana, Arial, Helvetica, sans-serif;
          font-size: 70%;
        }
        h1 {
        font-size: 1.3em;
        }
        h2 {
          font-size: 1.1em;
        }
        h3 {
          font-size: 1em;
        }
        table {
          border-collapse: collapse;
        }
        table, th, td {
          border-style: solid;
          border-width: 1;
        }
        th {
          background-color: rgb(136,136,136);
          color: rgb(204,204,204);
        }
        th, td {
          padding-left: 5;
          padding-right: 5;
        }

        /*
         * The styles for the top-level tables displaying the structure and
         * text comparisons.
         */

        table.structureComparison {
          width: 100%;
        }
        table.structureComparison td {
          border-style: none;
          border-width: 0;
        }

        table.textComparison {
          width: 100%;
        }
        table.textComparison td {
          border-style: none;
          border-width: 0;
        }

        /*
         * As the main tables that represent the Details section of the report
         * have been styled above, the styles for the individual role-specific
         * cells of structure comparison and the role-specific blocks of text
         * comparison follow bellow.
         */

        /*
         * If the text of the individual cells of the structure comparison trees
         * is to have a specific font, it should be defined here.
         */
        td.structureContent {
          white-space: nowrap;
        }

        table.textContent {
          border-spacing: 0;
          table-layout: fixed;
          width: 100%;
        }
        table.textContent, table.textContent td {
          border-style: none;
          border-width: 0;
          padding: 0;
        }
        td.textContent {
          vertical-align: top;
        }
        /* The style of the text in the line-number ruler only. */
        td.lineNumber span {
          float: right;
          padding-right: 1em;
        }
        /* The style of the line-number ruler and the text comparison itself. */
        span {
          float: left;
          font-family: monospace;
          font-size: 11px;
          white-space: pre;
          width: auto;
        }
      </style>
      
      <title><xsl:value-of select="$title" /></title>
    </head>
    <body>
      <h1><xsl:value-of select="$title" /></h1>
      <p>
        Produced by <b>Deltopia DeltaWalker</b> on <b><xsl:value-of select="@date" /></b>.
        See <a href="http://www.deltawalker.com">www.deltawalker.com</a> for information about
        DeltaWalker.
      </p>
      
      <h2>Compared</h2>
      <table>
        <tr><th>Role</th><th>Path</th></tr>
        <xsl:for-each select="comparison[1]/difference/content">
          <tr>
            <td>
              <xsl:variable name="role" select="@role" />
              <xsl:choose>
                <xsl:when test="$role='ancestor'">Ancestor</xsl:when>
                <xsl:when test="$role='first'">First</xsl:when>
                <xsl:when test="$role='second'">Second</xsl:when>
              </xsl:choose>
            </td>
            <td><xsl:value-of select="text()" /></td>
          </tr>
        </xsl:for-each>
      </table>

      <xsl:apply-templates />
    </body>
  </html>
</xsl:template>

<xsl:template match="configuration">
  <h2>Preferences</h2>
  <table>
    <xsl:apply-templates select="preference" />
    <tr>
      <td>Difference counts</td>
      <td>Shown in the comparison details</td>
    </tr>
  </table>

  <h2>Active File Comparison Filter(s)</h2>
  <xsl:variable name="fileFilters" select="filters[@class='files']" />
  <xsl:choose>
    <xsl:when test="$fileFilters">
      <xsl:apply-templates select="$fileFilters" />
    </xsl:when>
    <xsl:otherwise>
      <p>No file comparison filters were active.</p>
    </xsl:otherwise>
  </xsl:choose>

  <xsl:apply-templates select="filters[@class='folders']" />
  <xsl:apply-templates select="*[not(local-name()='preference' or local-name()='filters')]" />
</xsl:template>

<xsl:template match="preference">
  <xsl:variable name="name" select="@name" />
  <tr>
    <td>
      <xsl:choose>
        <xsl:when test="$name='ignoreCharacterCase'">Character case</xsl:when>
        <xsl:when test="$name='ignoreLineDelimiters'">Line delimiters</xsl:when>
        <xsl:when test="$name='ignoreWhitespace'">Whitespace</xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$name" />
        </xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:variable name="value" select="@value" />
      <xsl:choose>
        <xsl:when test="$name='ignoreCharacterCase'">
          <xsl:choose>
            <xsl:when test="$value='true'">Differences in character case are ignored</xsl:when>
            <xsl:otherwise>Differences in character case are significant</xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="$name='ignoreLineDelimiters'">
          <xsl:choose>
            <xsl:when test="$value='true'">Differences in line delimiters are ignored</xsl:when>
            <xsl:otherwise>Differences in line delimiters are significant</xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:when test="$name='ignoreWhitespace'">
          <xsl:choose>
            <xsl:when test="$value='true'">Differences in whitespace within lines are ignored</xsl:when>
            <xsl:otherwise>Differences in whitespace within lines are significant</xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$value" />
        </xsl:otherwise>
      </xsl:choose>
    </td>
  </tr>
</xsl:template>

<xsl:template match="filters[@class='files']">
  <table>
    <tr>
      <th>Expression</th>
      <th>Description</th>
    </tr>
    <xsl:apply-templates select="filter" />
  </table>
</xsl:template>

<xsl:template match="filter[parent::filters[@class='files']]">
  <tr>
    <td><xsl:value-of select="expression" /></td>
    <td><xsl:value-of select="description" /></td>
  </tr>
</xsl:template>

<xsl:template match="filters[@class='folders']">
<h2>Active Folder Comparison Filter(s): <xsl:value-of select="name" /></h2>
  <table>
    <tr>
      <th>State</th>
      <th>Filter</th>
      <th>Type</th>
      <th>Target</th>
      <th>Action</th>
    </tr>
    <xsl:apply-templates select="filter" />
  </table>
</xsl:template>

<xsl:template match="filter">
  <tr>
    <td>
      <xsl:choose>
        <xsl:when test="enabled='true'">Enabled</xsl:when>
        <xsl:otherwise>Disabled</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="expression" />
    </td>
    <td>
      <xsl:choose>
        <xsl:when test="regex='true'">Regular</xsl:when>
        <xsl:otherwise>Shell</xsl:otherwise>
      </xsl:choose>
    </td>
    <td>
      <xsl:value-of select="target" />
    </td>
    <td>
      <xsl:value-of select="action" />
    </td>
  </tr>
</xsl:template>

<xsl:template match="comparison">
  <h2>Comparison</h2>

  <h3>Summaries</h3>
  <xsl:apply-templates select="summary" />

  <h3>Details</h3>
  <xsl:apply-templates select="*[not(local-name()='summary')]" />
</xsl:template>

<xsl:template match="summary">
  <table>
    <xsl:variable name="hasItemsWithItems" select="boolean(item/item)" />
    <tr>
      <th>
        <xsl:if test="$hasItemsWithItems">
          <xsl:attribute name="rowspan">2</xsl:attribute>
        </xsl:if>
        &nbsp;
      </th>
      <xsl:for-each select="item">
        <th>
          <xsl:if test="$hasItemsWithItems">
            <xsl:variable name="itemCount" select="count(item)" />
            <xsl:choose>
              <xsl:when test="$itemCount>0">
                <xsl:attribute name="colspan">
                  <xsl:value-of select="$itemCount" />
                </xsl:attribute>
              </xsl:when>
              <xsl:otherwise>
                <xsl:attribute name="rowspan">2</xsl:attribute>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
          <xsl:value-of select="@name" />
        </th>
      </xsl:for-each>
    </tr>
    <xsl:if test="$hasItemsWithItems">
      <tr>
        <xsl:for-each select="item/item">
          <th><xsl:value-of select="@name" /></th>
        </xsl:for-each>
      </tr>
    </xsl:if>

    <xsl:apply-templates select="cc" />
  </table>
  
  <xsl:if test="position()!=last()">
    <br />
  </xsl:if>
</xsl:template>

<xsl:template match="cc[parent::summary]">
  <tr>
    <td><xsl:value-of select="@name" /></td>

    <xsl:apply-templates select="parent::summary/item">
      <xsl:with-param name="cc" select="@name" />
    </xsl:apply-templates>
  </tr>
</xsl:template>

<xsl:template match="item">
  <xsl:param name="cc" />

  <xsl:choose>
    <xsl:when test="count(item)=0">
      <td>
        <xsl:variable name="match" select="cc[@name=$cc]" />
        <xsl:choose>
          <xsl:when test="$match">
            <xsl:value-of select="$match/@value" />
          </xsl:when>
          <xsl:otherwise>-</xsl:otherwise> 
        </xsl:choose>
      </td>
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-templates select="item">
        <xsl:with-param name="cc" select="$cc" />
      </xsl:apply-templates>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="difference[parent::comparison]">
  <table>
    <xsl:choose>
      <xsl:when test="difference[@class='structure']">
        <xsl:attribute name="class">structureComparison</xsl:attribute>
      </xsl:when>
      <xsl:when test="difference[@class='text']">
        <xsl:attribute name="class">textComparison</xsl:attribute>
      </xsl:when>
    </xsl:choose>

    <xsl:apply-templates select="difference">
      <xsl:with-param name="threeWay" select="boolean(content[@role='ancestor'])" />
    </xsl:apply-templates>
  </table>
</xsl:template>

<xsl:template match="difference[parent::difference and (@class='structure' or parent::difference[parent::comparison or @class='text'])]">
  <xsl:param name="threeWay" select="false" />

  <tr>
    <xsl:call-template name="differenceWithRole">
      <xsl:with-param name="role" select="'first'" />
    </xsl:call-template>
    <xsl:if test="threeWay">
      <xsl:call-template name="differenceWithRole">
        <xsl:with-param name="role" select="'ancestor'" />
      </xsl:call-template>
    </xsl:if>
    <xsl:call-template name="differenceWithRole">
      <xsl:with-param name="role" select="'second'" />
    </xsl:call-template>
  </tr>

  <xsl:variable name="class" select="@class" />
  <xsl:apply-templates select="difference[@class=$class]">
    <xsl:with-param name="threeWay" select="$threeWay" />
  </xsl:apply-templates>
</xsl:template>

<xsl:template name="differenceWithRole">
  <xsl:param name="role" />
  <xsl:variable name="contentWithRole" select="content[@role=$role]" />

  <td>
    <xsl:choose>
      <xsl:when test="$contentWithRole">
        <xsl:variable name="background" select="$contentWithRole/@background" />
        <xsl:if test="$background">
          <xsl:attribute name="style">background-color: <xsl:value-of select="$background" /></xsl:attribute>
        </xsl:if>
      
        <xsl:choose>
          <xsl:when test="@class='structure'">
            <xsl:for-each select="$contentWithRole">
              <xsl:call-template name="structureContent" />
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <xsl:for-each select="$contentWithRole">
              <xsl:call-template name="textContent" />
            </xsl:for-each>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="style">background-color: rgb(239,239,239)</xsl:attribute>
        &nbsp;
      </xsl:otherwise>
    </xsl:choose>
  </td>
  
  <xsl:if test="$role!='second' and @class='structure'">
    <td>
      <xsl:variable name="diffCount" select="$contentWithRole/@diffCount" />
      <xsl:choose>
        <xsl:when test="$diffCount"><xsl:value-of select="$diffCount" /></xsl:when>
        <xsl:otherwise>&nbsp;</xsl:otherwise>
      </xsl:choose>
    </td>
  </xsl:if>
</xsl:template>

<xsl:template name="structureContent">
  <xsl:attribute name="class">structureContent</xsl:attribute>

  <xsl:for-each select="ancestor::difference[parent::difference[parent::difference]]">
    &nbsp;&nbsp;&nbsp;
  </xsl:for-each>
  
  <xsl:variable name="image" select="@image" />
  <xsl:if test="$image">
    <img alt=""><xsl:attribute name="src"><xsl:value-of select="$image" /></xsl:attribute></img>
  </xsl:if>
  &nbsp;
  <xsl:variable name="href" select="parent::difference/@href" />
  <xsl:choose>
    <xsl:when test="$href">
      <a><xsl:attribute name="href"><xsl:value-of select="$href" /></xsl:attribute><xsl:value-of select="text()" /></a>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="text()" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="textContent">
  <xsl:attribute name="class">textContent</xsl:attribute>

  <table class="textContent">
    <col style="width: 3em;" /><col width="*" />
    <xsl:apply-templates />
  </table>
</xsl:template>

<xsl:template match="line">
  <tr>
    <td class="lineNumber"><xsl:value-of select="@number" /></td>
    <td>
      <xsl:for-each select="span">
        <span>
          <xsl:variable name="background" select="@background" />
          <xsl:if test="$background">
            <xsl:attribute name="style">background-color: <xsl:value-of select="$background" /></xsl:attribute>
          </xsl:if>
          <xsl:value-of select="text()" />
        </span>
      </xsl:for-each>
    </td>
  </tr>
</xsl:template>

<xsl:template match="text()|@*" />

</xsl:stylesheet>
