/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.FeedbackCipher;
import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;
import java.security.ProviderException;

class CipherBlockChaining
extends FeedbackCipher {
    protected byte[] r;
    private byte[] k = new byte[this.blockSize];
    private byte[] rSave = null;

    CipherBlockChaining(SymmetricCipher symmetricCipher) {
        super(symmetricCipher);
        this.r = new byte[this.blockSize];
    }

    @Override
    String getFeedback() {
        return "CBC";
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        if (byArray == null || byArray2 == null || byArray2.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = byArray2;
        this.reset();
        this.embeddedCipher.init(bl, string, byArray);
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.r, 0, this.blockSize);
    }

    @Override
    void save() {
        if (this.rSave == null) {
            this.rSave = new byte[this.blockSize];
        }
        System.arraycopy(this.r, 0, this.rSave, 0, this.blockSize);
    }

    @Override
    void restore() {
        System.arraycopy(this.rSave, 0, this.r, 0, this.blockSize);
    }

    @Override
    int encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 <= 0) {
            return n2;
        }
        if (n2 % this.blockSize != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
        int n4 = n + n2;
        while (n < n4) {
            for (int i = 0; i < this.blockSize; ++i) {
                this.k[i] = (byte)(byArray[i + n] ^ this.r[i]);
            }
            this.embeddedCipher.encryptBlock(this.k, 0, byArray2, n3);
            System.arraycopy(byArray2, n3, this.r, 0, this.blockSize);
            n += this.blockSize;
            n3 += this.blockSize;
        }
        return n2;
    }

    @Override
    int decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (n2 <= 0) {
            return n2;
        }
        if (n2 % this.blockSize != 0) {
            throw new ProviderException("Internal error in input buffering");
        }
        int n4 = n + n2;
        while (n < n4) {
            this.embeddedCipher.decryptBlock(byArray, n, this.k, 0);
            for (int i = 0; i < this.blockSize; ++i) {
                byArray2[i + n3] = (byte)(this.k[i] ^ this.r[i]);
            }
            System.arraycopy(byArray, n, this.r, 0, this.blockSize);
            n += this.blockSize;
            n3 += this.blockSize;
        }
        return n2;
    }
}

