/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates.persistence;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TemplateStore {
    private final List fTemplates = new ArrayList();
    private IPreferenceStore fPreferenceStore;
    private String fKey;
    private ContextTypeRegistry fRegistry;
    private boolean fIgnorePreferenceStoreChanges = false;
    private IPropertyChangeListener fPropertyListener;

    public TemplateStore(IPreferenceStore iPreferenceStore, String string) {
        Assert.isNotNull((Object)iPreferenceStore);
        Assert.isNotNull((Object)string);
        this.fPreferenceStore = iPreferenceStore;
        this.fKey = string;
    }

    public TemplateStore(ContextTypeRegistry contextTypeRegistry, IPreferenceStore iPreferenceStore, String string) {
        this(iPreferenceStore, string);
        this.fRegistry = contextTypeRegistry;
    }

    public void load() throws IOException {
        this.fTemplates.clear();
        this.loadContributedTemplates();
        this.loadCustomTemplates();
    }

    public final void startListeningForPreferenceChanges() {
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!TemplateStore.this.fIgnorePreferenceStoreChanges && TemplateStore.this.fKey.equals(propertyChangeEvent.getProperty())) {
                        try {
                            TemplateStore.this.load();
                        }
                        catch (IOException iOException) {
                            TemplateStore.this.handleException(iOException);
                        }
                    }
                }
            };
            this.fPreferenceStore.addPropertyChangeListener(this.fPropertyListener);
        }
    }

    public final void stopListeningForPreferenceChanges() {
        if (this.fPropertyListener != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
    }

    protected void handleException(IOException iOException) {
        iOException.printStackTrace();
    }

    protected void loadContributedTemplates() throws IOException {
    }

    protected void internalAdd(TemplatePersistenceData templatePersistenceData) {
        if (!templatePersistenceData.isCustom()) {
            String string = templatePersistenceData.getId();
            for (TemplatePersistenceData templatePersistenceData2 : this.fTemplates) {
                if (templatePersistenceData2.getId() == null || !templatePersistenceData2.getId().equals(string)) continue;
                return;
            }
            this.fTemplates.add(templatePersistenceData);
        }
    }

    public void save() throws IOException {
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object2 : this.fTemplates) {
            if (!((TemplatePersistenceData)object2).isCustom() || ((TemplatePersistenceData)object2).isUserAdded() && ((TemplatePersistenceData)object2).isDeleted()) continue;
            arrayList.add(object2);
        }
        StringWriter stringWriter = new StringWriter();
        object2 = new TemplateReaderWriter();
        ((TemplateReaderWriter)object2).save(arrayList.toArray(new TemplatePersistenceData[arrayList.size()]), stringWriter);
        this.fIgnorePreferenceStoreChanges = true;
        try {
            this.fPreferenceStore.setValue(this.fKey, stringWriter.toString());
            if (this.fPreferenceStore instanceof IPersistentPreferenceStore) {
                ((IPersistentPreferenceStore)this.fPreferenceStore).save();
            }
        }
        finally {
            this.fIgnorePreferenceStoreChanges = false;
        }
    }

    public void add(TemplatePersistenceData templatePersistenceData) {
        if (!this.validateTemplate(templatePersistenceData.getTemplate())) {
            return;
        }
        if (templatePersistenceData.isUserAdded()) {
            this.fTemplates.add(templatePersistenceData);
        } else {
            for (TemplatePersistenceData templatePersistenceData2 : this.fTemplates) {
                if (templatePersistenceData2.getId() == null || !templatePersistenceData2.getId().equals(templatePersistenceData.getId())) continue;
                templatePersistenceData2.setTemplate(templatePersistenceData.getTemplate());
                templatePersistenceData2.setDeleted(templatePersistenceData.isDeleted());
                templatePersistenceData2.setEnabled(templatePersistenceData.isEnabled());
                return;
            }
            if (templatePersistenceData.getTemplate() != null) {
                TemplatePersistenceData templatePersistenceData3 = new TemplatePersistenceData(templatePersistenceData.getTemplate(), templatePersistenceData.isEnabled());
                this.fTemplates.add(templatePersistenceData3);
            }
        }
    }

    public void delete(TemplatePersistenceData templatePersistenceData) {
        if (templatePersistenceData.isUserAdded()) {
            this.fTemplates.remove(templatePersistenceData);
        } else {
            templatePersistenceData.setDeleted(true);
        }
    }

    public void restoreDeleted() {
        for (TemplatePersistenceData templatePersistenceData : this.fTemplates) {
            if (!templatePersistenceData.isDeleted()) continue;
            templatePersistenceData.setDeleted(false);
        }
    }

    public void restoreDefaults(boolean bl) {
        String string = null;
        if (!bl) {
            string = this.fPreferenceStore.getString(this.fKey);
        }
        try {
            this.fIgnorePreferenceStoreChanges = true;
            this.fPreferenceStore.setToDefault(this.fKey);
        }
        finally {
            this.fIgnorePreferenceStoreChanges = false;
        }
        try {
            this.load();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (string != null) {
            try {
                this.fIgnorePreferenceStoreChanges = true;
                this.fPreferenceStore.putValue(this.fKey, string);
            }
            finally {
                this.fIgnorePreferenceStoreChanges = false;
            }
        }
    }

    public void restoreDefaults() {
        this.restoreDefaults(true);
    }

    public Template[] getTemplates() {
        return this.getTemplates(null);
    }

    public Template[] getTemplates(String string) {
        ArrayList<Template> arrayList = new ArrayList<Template>();
        for (TemplatePersistenceData templatePersistenceData : this.fTemplates) {
            if (!templatePersistenceData.isEnabled() || templatePersistenceData.isDeleted() || string != null && !string.equals(templatePersistenceData.getTemplate().getContextTypeId())) continue;
            arrayList.add(templatePersistenceData.getTemplate());
        }
        return arrayList.toArray(new Template[arrayList.size()]);
    }

    public Template findTemplate(String string) {
        return this.findTemplate(string, null);
    }

    public Template findTemplate(String string, String string2) {
        Assert.isNotNull((Object)string);
        for (TemplatePersistenceData templatePersistenceData : this.fTemplates) {
            Template template = templatePersistenceData.getTemplate();
            if (!templatePersistenceData.isEnabled() || templatePersistenceData.isDeleted() || string2 != null && !string2.equals(template.getContextTypeId()) || !string.equals(template.getName())) continue;
            return template;
        }
        return null;
    }

    public Template findTemplateById(String string) {
        TemplatePersistenceData templatePersistenceData = this.getTemplateData(string);
        if (templatePersistenceData != null && !templatePersistenceData.isDeleted()) {
            return templatePersistenceData.getTemplate();
        }
        return null;
    }

    public TemplatePersistenceData[] getTemplateData(boolean bl) {
        ArrayList<TemplatePersistenceData> arrayList = new ArrayList<TemplatePersistenceData>();
        for (TemplatePersistenceData templatePersistenceData : this.fTemplates) {
            if (!bl && templatePersistenceData.isDeleted()) continue;
            arrayList.add(templatePersistenceData);
        }
        return arrayList.toArray(new TemplatePersistenceData[arrayList.size()]);
    }

    public TemplatePersistenceData getTemplateData(String string) {
        Assert.isNotNull((Object)string);
        for (TemplatePersistenceData templatePersistenceData : this.fTemplates) {
            if (!string.equals(templatePersistenceData.getId())) continue;
            return templatePersistenceData;
        }
        return null;
    }

    private void loadCustomTemplates() throws IOException {
        String string = this.fPreferenceStore.getString(this.fKey);
        if (string != null && string.trim().length() > 0) {
            StringReader stringReader = new StringReader(string);
            TemplateReaderWriter templateReaderWriter = new TemplateReaderWriter();
            TemplatePersistenceData[] templatePersistenceDataArray = templateReaderWriter.read(stringReader);
            int n = 0;
            while (n < templatePersistenceDataArray.length) {
                TemplatePersistenceData templatePersistenceData = templatePersistenceDataArray[n];
                this.add(templatePersistenceData);
                ++n;
            }
        }
    }

    private boolean validateTemplate(Template template) {
        String string = template.getContextTypeId();
        if (this.contextExists(string)) {
            if (this.fRegistry != null) {
                try {
                    this.fRegistry.getContextType(string).validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private boolean contextExists(String string) {
        return string != null && (this.fRegistry == null || this.fRegistry.getContextType(string) != null);
    }

    protected final ContextTypeRegistry getRegistry() {
        return this.fRegistry;
    }
}

