/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TemplateReaderWriter {
    private static final String TEMPLATE_ROOT = "templates";
    private static final String TEMPLATE_ELEMENT = "template";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ID_ATTRIBUTE = "id";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String CONTEXT_ATTRIBUTE = "context";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String DELETED_ATTRIBUTE = "deleted";
    private static final String AUTO_INSERTABLE_ATTRIBUTE = "autoinsert";

    public TemplatePersistenceData[] read(Reader reader) throws IOException {
        return this.read(reader, null);
    }

    public TemplatePersistenceData readSingle(Reader reader, String string) throws IOException {
        TemplatePersistenceData[] templatePersistenceDataArray = this.read(new InputSource(reader), null, string);
        if (templatePersistenceDataArray.length > 0) {
            return templatePersistenceDataArray[0];
        }
        return null;
    }

    public TemplatePersistenceData[] read(Reader reader, ResourceBundle resourceBundle) throws IOException {
        return this.read(new InputSource(reader), resourceBundle, null);
    }

    public TemplatePersistenceData[] read(InputStream inputStream, ResourceBundle resourceBundle) throws IOException {
        return this.read(new InputSource(inputStream), resourceBundle, null);
    }

    private TemplatePersistenceData[] read(InputSource inputSource, ResourceBundle resourceBundle, String string) throws IOException {
        try {
            ArrayList<TemplatePersistenceData> arrayList = new ArrayList<TemplatePersistenceData>();
            HashSet hashSet = new HashSet();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new DefaultHandler());
            Document document = documentBuilder.parse(inputSource);
            NodeList nodeList = document.getElementsByTagName(TEMPLATE_ELEMENT);
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 != n) {
                Node node = nodeList.item(n2);
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    String string2 = this.getStringValue(namedNodeMap, ID_ATTRIBUTE, null);
                    if (string2 != null && hashSet.contains(string2)) {
                        throw new IOException(TemplatePersistenceMessages.getString("TemplateReaderWriter.duplicate.id"));
                    }
                    if (string == null || string.equals(string2)) {
                        String string3;
                        boolean bl = this.getBooleanValue(namedNodeMap, DELETED_ATTRIBUTE, false);
                        String string4 = this.getStringValue(namedNodeMap, NAME_ATTRIBUTE);
                        string4 = this.translateString(string4, resourceBundle);
                        String string5 = this.getStringValue(namedNodeMap, DESCRIPTION_ATTRIBUTE, "");
                        string5 = this.translateString(string5, resourceBundle);
                        String string6 = this.getStringValue(namedNodeMap, CONTEXT_ATTRIBUTE);
                        if (string4 == null || string6 == null) {
                            throw new IOException(TemplatePersistenceMessages.getString("TemplateReaderWriter.error.missing_attribute"));
                        }
                        boolean bl2 = this.getBooleanValue(namedNodeMap, ENABLED_ATTRIBUTE, true);
                        boolean bl3 = this.getBooleanValue(namedNodeMap, AUTO_INSERTABLE_ATTRIBUTE, true);
                        StringBuffer stringBuffer = new StringBuffer();
                        NodeList nodeList2 = node.getChildNodes();
                        int n3 = 0;
                        while (n3 != nodeList2.getLength()) {
                            string3 = nodeList2.item(n3).getNodeValue();
                            if (string3 != null) {
                                stringBuffer.append(string3);
                            }
                            ++n3;
                        }
                        String string7 = stringBuffer.toString();
                        string7 = this.translateString(string7, resourceBundle);
                        string3 = new Template(string4, string5, string6, string7, bl3);
                        TemplatePersistenceData templatePersistenceData = new TemplatePersistenceData((Template)string3, bl2, string2);
                        templatePersistenceData.setDeleted(bl);
                        arrayList.add(templatePersistenceData);
                        if (string != null && string.equals(string2)) break;
                    }
                }
                ++n2;
            }
            return arrayList.toArray(new TemplatePersistenceData[arrayList.size()]);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (SAXException sAXException) {
            throw (IOException)new IOException("Could not read template file").initCause(sAXException);
        }
        return null;
    }

    public void save(TemplatePersistenceData[] templatePersistenceDataArray, OutputStream outputStream) throws IOException {
        this.save(templatePersistenceDataArray, new StreamResult(outputStream));
    }

    public void save(TemplatePersistenceData[] templatePersistenceDataArray, Writer writer) throws IOException {
        this.save(templatePersistenceDataArray, new StreamResult(writer));
    }

    private void save(TemplatePersistenceData[] templatePersistenceDataArray, StreamResult streamResult) throws IOException {
        try {
            Object object;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(TEMPLATE_ROOT);
            document.appendChild(element);
            int n = 0;
            while (n < templatePersistenceDataArray.length) {
                Node node;
                Attr attr;
                object = templatePersistenceDataArray[n];
                Template template = ((TemplatePersistenceData)object).getTemplate();
                Element element2 = document.createElement(TEMPLATE_ELEMENT);
                element.appendChild(element2);
                NamedNodeMap namedNodeMap = element2.getAttributes();
                String string = ((TemplatePersistenceData)object).getId();
                if (string != null) {
                    attr = document.createAttribute(ID_ATTRIBUTE);
                    attr.setValue(string);
                    namedNodeMap.setNamedItem(attr);
                }
                if (template != null) {
                    attr = document.createAttribute(NAME_ATTRIBUTE);
                    attr.setValue(TemplateReaderWriter.validateXML(template.getName()));
                    namedNodeMap.setNamedItem(attr);
                }
                if (template != null) {
                    attr = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                    attr.setValue(TemplateReaderWriter.validateXML(template.getDescription()));
                    namedNodeMap.setNamedItem(attr);
                }
                if (template != null) {
                    attr = document.createAttribute(CONTEXT_ATTRIBUTE);
                    attr.setValue(TemplateReaderWriter.validateXML(template.getContextTypeId()));
                    namedNodeMap.setNamedItem(attr);
                }
                attr = document.createAttribute(ENABLED_ATTRIBUTE);
                attr.setValue(((TemplatePersistenceData)object).isEnabled() ? Boolean.toString(true) : Boolean.toString(false));
                namedNodeMap.setNamedItem(attr);
                Attr attr2 = document.createAttribute(DELETED_ATTRIBUTE);
                attr2.setValue(((TemplatePersistenceData)object).isDeleted() ? Boolean.toString(true) : Boolean.toString(false));
                namedNodeMap.setNamedItem(attr2);
                if (template != null) {
                    node = document.createAttribute(AUTO_INSERTABLE_ATTRIBUTE);
                    node.setValue(template.isAutoInsertable() ? Boolean.toString(true) : Boolean.toString(false));
                    namedNodeMap.setNamedItem(node);
                }
                if (template != null) {
                    node = document.createTextNode(TemplateReaderWriter.validateXML(template.getPattern()));
                    element2.appendChild(node);
                }
                ++n;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            object = new DOMSource(document);
            transformer.transform((Source)object, streamResult);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (TransformerException transformerException) {
            if (transformerException.getException() instanceof IOException) {
                throw (IOException)transformerException.getException();
            }
            Assert.isTrue((boolean)false);
        }
    }

    private static String validateXML(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '\t' && c != '\n' && c != '\r' && c < ' ') {
                throw new IOException("Character reference \"&#" + Integer.toString(c) + "\" is an invalid XML character.");
            }
            ++n;
        }
        return string;
    }

    private boolean getBooleanValue(NamedNodeMap namedNodeMap, String string, boolean bl) throws SAXException {
        Node node = namedNodeMap.getNamedItem(string);
        if (node == null) {
            return bl;
        }
        if (node.getNodeValue().equals(Boolean.toString(true))) {
            return true;
        }
        if (node.getNodeValue().equals(Boolean.toString(false))) {
            return false;
        }
        throw new SAXException(TemplatePersistenceMessages.getString("TemplateReaderWriter.error.illegal_boolean_attribute"));
    }

    private String getStringValue(NamedNodeMap namedNodeMap, String string) throws SAXException {
        String string2 = this.getStringValue(namedNodeMap, string, null);
        if (string2 == null) {
            throw new SAXException(TemplatePersistenceMessages.getString("TemplateReaderWriter.error.missing_attribute"));
        }
        return string2;
    }

    private String getStringValue(NamedNodeMap namedNodeMap, String string, String string2) {
        Node node = namedNodeMap.getNamedItem(string);
        return node == null ? string2 : node.getNodeValue();
    }

    private String translateString(String string, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            return string;
        }
        int n = string.indexOf(37);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            n2 = n + 1;
            while (n2 < string.length() && !Character.isWhitespace(string.charAt(n2))) {
                ++n2;
            }
            String string2 = string.substring(n + 1, n2);
            stringBuffer.append(this.getBundleString(string2, resourceBundle));
            n = string.indexOf(37, n2);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private String getBundleString(String string, ResourceBundle resourceBundle) {
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return String.valueOf('!') + string + '!';
            }
        }
        return TemplatePersistenceMessages.getString(string);
    }
}

