/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.InclusivePositionUpdater;
import org.eclipse.jface.text.templates.JFaceTextTemplateMessages;
import org.eclipse.jface.text.templates.PositionBasedCompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateProposal
implements ICompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private final Template fTemplate;
    private final TemplateContext fContext;
    private final Image fImage;
    private final IRegion fRegion;
    private int fRelevance;
    private IRegion fSelectedRegion;
    private String fDisplayString;
    private InclusivePositionUpdater fUpdater;
    private IInformationControlCreator fInformationControlCreator;

    public TemplateProposal(Template template, TemplateContext templateContext, IRegion iRegion, Image image) {
        this(template, templateContext, iRegion, image, 0);
    }

    public TemplateProposal(Template template, TemplateContext templateContext, IRegion iRegion, Image image, int n) {
        Assert.isNotNull((Object)template);
        Assert.isNotNull((Object)templateContext);
        Assert.isNotNull((Object)iRegion);
        this.fTemplate = template;
        this.fContext = templateContext;
        this.fImage = image;
        this.fRegion = iRegion;
        this.fDisplayString = null;
        this.fRelevance = n;
    }

    public final void setInformationControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fInformationControlCreator = iInformationControlCreator;
    }

    protected final Template getTemplate() {
        return this.fTemplate;
    }

    protected final TemplateContext getContext() {
        return this.fContext;
    }

    @Override
    public final void apply(IDocument iDocument) {
    }

    @Override
    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        IDocument iDocument = iTextViewer.getDocument();
        try {
            TemplateBuffer templateBuffer;
            this.fContext.setReadOnly(false);
            int n3 = this.getReplaceOffset();
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException templateException) {
                this.fSelectedRegion = this.fRegion;
                return;
            }
            int n4 = this.getReplaceOffset();
            int n5 = n4 - n3;
            int n6 = Math.max(this.getReplaceEndOffset(), n2 + n5);
            String string = templateBuffer.getString();
            iDocument.replace(n4, n6 - n4, string);
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
            n6 = 0;
            int n7 = 0;
            while (n7 != templateVariableArray.length) {
                TemplateVariable templateVariable = templateVariableArray[n7];
                if (!templateVariable.isUnambiguous()) {
                    LinkedPositionGroup linkedPositionGroup = new LinkedPositionGroup();
                    int[] nArray = templateVariable.getOffsets();
                    int n8 = templateVariable.getLength();
                    String[] stringArray = templateVariable.getValues();
                    ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[stringArray.length];
                    int n9 = 0;
                    while (n9 < stringArray.length) {
                        this.ensurePositionCategoryInstalled(iDocument, linkedModeModel);
                        Position position = new Position(nArray[0] + n4, n8);
                        iDocument.addPosition(this.getCategory(), position);
                        iCompletionProposalArray[n9] = new PositionBasedCompletionProposal(stringArray[n9], position, n8);
                        ++n9;
                    }
                    LinkedPosition linkedPosition = iCompletionProposalArray.length > 1 ? new ProposalPosition(iDocument, nArray[0] + n4, n8, iCompletionProposalArray) : new LinkedPosition(iDocument, nArray[0] + n4, n8);
                    int n10 = 0;
                    while (n10 != nArray.length) {
                        if (n10 == 0) {
                            linkedPositionGroup.addPosition(linkedPosition);
                        } else {
                            linkedPositionGroup.addPosition(new LinkedPosition(iDocument, nArray[n10] + n4, n8));
                        }
                        ++n10;
                    }
                    linkedModeModel.addGroup(linkedPositionGroup);
                    n6 = 1;
                }
                ++n7;
            }
            if (n6 != 0) {
                linkedModeModel.forceInstall();
                LinkedModeUI linkedModeUI = new LinkedModeUI(linkedModeModel, iTextViewer);
                linkedModeUI.setExitPosition(iTextViewer, this.getCaretOffset(templateBuffer) + n4, 0, Integer.MAX_VALUE);
                linkedModeUI.enter();
                this.fSelectedRegion = linkedModeUI.getSelectedRegion();
            } else {
                this.ensurePositionCategoryRemoved(iDocument);
                this.fSelectedRegion = new Region(this.getCaretOffset(templateBuffer) + n4, 0);
            }
        }
        catch (BadLocationException badLocationException) {
            this.openErrorDialog(iTextViewer.getTextWidget().getShell(), (Exception)((Object)badLocationException));
            this.ensurePositionCategoryRemoved(iDocument);
            this.fSelectedRegion = this.fRegion;
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            this.openErrorDialog(iTextViewer.getTextWidget().getShell(), (Exception)((Object)badPositionCategoryException));
            this.fSelectedRegion = this.fRegion;
        }
    }

    private void ensurePositionCategoryInstalled(final IDocument iDocument, LinkedModeModel linkedModeModel) {
        if (!iDocument.containsPositionCategory(this.getCategory())) {
            iDocument.addPositionCategory(this.getCategory());
            this.fUpdater = new InclusivePositionUpdater(this.getCategory());
            iDocument.addPositionUpdater((IPositionUpdater)this.fUpdater);
            linkedModeModel.addLinkingListener(new ILinkedModeListener(){

                public void left(LinkedModeModel linkedModeModel, int n) {
                    TemplateProposal.this.ensurePositionCategoryRemoved(iDocument);
                }

                public void suspend(LinkedModeModel linkedModeModel) {
                }

                public void resume(LinkedModeModel linkedModeModel, int n) {
                }
            });
        }
    }

    private void ensurePositionCategoryRemoved(IDocument iDocument) {
        if (iDocument.containsPositionCategory(this.getCategory())) {
            try {
                iDocument.removePositionCategory(this.getCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            iDocument.removePositionUpdater((IPositionUpdater)this.fUpdater);
        }
    }

    private String getCategory() {
        return "TemplateProposalCategory_" + this.toString();
    }

    private int getCaretOffset(TemplateBuffer templateBuffer) {
        TemplateVariable[] templateVariableArray = templateBuffer.getVariables();
        int n = 0;
        while (n != templateVariableArray.length) {
            TemplateVariable templateVariable = templateVariableArray[n];
            if (templateVariable.getType().equals("cursor")) {
                return templateVariable.getOffsets()[0];
            }
            ++n;
        }
        return templateBuffer.getString().length();
    }

    protected final int getReplaceOffset() {
        int n;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext documentTemplateContext = (DocumentTemplateContext)this.fContext;
            n = documentTemplateContext.getStart();
        } else {
            n = this.fRegion.getOffset();
        }
        return n;
    }

    protected final int getReplaceEndOffset() {
        int n;
        if (this.fContext instanceof DocumentTemplateContext) {
            DocumentTemplateContext documentTemplateContext = (DocumentTemplateContext)this.fContext;
            n = documentTemplateContext.getEnd();
        } else {
            n = this.fRegion.getOffset() + this.fRegion.getLength();
        }
        return n;
    }

    @Override
    public Point getSelection(IDocument iDocument) {
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    @Override
    public String getAdditionalProposalInfo() {
        TemplateBuffer templateBuffer;
        try {
            this.fContext.setReadOnly(true);
            try {
                templateBuffer = this.fContext.evaluate(this.fTemplate);
            }
            catch (TemplateException templateException) {
                return null;
            }
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return templateBuffer.getString();
    }

    @Override
    public String getDisplayString() {
        if (this.fDisplayString == null) {
            Object[] objectArray = new String[]{this.fTemplate.getName(), this.fTemplate.getDescription()};
            this.fDisplayString = JFaceTextTemplateMessages.getFormattedString("TemplateProposal.displayString", objectArray);
        }
        return this.fDisplayString;
    }

    @Override
    public Image getImage() {
        return this.fImage;
    }

    @Override
    public IContextInformation getContextInformation() {
        return null;
    }

    private void openErrorDialog(Shell shell, Exception exception) {
        MessageDialog.openError((Shell)shell, (String)JFaceTextTemplateMessages.getString("TemplateProposal.errorDialog.title"), (String)exception.getMessage());
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    @Override
    public IInformationControlCreator getInformationControlCreator() {
        return this.fInformationControlCreator;
    }

    @Override
    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    @Override
    public void unselected(ITextViewer iTextViewer) {
    }

    @Override
    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        try {
            int n2 = this.getReplaceOffset();
            if (n >= n2) {
                String string = iDocument.get(n2, n - n2);
                return this.fTemplate.getName().toLowerCase().startsWith(string.toLowerCase());
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        return this.fTemplate.getName();
    }

    @Override
    public int getPrefixCompletionStart(IDocument iDocument, int n) {
        return this.getReplaceOffset();
    }

    @Override
    public void apply(IDocument iDocument, char c, int n) {
    }

    @Override
    public boolean isValidFor(IDocument iDocument, int n) {
        return false;
    }

    @Override
    public char[] getTriggerCharacters() {
        return new char[0];
    }

    @Override
    public int getContextInformationPosition() {
        return this.fRegion.getOffset();
    }
}

