/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;
import org.eclipse.swt.graphics.Image;

public abstract class TemplateCompletionProcessor
implements IContentAssistProcessor {
    private static final Comparator fgProposalComparator = new ProposalComparator();

    @Override
    public ICompletionProposal[] computeCompletionProposals(ITextViewer iTextViewer, int n) {
        String string;
        Region region;
        TemplateContext templateContext;
        ITextSelection iTextSelection = (ITextSelection)iTextViewer.getSelectionProvider().getSelection();
        if (iTextSelection.getOffset() == n) {
            n = iTextSelection.getOffset() + iTextSelection.getLength();
        }
        if ((templateContext = this.createContext(iTextViewer, (IRegion)(region = new Region(n - (string = this.extractPrefix(iTextViewer, n)).length(), string.length())))) == null) {
            return new ICompletionProposal[0];
        }
        templateContext.setVariable("selection", iTextSelection.getText());
        Template[] templateArray = this.getTemplates(templateContext.getContextType().getId());
        ArrayList<ICompletionProposal> arrayList = new ArrayList<ICompletionProposal>();
        int n2 = 0;
        while (n2 < templateArray.length) {
            block6: {
                Template template = templateArray[n2];
                try {
                    templateContext.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block6;
                }
                if (template.matches(string, templateContext.getContextType().getId())) {
                    arrayList.add(this.createProposal(template, templateContext, (IRegion)region, this.getRelevance(template, string)));
                }
            }
            ++n2;
        }
        Collections.sort(arrayList, fgProposalComparator);
        return arrayList.toArray(new ICompletionProposal[arrayList.size()]);
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext templateContext, Region region, int n) {
        return this.createProposal(template, templateContext, (IRegion)region, n);
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext templateContext, IRegion iRegion, int n) {
        return new TemplateProposal(template, templateContext, iRegion, this.getImage(template), n);
    }

    protected abstract Template[] getTemplates(String var1);

    protected TemplateContext createContext(ITextViewer iTextViewer, IRegion iRegion) {
        TemplateContextType templateContextType = this.getContextType(iTextViewer, iRegion);
        if (templateContextType != null) {
            IDocument iDocument = iTextViewer.getDocument();
            return new DocumentTemplateContext(templateContextType, iDocument, iRegion.getOffset(), iRegion.getLength());
        }
        return null;
    }

    protected abstract TemplateContextType getContextType(ITextViewer var1, IRegion var2);

    protected int getRelevance(Template template, String string) {
        if (template.getName().startsWith(string)) {
            return 90;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    protected String extractPrefix(ITextViewer var1_1, int var2_2) {
        var3_3 = var2_2;
        var4_4 = var1_1.getDocument();
        if (var3_3 <= var4_4.getLength()) ** GOTO lbl7
        return "";
        {
            while (Character.isJavaIdentifierPart(var5_5 = var4_4.getChar(var3_3 - 1))) {
                --var3_3;
lbl7:
                // 2 sources

                if (var3_3 > 0) continue;
            }
            return var4_4.get(var3_3, var2_2 - var3_3);
        }
    }

    protected abstract Image getImage(Template var1);

    @Override
    public IContextInformation[] computeContextInformation(ITextViewer iTextViewer, int n) {
        return null;
    }

    @Override
    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    @Override
    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private static final class ProposalComparator
    implements Comparator {
        private ProposalComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((TemplateProposal)object2).getRelevance() - ((TemplateProposal)object).getRelevance();
        }
    }
}

