/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.SelectionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentInformationMappingExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.projection.ProjectionDocument;
import org.eclipse.jface.text.projection.ProjectionDocumentEvent;
import org.eclipse.jface.text.projection.ProjectionDocumentManager;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSummary;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ProjectionViewer
extends SourceViewer
implements ITextViewerExtension5 {
    private static final int BASE = 16;
    public static final int EXPAND = 17;
    public static final int COLLAPSE = 18;
    public static final int TOGGLE = 19;
    public static final int EXPAND_ALL = 20;
    public static final int COLLAPSE_ALL = 21;
    private ProjectionAnnotationModel fProjectionAnnotationModel;
    private IAnnotationModelListener fAnnotationModelListener = new AnnotationModelListener();
    private ProjectionSummary fProjectionSummary;
    private boolean fPendingAnnotationWorldChange = false;
    private boolean fHandleProjectionChanges = true;
    private List fProjectionListeners;
    private Object fLock = new Object();
    private List fPendingRequests = new ArrayList();
    private IDocument fReplaceVisibleDocumentExecutionTrigger;
    private boolean fWasProjectionEnabled;
    private ProjectionCommandQueue fCommandQueue;
    private int fDeletedLines;

    public ProjectionViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n) {
        super(composite, iVerticalRuler, iOverviewRuler, bl, n);
    }

    public void setProjectionSummary(ProjectionSummary projectionSummary) {
        this.fProjectionSummary = projectionSummary;
    }

    private void addProjectionAnnotationModel(IAnnotationModel iAnnotationModel) {
        if (iAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
            iAnnotationModelExtension.addAnnotationModel(ProjectionSupport.PROJECTION, (IAnnotationModel)this.fProjectionAnnotationModel);
            iAnnotationModel.addAnnotationModelListener(this.fAnnotationModelListener);
        }
    }

    private IAnnotationModel removeProjectionAnnotationModel(IAnnotationModel iAnnotationModel) {
        if (iAnnotationModel instanceof IAnnotationModelExtension) {
            iAnnotationModel.removeAnnotationModelListener(this.fAnnotationModelListener);
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
            return iAnnotationModelExtension.removeAnnotationModel(ProjectionSupport.PROJECTION);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDocument(IDocument iDocument, IAnnotationModel iAnnotationModel, int n, int n2) {
        boolean bl = false;
        Object object = this.fLock;
        synchronized (object) {
            this.fPendingRequests.clear();
        }
        if (this.fProjectionAnnotationModel != null) {
            bl = this.removeProjectionAnnotationModel(this.getVisualAnnotationModel()) != null;
            this.fProjectionAnnotationModel = null;
        }
        super.setDocument(iDocument, iAnnotationModel, n, n2);
        if (bl && iDocument != null) {
            this.enableProjection();
        }
    }

    @Override
    protected IAnnotationModel createVisualAnnotationModel(IAnnotationModel iAnnotationModel) {
        IAnnotationModel iAnnotationModel2 = super.createVisualAnnotationModel(iAnnotationModel);
        this.fProjectionAnnotationModel = new ProjectionAnnotationModel();
        return iAnnotationModel2;
    }

    public ProjectionAnnotationModel getProjectionAnnotationModel() {
        IAnnotationModel iAnnotationModel = this.getVisualAnnotationModel();
        if (iAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
            return (ProjectionAnnotationModel)iAnnotationModelExtension.getAnnotationModel(ProjectionSupport.PROJECTION);
        }
        return null;
    }

    @Override
    protected ISlaveDocumentManager createSlaveDocumentManager() {
        return new ProjectionDocumentManager();
    }

    @Override
    protected boolean updateSlaveDocument(IDocument iDocument, int n, int n2) throws BadLocationException {
        if (iDocument instanceof ProjectionDocument) {
            ProjectionDocument projectionDocument = (ProjectionDocument)iDocument;
            int n3 = n;
            int n4 = n2;
            if (!this.isProjectionMode()) {
                IDocument iDocument2 = projectionDocument.getMasterDocument();
                int n5 = iDocument2.getLineOfOffset(n);
                n3 = iDocument2.getLineOffset(n5);
                n4 = n - n3 + n2;
            }
            try {
                this.fHandleProjectionChanges = false;
                projectionDocument.replaceMasterDocumentRanges(n3, n4);
            }
            finally {
                this.fHandleProjectionChanges = true;
            }
            return true;
        }
        return false;
    }

    public void addProjectionListener(IProjectionListener iProjectionListener) {
        Assert.isNotNull((Object)iProjectionListener);
        if (this.fProjectionListeners == null) {
            this.fProjectionListeners = new ArrayList();
        }
        if (!this.fProjectionListeners.contains(iProjectionListener)) {
            this.fProjectionListeners.add(iProjectionListener);
        }
    }

    public void removeProjectionListener(IProjectionListener iProjectionListener) {
        Assert.isNotNull((Object)iProjectionListener);
        if (this.fProjectionListeners != null) {
            this.fProjectionListeners.remove(iProjectionListener);
            if (this.fProjectionListeners.size() == 0) {
                this.fProjectionListeners = null;
            }
        }
    }

    protected void fireProjectionEnabled() {
        if (this.fProjectionListeners != null) {
            for (IProjectionListener iProjectionListener : new ArrayList(this.fProjectionListeners)) {
                iProjectionListener.projectionEnabled();
            }
        }
    }

    protected void fireProjectionDisabled() {
        if (this.fProjectionListeners != null) {
            for (IProjectionListener iProjectionListener : new ArrayList(this.fProjectionListeners)) {
                iProjectionListener.projectionDisabled();
            }
        }
    }

    public final boolean isProjectionMode() {
        return this.getProjectionAnnotationModel() != null;
    }

    public final void disableProjection() {
        if (this.isProjectionMode()) {
            this.removeProjectionAnnotationModel(this.getVisualAnnotationModel());
            this.fProjectionAnnotationModel.removeAllAnnotations();
            this.fFindReplaceDocumentAdapter = null;
            this.fireProjectionDisabled();
        }
    }

    public final void enableProjection() {
        if (!this.isProjectionMode()) {
            this.addProjectionAnnotationModel(this.getVisualAnnotationModel());
            this.fFindReplaceDocumentAdapter = null;
            this.fireProjectionEnabled();
        }
    }

    private void expandAll() {
        int n;
        int n2 = 0;
        IDocument iDocument = this.getDocument();
        int n3 = n = iDocument == null ? 0 : iDocument.getLength();
        if (this.isProjectionMode()) {
            this.fProjectionAnnotationModel.expandAll(n2, n);
        }
    }

    private void expand() {
        if (this.isProjectionMode()) {
            Position position = null;
            ProjectionAnnotation projectionAnnotation = null;
            Point point = this.getSelectedRange();
            Iterator iterator = this.fProjectionAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Position position2;
                ProjectionAnnotation projectionAnnotation2 = (ProjectionAnnotation)iterator.next();
                if (!projectionAnnotation2.isCollapsed() || (position2 = this.fProjectionAnnotationModel.getPosition(projectionAnnotation2)) == null || !this.touches(point, position2) || position != null && (!position2.includes(position.offset) || !position2.includes(position.offset + position.length))) continue;
                position = position2;
                projectionAnnotation = projectionAnnotation2;
            }
            if (projectionAnnotation != null) {
                this.fProjectionAnnotationModel.expand(projectionAnnotation);
                this.revealRange(point.x, point.y);
            }
        }
    }

    private boolean touches(Point point, Position position) {
        return position.overlapsWith(point.x, point.y) || point.y == 0 && position.offset + position.length == point.x + point.y;
    }

    private void collapse() {
        if (this.isProjectionMode()) {
            Position position = null;
            ProjectionAnnotation projectionAnnotation = null;
            Point point = this.getSelectedRange();
            Iterator iterator = this.fProjectionAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Position position2;
                ProjectionAnnotation projectionAnnotation2 = (ProjectionAnnotation)iterator.next();
                if (projectionAnnotation2.isCollapsed() || (position2 = this.fProjectionAnnotationModel.getPosition(projectionAnnotation2)) == null || !this.touches(point, position2) || position != null && (!position.includes(position2.offset) || !position.includes(position2.offset + position2.length))) continue;
                position = position2;
                projectionAnnotation = projectionAnnotation2;
            }
            if (projectionAnnotation != null) {
                this.fProjectionAnnotationModel.collapse(projectionAnnotation);
                this.revealRange(point.x, point.y);
            }
        }
    }

    private void collapseAll() {
        int n;
        int n2 = 0;
        IDocument iDocument = this.getDocument();
        int n3 = n = iDocument == null ? 0 : iDocument.getLength();
        if (this.isProjectionMode()) {
            this.fProjectionAnnotationModel.collapseAll(n2, n);
        }
    }

    private void addMasterDocumentRange(ProjectionDocument projectionDocument, int n, int n2) throws BadLocationException {
        if (this.fCommandQueue != null) {
            this.fCommandQueue.add(new ProjectionCommand(projectionDocument, 0, n, n2));
        } else {
            try {
                this.fHandleProjectionChanges = false;
                int n3 = n + n2;
                n = this.toLineStart(projectionDocument.getMasterDocument(), n, false);
                n2 = this.toLineStart(projectionDocument.getMasterDocument(), n3, true) - n;
                projectionDocument.addMasterDocumentRange(n, n2);
            }
            finally {
                this.fHandleProjectionChanges = true;
            }
        }
    }

    private void removeMasterDocumentRange(ProjectionDocument projectionDocument, int n, int n2) throws BadLocationException {
        if (this.fCommandQueue != null) {
            this.fCommandQueue.add(new ProjectionCommand(projectionDocument, 1, n, n2));
        } else {
            try {
                this.fHandleProjectionChanges = false;
                int n3 = n + n2;
                n = this.toLineStart(projectionDocument.getMasterDocument(), n, false);
                n2 = this.toLineStart(projectionDocument.getMasterDocument(), n3, true) - n;
                projectionDocument.removeMasterDocumentRange(n, n2);
            }
            finally {
                this.fHandleProjectionChanges = true;
            }
        }
    }

    private int toLineStart(IDocument iDocument, int n, boolean bl) throws BadLocationException {
        if (iDocument == null) {
            return n;
        }
        if (bl && n >= iDocument.getLineInformationOfOffset(iDocument.getLength() - 1).getOffset()) {
            return n;
        }
        return iDocument.getLineInformationOfOffset(n).getOffset();
    }

    @Override
    public void setVisibleRegion(int n, int n2) {
        this.fWasProjectionEnabled = this.isProjectionMode();
        this.disableProjection();
        super.setVisibleRegion(n, n2);
    }

    @Override
    protected void setVisibleDocument(IDocument iDocument) {
        if (!this.isProjectionMode()) {
            super.setVisibleDocument(iDocument);
            return;
        }
        FindReplaceDocumentAdapter findReplaceDocumentAdapter = this.fFindReplaceDocumentAdapter;
        super.setVisibleDocument(iDocument);
        this.fFindReplaceDocumentAdapter = findReplaceDocumentAdapter;
    }

    @Override
    public void resetVisibleRegion() {
        super.resetVisibleRegion();
        if (this.fWasProjectionEnabled) {
            this.enableProjection();
        }
    }

    @Override
    public IRegion getVisibleRegion() {
        this.disableProjection();
        IRegion iRegion = this.getModelCoverage();
        if (iRegion == null) {
            iRegion = new Region(0, 0);
        }
        return iRegion;
    }

    @Override
    public boolean overlapsWithVisibleRegion(int n, int n2) {
        boolean bl;
        this.disableProjection();
        IRegion iRegion = this.getModelCoverage();
        if (iRegion == null) {
            return false;
        }
        boolean bl2 = bl = n == iRegion.getOffset() + iRegion.getLength() && n2 == 0;
        return bl || TextUtilities.overlaps((IRegion)iRegion, (IRegion)new Region(n, n2));
    }

    private void replaceVisibleDocument(IDocument iDocument) {
        if (this.fReplaceVisibleDocumentExecutionTrigger != null) {
            ReplaceVisibleDocumentExecutor replaceVisibleDocumentExecutor = new ReplaceVisibleDocumentExecutor(iDocument);
            replaceVisibleDocumentExecutor.install(this.fReplaceVisibleDocumentExecutionTrigger);
        } else {
            this.executeReplaceVisibleDocument(iDocument);
        }
    }

    private void executeReplaceVisibleDocument(IDocument iDocument) {
        StyledText styledText = this.getTextWidget();
        try {
            if (styledText != null && !styledText.isDisposed()) {
                styledText.setRedraw(false);
            }
            int n = this.getTopIndex();
            Point point = this.getSelectedRange();
            this.setVisibleDocument(iDocument);
            Point point2 = this.getSelectedRange();
            if (point2.x != point.x || point2.y != point.y) {
                this.setSelectedRange(point.x, point.y);
            }
            this.setTopIndex(n);
        }
        finally {
            if (styledText != null && !styledText.isDisposed()) {
                styledText.setRedraw(true);
            }
        }
    }

    private void collapse(int n, int n2, boolean bl) throws BadLocationException {
        int n3;
        IDocument iDocument;
        ProjectionDocument projectionDocument = null;
        IDocument iDocument2 = this.getVisibleDocument();
        if (iDocument2 instanceof ProjectionDocument) {
            projectionDocument = (ProjectionDocument)iDocument2;
        } else {
            iDocument = this.getDocument();
            IDocument iDocument3 = this.createSlaveDocument(this.getDocument());
            if (iDocument3 instanceof ProjectionDocument) {
                projectionDocument = (ProjectionDocument)iDocument3;
                this.addMasterDocumentRange(projectionDocument, 0, iDocument.getLength());
                this.replaceVisibleDocument((IDocument)projectionDocument);
            }
        }
        if (projectionDocument != null) {
            this.removeMasterDocumentRange(projectionDocument, n, n2);
        }
        if (projectionDocument != null && bl && (n3 = (iDocument = this.getDocument()).getLineOfOffset(n)) > 0) {
            IRegion iRegion = iDocument.getLineInformation(n3 - 1);
            this.internalInvalidateTextPresentation(iRegion.getOffset(), iRegion.getLength());
        }
    }

    private void expand(int n, int n2, boolean bl) throws BadLocationException {
        IDocument iDocument = this.getVisibleDocument();
        if (iDocument instanceof ProjectionDocument) {
            ProjectionDocument projectionDocument = (ProjectionDocument)iDocument;
            this.addMasterDocumentRange(projectionDocument, n, n2);
            ProjectionAnnotation[] projectionAnnotationArray = this.computeCollapsedNestedAnnotations(n, n2);
            if (projectionAnnotationArray != null) {
                int n3 = 0;
                while (n3 < projectionAnnotationArray.length) {
                    IRegion[] iRegionArray = this.computeCollapsedRegions(this.fProjectionAnnotationModel.getPosition(projectionAnnotationArray[n3]));
                    if (iRegionArray != null) {
                        int n4 = 0;
                        while (n4 < iRegionArray.length) {
                            this.removeMasterDocumentRange(projectionDocument, iRegionArray[n4].getOffset(), iRegionArray[n4].getLength());
                            ++n4;
                        }
                    }
                    ++n3;
                }
            }
            if (bl) {
                this.internalInvalidateTextPresentation(n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processCatchupRequest(AnnotationModelEvent annotationModelEvent) {
        if (Display.getCurrent() != null) {
            boolean bl = false;
            Object object = this.fLock;
            synchronized (object) {
                bl = this.fPendingRequests.isEmpty();
            }
            if (bl) {
                try {
                    this.catchupWithProjectionAnnotationModel(annotationModelEvent);
                }
                catch (BadLocationException badLocationException) {
                    throw new IllegalArgumentException();
                }
            } else {
                this.postCatchupRequest(annotationModelEvent);
            }
        } else {
            this.postCatchupRequest(annotationModelEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postCatchupRequest(AnnotationModelEvent annotationModelEvent) {
        Object object = this.fLock;
        synchronized (object) {
            Display display;
            StyledText styledText;
            this.fPendingRequests.add(annotationModelEvent);
            if (this.fPendingRequests.size() == 1 && (styledText = this.getTextWidget()) != null && (display = styledText.getDisplay()) != null) {
                display.asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            while (true) {
                                AnnotationModelEvent annotationModelEvent = null;
                                Object object = ProjectionViewer.this.fLock;
                                synchronized (object) {
                                    if (ProjectionViewer.this.fPendingRequests.size() == 0) {
                                        return;
                                    }
                                    annotationModelEvent = (AnnotationModelEvent)ProjectionViewer.this.fPendingRequests.remove(0);
                                }
                                ProjectionViewer.this.catchupWithProjectionAnnotationModel(annotationModelEvent);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            try {
                                try {
                                    ProjectionViewer.this.catchupWithProjectionAnnotationModel(null);
                                }
                                catch (BadLocationException badLocationException2) {
                                    throw new IllegalArgumentException();
                                }
                            }
                            catch (Throwable throwable) {
                                Object object = ProjectionViewer.this.fLock;
                                synchronized (object) {
                                    ProjectionViewer.this.fPendingRequests.clear();
                                }
                                throw throwable;
                            }
                            Object object = ProjectionViewer.this.fLock;
                            synchronized (object) {
                                ProjectionViewer.this.fPendingRequests.clear();
                            }
                            return;
                        }
                    }
                });
            }
        }
    }

    private boolean isVisibleMasterDocumentSameAsDocument() {
        IDocument iDocument = this.getVisibleDocument();
        return iDocument instanceof ProjectionDocument && ((ProjectionDocument)iDocument).getMasterDocument() == this.getDocument();
    }

    private void catchupWithProjectionAnnotationModel(AnnotationModelEvent annotationModelEvent) throws BadLocationException {
        if (annotationModelEvent == null || !this.isVisibleMasterDocumentSameAsDocument()) {
            this.fPendingAnnotationWorldChange = false;
            this.reinitializeProjection();
        } else if (annotationModelEvent.isWorldChange()) {
            if (annotationModelEvent.isValid()) {
                this.fPendingAnnotationWorldChange = false;
                this.reinitializeProjection();
            } else {
                this.fPendingAnnotationWorldChange = true;
            }
        } else if (this.fPendingAnnotationWorldChange) {
            if (annotationModelEvent.isValid()) {
                this.fPendingAnnotationWorldChange = false;
                this.reinitializeProjection();
            }
        } else {
            Annotation[] annotationArray = annotationModelEvent.getAddedAnnotations();
            Annotation[] annotationArray2 = annotationModelEvent.getChangedAnnotations();
            Annotation[] annotationArray3 = annotationModelEvent.getRemovedAnnotations();
            this.fCommandQueue = new ProjectionCommandQueue();
            boolean bl = this.redraws();
            int n = bl ? this.getTopIndex() : -1;
            this.processDeletions(annotationModelEvent, annotationArray3, true);
            ArrayList arrayList = new ArrayList();
            this.processChanges(annotationArray, true, arrayList);
            this.processChanges(annotationArray2, true, arrayList);
            ProjectionCommandQueue projectionCommandQueue = this.fCommandQueue;
            this.fCommandQueue = null;
            if (projectionCommandQueue.passedRedrawCostsThreshold()) {
                this.setRedraw(false);
                try {
                    try {
                        this.executeProjectionCommands(projectionCommandQueue, false);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.reinitializeProjection();
                        this.setRedraw(true, n);
                    }
                }
                finally {
                    this.setRedraw(true, n);
                }
            } else {
                try {
                    boolean bl2 = !projectionCommandQueue.passedInvalidationCostsThreshold();
                    this.executeProjectionCommands(projectionCommandQueue, bl2);
                    if (!bl2) {
                        this.invalidateTextPresentation();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.reinitializeProjection();
                }
            }
        }
    }

    private void executeProjectionCommands(ProjectionCommandQueue projectionCommandQueue, boolean bl) throws BadLocationException {
        Iterator iterator = projectionCommandQueue.iterator();
        while (iterator.hasNext()) {
            ProjectionCommand projectionCommand = (ProjectionCommand)iterator.next();
            switch (projectionCommand.fType) {
                case 0: {
                    this.addMasterDocumentRange(projectionCommand.fProjection, projectionCommand.fOffset, projectionCommand.fLength);
                    break;
                }
                case 1: {
                    this.removeMasterDocumentRange(projectionCommand.fProjection, projectionCommand.fOffset, projectionCommand.fLength);
                    break;
                }
                case 2: {
                    if (!bl) break;
                    this.invalidateTextPresentation(projectionCommand.fOffset, projectionCommand.fLength);
                }
            }
        }
        projectionCommandQueue.clear();
    }

    private boolean covers(int n, int n2, Position position) {
        if (!(position.offset == n && position.length == n2 || position.isDeleted())) {
            return n <= position.getOffset() && position.getOffset() + position.getLength() <= n + n2;
        }
        return false;
    }

    private ProjectionAnnotation[] computeCollapsedNestedAnnotations(int n, int n2) {
        ProjectionAnnotation[] projectionAnnotationArray;
        ArrayList<ProjectionAnnotation[]> arrayList = new ArrayList<ProjectionAnnotation[]>(5);
        Iterator iterator = this.fProjectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            projectionAnnotationArray = (ProjectionAnnotation[])iterator.next();
            if (!projectionAnnotationArray.isCollapsed() || (position = this.fProjectionAnnotationModel.getPosition((Annotation)projectionAnnotationArray)) == null || !this.covers(n, n2, position)) continue;
            arrayList.add(projectionAnnotationArray);
        }
        if (arrayList.size() > 0) {
            projectionAnnotationArray = new ProjectionAnnotation[arrayList.size()];
            arrayList.toArray(projectionAnnotationArray);
            return projectionAnnotationArray;
        }
        return null;
    }

    private void internalInvalidateTextPresentation(int n, int n2) {
        if (this.fCommandQueue != null) {
            this.fCommandQueue.add(new ProjectionCommand(n, n2));
        } else {
            this.invalidateTextPresentation(n, n2);
        }
    }

    private void processDeletions(AnnotationModelEvent annotationModelEvent, Annotation[] annotationArray, boolean bl) throws BadLocationException {
        int n = 0;
        while (n < annotationArray.length) {
            ProjectionAnnotation projectionAnnotation = (ProjectionAnnotation)annotationArray[n];
            if (projectionAnnotation.isCollapsed()) {
                Position position = annotationModelEvent.getPositionOfRemovedAnnotation((Annotation)projectionAnnotation);
                this.expand(position.getOffset(), position.getLength(), bl);
            }
            ++n;
        }
    }

    public IRegion computeCollapsedRegion(Position position) {
        IDocument iDocument;
        block4: {
            try {
                iDocument = this.getDocument();
                if (iDocument != null) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        int n = iDocument.getLineOfOffset(position.getOffset());
        int n2 = iDocument.getLineOffset(n + 1);
        int n3 = position.getLength() - (n2 - position.getOffset());
        if (n3 > 0) {
            return new Region(n2, n3);
        }
        return null;
    }

    IRegion[] computeCollapsedRegions(Position position) {
        IDocument iDocument;
        block5: {
            try {
                iDocument = this.getDocument();
                if (iDocument != null) break block5;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        if (position instanceof IProjectionPosition) {
            IProjectionPosition iProjectionPosition = (IProjectionPosition)position;
            return iProjectionPosition.computeProjectionRegions(iDocument);
        }
        int n = iDocument.getLineOfOffset(position.getOffset());
        int n2 = iDocument.getLineOffset(n + 1);
        int n3 = position.getLength() - (n2 - position.getOffset());
        if (n3 > 0) {
            return new IRegion[]{new Region(n2, n3)};
        }
        return null;
    }

    public Position computeCollapsedRegionAnchor(Position position) {
        IDocument iDocument;
        block4: {
            try {
                iDocument = this.getDocument();
                if (iDocument != null) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int n = position.getOffset();
        if (position instanceof IProjectionPosition) {
            n += ((IProjectionPosition)position).computeCaptionOffset(iDocument);
        }
        IRegion iRegion = iDocument.getLineInformationOfOffset(n);
        return new Position(iRegion.getOffset() + iRegion.getLength(), 0);
    }

    private void processChanges(Annotation[] annotationArray, boolean bl, List list) throws BadLocationException {
        int n = 0;
        while (n < annotationArray.length) {
            ProjectionAnnotation projectionAnnotation = (ProjectionAnnotation)annotationArray[n];
            Position position = this.fProjectionAnnotationModel.getPosition(projectionAnnotation);
            if (position != null && !this.covers(list, position)) {
                if (projectionAnnotation.isCollapsed()) {
                    list.add(position);
                    IRegion[] iRegionArray = this.computeCollapsedRegions(position);
                    if (iRegionArray != null) {
                        int n2 = 0;
                        while (n2 < iRegionArray.length) {
                            this.collapse(iRegionArray[n2].getOffset(), iRegionArray[n2].getLength(), bl);
                            ++n2;
                        }
                    }
                } else {
                    this.expand(position.getOffset(), position.getLength(), bl);
                }
            }
            ++n;
        }
    }

    private boolean covers(List list, Position position) {
        for (Position position2 : list) {
            if (position2.getOffset() > position.getOffset() || position.getOffset() + position.getLength() > position2.getOffset() + position2.getLength()) continue;
            return true;
        }
        return false;
    }

    public final void reinitializeProjection() throws BadLocationException {
        Object object;
        Object object2;
        ProjectionDocument projectionDocument = null;
        ISlaveDocumentManager iSlaveDocumentManager = this.getSlaveDocumentManager();
        if (iSlaveDocumentManager != null && (object2 = this.getDocument()) != null && (object = iSlaveDocumentManager.createSlaveDocument((IDocument)object2)) instanceof ProjectionDocument) {
            projectionDocument = (ProjectionDocument)object;
            this.addMasterDocumentRange(projectionDocument, 0, object2.getLength());
        }
        if (projectionDocument != null) {
            object2 = this.fProjectionAnnotationModel.getAnnotationIterator();
            while (object2.hasNext()) {
                IRegion[] iRegionArray;
                Position position;
                object = (ProjectionAnnotation)object2.next();
                if (!((ProjectionAnnotation)object).isCollapsed() || (position = this.fProjectionAnnotationModel.getPosition((Annotation)object)) == null || (iRegionArray = this.computeCollapsedRegions(position)) == null) continue;
                int n = 0;
                while (n < iRegionArray.length) {
                    this.removeMasterDocumentRange(projectionDocument, iRegionArray[n].getOffset(), iRegionArray[n].getLength());
                    ++n;
                }
            }
        }
        this.replaceVisibleDocument((IDocument)projectionDocument);
    }

    @Override
    protected void handleVerifyEvent(VerifyEvent verifyEvent) {
        if (this.getTextWidget().getBlockSelection()) {
            ITextSelection iTextSelection = (ITextSelection)this.getSelection();
            if (this.exposeModelRange((IRegion)new Region(iTextSelection.getOffset(), iTextSelection.getLength()))) {
                this.setSelection(iTextSelection);
            }
            super.handleVerifyEvent(verifyEvent);
            return;
        }
        Point point = this.getSelectedRange();
        IRegion iRegion = this.event2ModelRange(verifyEvent);
        if (this.exposeModelRange(iRegion)) {
            verifyEvent.doit = false;
            try {
                if (point.y == 0 && verifyEvent.text.length() <= 1 && iRegion.getLength() == 1) {
                    point.y = 1;
                    if (point.x - 1 == iRegion.getOffset()) {
                        --point.x;
                    }
                }
                this.getDocument().replace(point.x, point.y, verifyEvent.text);
                this.setSelectedRange(point.x + verifyEvent.text.length(), 0);
            }
            catch (BadLocationException badLocationException) {}
        } else {
            super.handleVerifyEvent(verifyEvent);
        }
    }

    @Override
    public boolean exposeModelRange(IRegion iRegion) {
        if (this.isProjectionMode()) {
            return this.fProjectionAnnotationModel.expandAll(iRegion.getOffset(), iRegion.getLength());
        }
        if (!this.overlapsWithVisibleRegion(iRegion.getOffset(), iRegion.getLength())) {
            this.resetVisibleRegion();
            return true;
        }
        return false;
    }

    @Override
    public void setRangeIndication(int n, int n2, boolean bl) {
        IRegion iRegion = this.getRangeIndication();
        if (bl && this.fProjectionAnnotationModel != null && (iRegion == null || n != iRegion.getOffset() || n2 != iRegion.getLength())) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            Iterator iterator = this.fProjectionAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                object = (ProjectionAnnotation)iterator.next();
                if (!((ProjectionAnnotation)object).isCollapsed() || !this.willAutoExpand(this.fProjectionAnnotationModel.getPosition((Annotation)object), n, n2)) continue;
                arrayList.add(object);
            }
            if (!arrayList.isEmpty()) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    this.fProjectionAnnotationModel.expand((Annotation)object.next());
                }
            }
        }
        super.setRangeIndication(n, n2, bl);
    }

    private boolean willAutoExpand(Position position, int n, int n2) {
        if (position == null || position.isDeleted()) {
            return false;
        }
        if (position.getOffset() == n || position.getOffset() + position.getLength() == n + n2) {
            return true;
        }
        return position.getOffset() < n && n + n2 < position.getOffset() + position.getLength();
    }

    @Override
    protected void handleDispose() {
        this.fWasProjectionEnabled = false;
        super.handleDispose();
    }

    @Override
    protected void handleVisibleDocumentChanged(DocumentEvent documentEvent) {
        block10: {
            if (this.fHandleProjectionChanges && documentEvent instanceof ProjectionDocumentEvent && this.isProjectionMode()) {
                ProjectionDocumentEvent projectionDocumentEvent = (ProjectionDocumentEvent)documentEvent;
                DocumentEvent documentEvent2 = projectionDocumentEvent.getMasterEvent();
                if (documentEvent2 != null) {
                    this.fReplaceVisibleDocumentExecutionTrigger = documentEvent2.getDocument();
                }
                try {
                    int n;
                    int n2 = n = projectionDocumentEvent.getText() == null ? 0 : projectionDocumentEvent.getText().length();
                    if (ProjectionDocumentEvent.PROJECTION_CHANGE == projectionDocumentEvent.getChangeType()) {
                        if (projectionDocumentEvent.getLength() == 0 && n != 0) {
                            this.fProjectionAnnotationModel.expandAll(projectionDocumentEvent.getMasterOffset(), projectionDocumentEvent.getMasterLength());
                        }
                        break block10;
                    }
                    if (documentEvent2 == null || n <= 0 && this.fDeletedLines <= 1) break block10;
                    try {
                        int n3 = projectionDocumentEvent.getDocument().getNumberOfLines(projectionDocumentEvent.getOffset(), n);
                        if (n3 > 1 || this.fDeletedLines > 1) {
                            this.fProjectionAnnotationModel.expandAll(documentEvent2.getOffset(), n);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                finally {
                    this.fReplaceVisibleDocumentExecutionTrigger = null;
                }
            }
        }
    }

    @Override
    protected void handleVisibleDocumentAboutToBeChanged(DocumentEvent documentEvent) {
        if (this.fHandleProjectionChanges && documentEvent instanceof ProjectionDocumentEvent && this.isProjectionMode()) {
            int n;
            try {
                n = documentEvent.getDocument().getNumberOfLines(documentEvent.getOffset(), documentEvent.getLength());
            }
            catch (BadLocationException badLocationException) {
                n = 0;
            }
            this.fDeletedLines = n;
        }
    }

    @Override
    public IRegion[] getCoveredModelRanges(IRegion iRegion) {
        if (this.fInformationMapping == null) {
            return new IRegion[]{new Region(iRegion.getOffset(), iRegion.getLength())};
        }
        if (this.fInformationMapping instanceof IDocumentInformationMappingExtension) {
            IDocumentInformationMappingExtension iDocumentInformationMappingExtension = (IDocumentInformationMappingExtension)this.fInformationMapping;
            try {
                return iDocumentInformationMappingExtension.getExactCoverage(iRegion);
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    @Override
    public void doOperation(int n) {
        switch (n) {
            case 19: {
                if (!this.canDoOperation(19)) break;
                if (!this.isProjectionMode()) {
                    this.enableProjection();
                } else {
                    this.expandAll();
                    this.disableProjection();
                }
                return;
            }
        }
        if (!this.isProjectionMode()) {
            super.doOperation(n);
            return;
        }
        StyledText styledText = this.getTextWidget();
        if (styledText == null) {
            return;
        }
        ITextSelection iTextSelection = null;
        switch (n) {
            case 3: {
                if (!this.redraws()) break;
                iTextSelection = (ITextSelection)this.getSelection();
                if (this.exposeModelRange((IRegion)new Region(iTextSelection.getOffset(), iTextSelection.getLength()))) {
                    return;
                }
                if (iTextSelection.getLength() == 0) {
                    this.copyMarkedRegion(true);
                } else {
                    this.copyToClipboard(iTextSelection, true, styledText);
                }
                Point point = styledText.getSelectionRange();
                this.fireSelectionChanged(point.x, point.y);
                break;
            }
            case 4: {
                if (!this.redraws()) break;
                iTextSelection = (ITextSelection)this.getSelection();
                if (iTextSelection.getLength() == 0) {
                    this.copyMarkedRegion(false);
                    break;
                }
                this.copyToClipboard(iTextSelection, false, styledText);
                break;
            }
            case 6: {
                if (!this.redraws()) break;
                try {
                    iTextSelection = (ITextSelection)this.getSelection();
                    int n2 = iTextSelection.getLength();
                    if (!(styledText.getBlockSelection() || n2 != 0 && n2 != styledText.getSelectionRange().y)) {
                        this.getTextWidget().invokeAction(127);
                    } else {
                        this.deleteSelection(iTextSelection, styledText);
                    }
                    Point point = styledText.getSelectionRange();
                    this.fireSelectionChanged(point.x, point.y);
                }
                catch (BadLocationException badLocationException) {}
                break;
            }
            case 20: {
                if (!this.redraws()) break;
                this.expandAll();
                break;
            }
            case 17: {
                if (!this.redraws()) break;
                this.expand();
                break;
            }
            case 21: {
                if (!this.redraws()) break;
                this.collapseAll();
                break;
            }
            case 18: {
                if (!this.redraws()) break;
                this.collapse();
                break;
            }
            default: {
                super.doOperation(n);
            }
        }
    }

    @Override
    public boolean canDoOperation(int n) {
        switch (n) {
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                return this.isProjectionMode();
            }
            case 19: {
                return this.isProjectionMode() || !this.isSegmented();
            }
        }
        return super.canDoOperation(n);
    }

    private boolean isSegmented() {
        IDocument iDocument = this.getDocument();
        int n = iDocument == null ? 0 : iDocument.getLength();
        IRegion iRegion = this.getModelCoverage();
        boolean bl = iRegion != null && !iRegion.equals(new Region(0, n));
        return bl;
    }

    private IRegion getMarkedRegion() {
        int n;
        if (this.getTextWidget() == null) {
            return null;
        }
        if (this.fMarkPosition == null || this.fMarkPosition.isDeleted()) {
            return null;
        }
        int n2 = this.fMarkPosition.getOffset();
        return n2 > (n = this.getSelectedRange().x) ? new Region(n, n2 - n) : new Region(n2, n - n2);
    }

    @Override
    protected void copyMarkedRegion(boolean bl) {
        IRegion iRegion = this.getMarkedRegion();
        if (iRegion != null) {
            this.copyToClipboard(new TextSelection(this.getDocument(), iRegion.getOffset(), iRegion.getLength()), bl, this.getTextWidget());
        }
    }

    private void copyToClipboard(ITextSelection iTextSelection, boolean bl, StyledText styledText) {
        String string = iTextSelection.getText();
        if (string == null) {
            styledText.copy();
        }
        if (string != null && string.equals(styledText.getSelectionText())) {
            styledText.copy();
        } else if (string != null) {
            Clipboard clipboard = new Clipboard(styledText.getDisplay());
            try {
                Transfer[] transferArray = new Transfer[]{TextTransfer.getInstance()};
                Object[] objectArray = new Object[]{string};
                try {
                    clipboard.setContents(objectArray, transferArray);
                }
                catch (SWTError sWTError) {
                    if (sWTError.code != 2002) {
                        throw sWTError;
                    }
                    clipboard.dispose();
                    return;
                }
            }
            finally {
                clipboard.dispose();
            }
        }
        if (bl) {
            try {
                this.deleteSelection(iTextSelection, styledText);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private void deleteSelection(ITextSelection iTextSelection, StyledText styledText) throws BadLocationException {
        new SelectionProcessor(this).doDelete(iTextSelection);
    }

    @Override
    protected Point widgetSelection2ModelSelection(Point point) {
        if (!this.isProjectionMode()) {
            return super.widgetSelection2ModelSelection(point);
        }
        IRegion iRegion = this.widgetRange2ModelRange((IRegion)new Region(point.x, point.y));
        if (iRegion == null) {
            return null;
        }
        int n = iRegion.getOffset();
        int n2 = n + iRegion.getLength();
        if (point.y == 0) {
            return new Point(n2, 0);
        }
        int n3 = point.x + point.y;
        Position[] positionArray = this.computeOverlappingAnnotationPositions(iRegion);
        int n4 = 0;
        while (n4 < positionArray.length) {
            IRegion[] iRegionArray = this.computeCollapsedRegions(positionArray[n4]);
            if (iRegionArray != null) {
                int n5 = 0;
                while (n5 < iRegionArray.length) {
                    IRegion iRegion2 = iRegionArray[n5];
                    IRegion iRegion3 = this.modelRange2ClosestWidgetRange(iRegion2);
                    if (iRegion3 != null && iRegion3.getLength() == 0) {
                        int n6 = iRegion3.getOffset();
                        if (n6 == point.x) {
                            n = Math.min(n, iRegion2.getOffset());
                        } else if (n6 == n3) {
                            n2 = Math.max(n2, iRegion2.getOffset() + iRegion2.getLength());
                        }
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        return new Point(n, n2 - n);
    }

    private Position[] computeOverlappingAnnotationPositions(IRegion iRegion) {
        ArrayList<Position> arrayList = new ArrayList<Position>();
        Iterator iterator = this.fProjectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            ProjectionAnnotation projectionAnnotation = (ProjectionAnnotation)iterator.next();
            Position position = this.fProjectionAnnotationModel.getPosition(projectionAnnotation);
            if (position == null || !position.overlapsWith(iRegion.getOffset(), iRegion.getLength()) || this.modelRange2WidgetRange(position) == null) continue;
            arrayList.add(position);
        }
        return arrayList.toArray(new Position[arrayList.size()]);
    }

    @Override
    protected FindReplaceDocumentAdapter getFindReplaceDocumentAdapter() {
        if (this.fFindReplaceDocumentAdapter == null) {
            IDocument iDocument = this.isProjectionMode() ? this.getDocument() : this.getVisibleDocument();
            this.fFindReplaceDocumentAdapter = new FindReplaceDocumentAdapter(iDocument);
        }
        return this.fFindReplaceDocumentAdapter;
    }

    @Override
    protected int findAndSelect(int n, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (!this.isProjectionMode()) {
            return super.findAndSelect(n, string, bl, bl2, bl3, bl4);
        }
        StyledText styledText = this.getTextWidget();
        if (styledText == null) {
            return -1;
        }
        try {
            IRegion iRegion = this.getFindReplaceDocumentAdapter().find(n, string, bl, bl2, bl3, bl4);
            if (iRegion != null) {
                this.exposeModelRange(iRegion);
                this.revealRange(iRegion.getOffset(), iRegion.getLength());
                this.setSelectedRange(iRegion.getOffset(), iRegion.getLength());
                return iRegion.getOffset();
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    @Override
    protected int findAndSelectInRange(int n, String string, boolean bl, boolean bl2, boolean bl3, int n2, int n3, boolean bl4) {
        if (!this.isProjectionMode()) {
            return super.findAndSelectInRange(n, string, bl, bl2, bl3, n2, n3, bl4);
        }
        StyledText styledText = this.getTextWidget();
        if (styledText == null) {
            return -1;
        }
        try {
            int n4 = n;
            if (bl && (n == -1 || n < n2)) {
                n4 = n2;
            } else if (!(bl || n != -1 && n <= n2 + n3)) {
                n4 = n2 + n3;
            }
            IRegion iRegion = this.getFindReplaceDocumentAdapter().find(n4, string, bl, bl2, bl3, bl4);
            if (iRegion != null) {
                int n5 = iRegion.getOffset();
                int n6 = iRegion.getLength();
                if (n2 <= n5 && n5 + n6 <= n2 + n3) {
                    this.exposeModelRange(iRegion);
                    this.revealRange(n5, n6);
                    this.setSelectedRange(n5, n6);
                    return n5;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        return -1;
    }

    private class AnnotationModelListener
    implements IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        private AnnotationModelListener() {
        }

        public void modelChanged(IAnnotationModel iAnnotationModel) {
            this.processModelChanged(iAnnotationModel, null);
        }

        public void modelChanged(AnnotationModelEvent annotationModelEvent) {
            this.processModelChanged(annotationModelEvent.getAnnotationModel(), annotationModelEvent);
        }

        private void processModelChanged(IAnnotationModel iAnnotationModel, AnnotationModelEvent annotationModelEvent) {
            if (iAnnotationModel == ProjectionViewer.this.fProjectionAnnotationModel) {
                if (ProjectionViewer.this.fProjectionSummary != null) {
                    ProjectionViewer.this.fProjectionSummary.updateSummaries();
                }
                ProjectionViewer.this.processCatchupRequest(annotationModelEvent);
            } else if (iAnnotationModel == ProjectionViewer.this.getAnnotationModel() && ProjectionViewer.this.fProjectionSummary != null) {
                ProjectionViewer.this.fProjectionSummary.updateSummaries();
            }
        }
    }

    private static class ProjectionCommand {
        static final int ADD = 0;
        static final int REMOVE = 1;
        static final int INVALIDATE_PRESENTATION = 2;
        ProjectionDocument fProjection;
        int fType;
        int fOffset;
        int fLength;

        ProjectionCommand(ProjectionDocument projectionDocument, int n, int n2, int n3) {
            this.fProjection = projectionDocument;
            this.fType = n;
            this.fOffset = n2;
            this.fLength = n3;
        }

        ProjectionCommand(int n, int n2) {
            this.fType = 2;
            this.fOffset = n;
            this.fLength = n2;
        }

        int computeExpectedCosts() {
            switch (this.fType) {
                case 0: {
                    try {
                        IRegion[] iRegionArray = this.fProjection.computeUnprojectedMasterRegions(this.fOffset, this.fLength);
                        return iRegionArray == null ? 0 : iRegionArray.length;
                    }
                    catch (BadLocationException badLocationException) {
                        break;
                    }
                }
                case 1: {
                    try {
                        IRegion[] iRegionArray = this.fProjection.computeProjectedMasterRegions(this.fOffset, this.fLength);
                        return iRegionArray == null ? 0 : iRegionArray.length;
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return 0;
        }
    }

    private static class ProjectionCommandQueue {
        static final int REDRAW_COSTS = 15;
        static final int INVALIDATION_COSTS = 10;
        List fList = new ArrayList(15);
        int fExpectedExecutionCosts = -1;

        private ProjectionCommandQueue() {
        }

        void add(ProjectionCommand projectionCommand) {
            this.fList.add(projectionCommand);
        }

        Iterator iterator() {
            return this.fList.iterator();
        }

        void clear() {
            this.fList.clear();
            this.fExpectedExecutionCosts = -1;
        }

        boolean passedRedrawCostsThreshold() {
            if (this.fExpectedExecutionCosts == -1) {
                this.computeExpectedExecutionCosts();
            }
            return this.fExpectedExecutionCosts > 15;
        }

        boolean passedInvalidationCostsThreshold() {
            if (this.fExpectedExecutionCosts == -1) {
                this.computeExpectedExecutionCosts();
            }
            return this.fExpectedExecutionCosts > 10;
        }

        private void computeExpectedExecutionCosts() {
            int n = Math.max(15, 10);
            this.fExpectedExecutionCosts = this.fList.size();
            if (this.fExpectedExecutionCosts <= n) {
                for (ProjectionCommand projectionCommand : this.fList) {
                    this.fExpectedExecutionCosts += projectionCommand.computeExpectedCosts();
                    if (this.fExpectedExecutionCosts > n) break;
                }
            }
        }
    }

    private class ReplaceVisibleDocumentExecutor
    implements IDocumentListener {
        private IDocument fSlaveDocument;
        private IDocument fExecutionTrigger;

        public ReplaceVisibleDocumentExecutor(IDocument iDocument) {
            this.fSlaveDocument = iDocument;
        }

        public void install(IDocument iDocument) {
            if (iDocument != null && this.fSlaveDocument != null) {
                this.fExecutionTrigger = iDocument;
                this.fExecutionTrigger.addDocumentListener((IDocumentListener)this);
            }
        }

        public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        }

        public void documentChanged(DocumentEvent documentEvent) {
            this.fExecutionTrigger.removeDocumentListener((IDocumentListener)this);
            ProjectionViewer.this.executeReplaceVisibleDocument(this.fSlaveDocument);
        }
    }
}

