/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationHover;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionRulerColumn;
import org.eclipse.jface.text.source.projection.ProjectionSummary;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextContent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ProjectionSupport {
    public static final Object PROJECTION = new Object();
    private ProjectionViewer fViewer;
    private IAnnotationAccess fAnnotationAccess;
    private ISharedTextColors fSharedTextColors;
    private List fSummarizableTypes;
    private IInformationControlCreator fInformationControlCreator;
    private IInformationControlCreator fInformationPresenterControlCreator;
    private ProjectionListener fProjectionListener;
    private ProjectionAnnotationsPainter fPainter;
    private ProjectionRulerColumn fColumn;
    private AnnotationPainter.IDrawingStrategy fDrawingStrategy;

    public ProjectionSupport(ProjectionViewer projectionViewer, IAnnotationAccess iAnnotationAccess, ISharedTextColors iSharedTextColors) {
        this.fViewer = projectionViewer;
        this.fAnnotationAccess = iAnnotationAccess;
        this.fSharedTextColors = iSharedTextColors;
    }

    public void addSummarizableAnnotationType(String string) {
        if (this.fSummarizableTypes == null) {
            this.fSummarizableTypes = new ArrayList();
            this.fSummarizableTypes.add(string);
        } else if (!this.fSummarizableTypes.contains(string)) {
            this.fSummarizableTypes.add(string);
        }
    }

    public void removeSummarizableAnnotationType(String string) {
        if (this.fSummarizableTypes != null) {
            this.fSummarizableTypes.remove(string);
            if (this.fSummarizableTypes.size() == 0) {
                this.fSummarizableTypes = null;
            }
        }
    }

    public void setHoverControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fInformationControlCreator = iInformationControlCreator;
    }

    public void setInformationPresenterControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fInformationPresenterControlCreator = iInformationControlCreator;
    }

    public void setAnnotationPainterDrawingStrategy(AnnotationPainter.IDrawingStrategy iDrawingStrategy) {
        this.fDrawingStrategy = iDrawingStrategy;
    }

    private AnnotationPainter.IDrawingStrategy getDrawingStrategy() {
        if (this.fDrawingStrategy == null) {
            this.fDrawingStrategy = new ProjectionDrawingStrategy();
        }
        return this.fDrawingStrategy;
    }

    public void install() {
        this.fViewer.setProjectionSummary(this.createProjectionSummary());
        this.fProjectionListener = new ProjectionListener();
        this.fViewer.addProjectionListener(this.fProjectionListener);
    }

    public void dispose() {
        if (this.fProjectionListener != null) {
            this.fViewer.removeProjectionListener(this.fProjectionListener);
            this.fProjectionListener = null;
        }
    }

    protected void doEnableProjection() {
        if (this.fPainter == null) {
            this.fPainter = new ProjectionAnnotationsPainter(this.fViewer, this.fAnnotationAccess);
            this.fPainter.addDrawingStrategy(PROJECTION, this.getDrawingStrategy());
            this.fPainter.addAnnotationType("org.eclipse.projection", PROJECTION);
            this.fPainter.setAnnotationTypeColor("org.eclipse.projection", this.fSharedTextColors.getColor(this.getColor()));
            this.fViewer.addPainter(this.fPainter);
        }
        if (this.fColumn == null) {
            this.fColumn = new ProjectionRulerColumn(9, this.fAnnotationAccess);
            this.fColumn.addAnnotationType("org.eclipse.projection");
            this.fColumn.setHover(this.createProjectionAnnotationHover());
            this.fViewer.addVerticalRulerColumn(this.fColumn);
        }
        this.fColumn.setModel(this.fViewer.getVisualAnnotationModel());
    }

    protected void doDisableProjection() {
        if (this.fPainter != null) {
            this.fViewer.removePainter(this.fPainter);
            this.fPainter.dispose();
            this.fPainter = null;
        }
        if (this.fColumn != null) {
            this.fViewer.removeVerticalRulerColumn(this.fColumn);
            this.fColumn = null;
        }
    }

    private ProjectionSummary createProjectionSummary() {
        ProjectionSummary projectionSummary = new ProjectionSummary(this.fViewer, this.fAnnotationAccess);
        if (this.fSummarizableTypes != null) {
            int n = this.fSummarizableTypes.size();
            int n2 = 0;
            while (n2 < n) {
                projectionSummary.addAnnotationType((String)this.fSummarizableTypes.get(n2));
                ++n2;
            }
        }
        return projectionSummary;
    }

    private IAnnotationHover createProjectionAnnotationHover() {
        ProjectionAnnotationHover projectionAnnotationHover = new ProjectionAnnotationHover();
        projectionAnnotationHover.setHoverControlCreator(this.fInformationControlCreator);
        projectionAnnotationHover.setInformationPresenterControlCreator(this.fInformationPresenterControlCreator);
        return projectionAnnotationHover;
    }

    public Object getAdapter(ISourceViewer iSourceViewer, Class clazz) {
        if (ProjectionAnnotationModel.class.equals((Object)clazz) && iSourceViewer instanceof ProjectionViewer) {
            ProjectionViewer projectionViewer = (ProjectionViewer)iSourceViewer;
            return projectionViewer.getProjectionAnnotationModel();
        }
        return null;
    }

    private RGB getColor() {
        Color color = Display.getDefault().getSystemColor(16);
        return color.getRGB();
    }

    private static class ProjectionAnnotationsPainter
    extends AnnotationPainter {
        public ProjectionAnnotationsPainter(ISourceViewer iSourceViewer, IAnnotationAccess iAnnotationAccess) {
            super(iSourceViewer, iAnnotationAccess);
        }

        @Override
        protected IAnnotationModel findAnnotationModel(ISourceViewer iSourceViewer) {
            if (iSourceViewer instanceof ProjectionViewer) {
                ProjectionViewer projectionViewer = (ProjectionViewer)iSourceViewer;
                return projectionViewer.getProjectionAnnotationModel();
            }
            return null;
        }

        @Override
        protected boolean skip(Annotation annotation) {
            if (annotation instanceof ProjectionAnnotation) {
                return !((ProjectionAnnotation)annotation).isCollapsed();
            }
            return super.skip(annotation);
        }
    }

    private static class ProjectionDrawingStrategy
    implements AnnotationPainter.IDrawingStrategy {
        private ProjectionDrawingStrategy() {
        }

        @Override
        public void draw(Annotation annotation, GC gC, StyledText styledText, int n, int n2, Color color) {
            ProjectionAnnotation projectionAnnotation;
            if (annotation instanceof ProjectionAnnotation && (projectionAnnotation = (ProjectionAnnotation)annotation).isCollapsed()) {
                if (gC != null) {
                    StyledTextContent styledTextContent = styledText.getContent();
                    int n3 = styledTextContent.getLineAtOffset(n);
                    int n4 = styledTextContent.getOffsetAtLine(n3);
                    String string = styledTextContent.getLine(n3);
                    int n5 = string == null ? 0 : string.length();
                    int n6 = n4 + n5;
                    Point point = styledText.getLocationAtOffset(n6);
                    Color color2 = gC.getForeground();
                    gC.setForeground(color);
                    FontMetrics fontMetrics = gC.getFontMetrics();
                    int n7 = styledText.getBaseline(n);
                    int n8 = Math.min(2, styledText.getLineHeight(n) - n7);
                    int n9 = fontMetrics.getAscent();
                    int n10 = n7 - n9;
                    int n11 = n9 + n8;
                    int n12 = fontMetrics.getAverageCharWidth();
                    gC.drawRectangle(point.x, point.y + n10, n12, n11);
                    int n13 = n12 / 3;
                    int n14 = point.y + n7 - 1;
                    gC.drawPoint(point.x + n13, n14);
                    gC.drawPoint(point.x + n12 - n13, n14);
                    gC.setForeground(color2);
                } else {
                    styledText.redrawRange(n, n2, true);
                }
            }
        }
    }

    private class ProjectionListener
    implements IProjectionListener {
        private ProjectionListener() {
        }

        @Override
        public void projectionEnabled() {
            ProjectionSupport.this.doEnableProjection();
        }

        @Override
        public void projectionDisabled() {
            ProjectionSupport.this.doDisableProjection();
        }
    }
}

