/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

class ProjectionSummary {
    private ProjectionViewer fProjectionViewer;
    private IAnnotationAccess fAnnotationAccess;
    private List fConfiguredAnnotationTypes;
    private Object fLock = new Object();
    private IProgressMonitor fProgressMonitor;
    private volatile Summarizer fSummarizer;

    public ProjectionSummary(ProjectionViewer projectionViewer, IAnnotationAccess iAnnotationAccess) {
        this.fProjectionViewer = projectionViewer;
        this.fAnnotationAccess = iAnnotationAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationType(String string) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fConfiguredAnnotationTypes == null) {
                this.fConfiguredAnnotationTypes = new ArrayList();
                this.fConfiguredAnnotationTypes.add(string);
            } else if (!this.fConfiguredAnnotationTypes.contains(string)) {
                this.fConfiguredAnnotationTypes.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotationType(String string) {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fConfiguredAnnotationTypes != null) {
                this.fConfiguredAnnotationTypes.remove(string);
                if (this.fConfiguredAnnotationTypes.size() == 0) {
                    this.fConfiguredAnnotationTypes = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSummaries() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fConfiguredAnnotationTypes != null) {
                if (this.fSummarizer == null) {
                    this.fSummarizer = new Summarizer();
                }
                this.fSummarizer.reset();
            }
        }
    }

    private void internalUpdateSummaries(IProgressMonitor iProgressMonitor) {
        IAnnotationModel iAnnotationModel = this.fProjectionViewer.getVisualAnnotationModel();
        if (iAnnotationModel == null) {
            return;
        }
        this.removeSummaries(iProgressMonitor, iAnnotationModel);
        if (this.isCanceled(iProgressMonitor)) {
            return;
        }
        this.createSummaries(iProgressMonitor, iAnnotationModel);
    }

    private boolean isCanceled(IProgressMonitor iProgressMonitor) {
        return iProgressMonitor != null && iProgressMonitor.isCanceled();
    }

    private void removeSummaries(IProgressMonitor iProgressMonitor, IAnnotationModel iAnnotationModel) {
        Annotation[] annotationArray;
        IAnnotationModelExtension iAnnotationModelExtension = null;
        ArrayList<Annotation[]> arrayList = null;
        if (iAnnotationModel instanceof IAnnotationModelExtension) {
            iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
            arrayList = new ArrayList<Annotation[]>();
        }
        Iterator iterator = iAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            annotationArray = (Annotation[])iterator.next();
            if (annotationArray instanceof AnnotationBag) {
                if (arrayList == null) {
                    iAnnotationModel.removeAnnotation((Annotation)annotationArray);
                } else {
                    arrayList.add(annotationArray);
                }
            }
            if (!this.isCanceled(iProgressMonitor)) continue;
            return;
        }
        if (arrayList != null && arrayList.size() > 0) {
            annotationArray = new Annotation[arrayList.size()];
            arrayList.toArray(annotationArray);
            if (!this.isCanceled(iProgressMonitor)) {
                iAnnotationModelExtension.replaceAnnotations(annotationArray, null);
            }
        }
    }

    private void createSummaries(IProgressMonitor iProgressMonitor, IAnnotationModel iAnnotationModel) {
        Position position;
        Object object;
        ProjectionAnnotationModel projectionAnnotationModel = this.fProjectionViewer.getProjectionAnnotationModel();
        if (projectionAnnotationModel == null) {
            return;
        }
        HashMap hashMap = new HashMap();
        Iterator iterator = projectionAnnotationModel.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position2;
            Object object2;
            object = (ProjectionAnnotation)iterator.next();
            if (((ProjectionAnnotation)object).isCollapsed() && (object2 = projectionAnnotationModel.getPosition((Annotation)object)) != null && (position = this.fProjectionViewer.computeCollapsedRegions((Position)object2)) != null && (position2 = this.fProjectionViewer.computeCollapsedRegionAnchor((Position)object2)) != null) {
                this.createSummary(hashMap, (IRegion[])position, position2);
            }
            if (!this.isCanceled(iProgressMonitor)) continue;
            return;
        }
        if (hashMap.size() > 0) {
            if (iAnnotationModel instanceof IAnnotationModelExtension) {
                object = (IAnnotationModelExtension)iAnnotationModel;
                if (!this.isCanceled(iProgressMonitor)) {
                    object.replaceAnnotations(null, hashMap);
                }
            } else {
                for (Object object2 : hashMap.keySet()) {
                    position = (Position)hashMap.get(object2);
                    if (this.isCanceled(iProgressMonitor)) {
                        return;
                    }
                    iAnnotationModel.addAnnotation((Annotation)object2, position);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSummary(Map map, IRegion[] iRegionArray, Position position) {
        AnnotationBag annotationBag;
        String string;
        int n = 0;
        HashMap<String, AnnotationBag> hashMap = null;
        Object object = this.fLock;
        synchronized (object) {
            if (this.fConfiguredAnnotationTypes != null) {
                n = this.fConfiguredAnnotationTypes.size();
                hashMap = new HashMap<String, AnnotationBag>();
                int n2 = 0;
                while (n2 < n) {
                    string = (String)this.fConfiguredAnnotationTypes.get(n2);
                    hashMap.put(string, new AnnotationBag(string));
                    ++n2;
                }
            }
        }
        if (hashMap == null) {
            return;
        }
        object = this.fProjectionViewer.getAnnotationModel();
        if (object == null) {
            return;
        }
        Iterator iterator = object.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position2;
            string = (Annotation)iterator.next();
            annotationBag = this.findBagForType(hashMap, string.getType());
            if (annotationBag == null || !this.includes(iRegionArray, position2 = object.getPosition((Annotation)string))) continue;
            annotationBag.add((Annotation)string);
        }
        int n3 = 0;
        while (n3 < n) {
            annotationBag = (AnnotationBag)((Object)hashMap.get(this.fConfiguredAnnotationTypes.get(n3)));
            if (!annotationBag.isEmpty()) {
                map.put(annotationBag, new Position(position.getOffset(), position.getLength()));
            }
            ++n3;
        }
    }

    private AnnotationBag findBagForType(Map map, String string) {
        AnnotationBag annotationBag = (AnnotationBag)((Object)map.get(string));
        if (annotationBag == null && this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension iAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
            Object[] objectArray = iAnnotationAccessExtension.getSupertypes(string);
            int n = 0;
            while (n < objectArray.length && annotationBag == null) {
                annotationBag = (AnnotationBag)((Object)map.get(objectArray[n]));
                ++n;
            }
        }
        return annotationBag;
    }

    private boolean includes(IRegion[] iRegionArray, Position position) {
        int n = 0;
        while (n < iRegionArray.length) {
            IRegion iRegion = iRegionArray[n];
            if (position != null && !position.isDeleted() && iRegion.getOffset() <= position.getOffset() && position.getOffset() + position.getLength() <= iRegion.getOffset() + iRegion.getLength()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private class Summarizer
    extends Thread {
        private boolean fReset = true;

        public Summarizer() {
            ProjectionSummary.this.fProgressMonitor = (IProgressMonitor)new NullProgressMonitor();
            this.setDaemon(true);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = ProjectionSummary.this.fLock;
            synchronized (object) {
                this.fReset = true;
                ProjectionSummary.this.fProgressMonitor.setCanceled(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            while (true) {
                object = ProjectionSummary.this.fLock;
                synchronized (object) {
                    if (!this.fReset) {
                        break;
                    }
                    this.fReset = false;
                    ProjectionSummary.this.fProgressMonitor.setCanceled(false);
                }
                ProjectionSummary.this.internalUpdateSummaries(ProjectionSummary.this.fProgressMonitor);
            }
            object = ProjectionSummary.this.fLock;
            synchronized (object) {
                ProjectionSummary.this.fSummarizer = null;
            }
        }
    }
}

