/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class ProjectionRulerColumn
extends AnnotationRulerColumn {
    private ProjectionAnnotation fCurrentAnnotation;
    private int fMouseDownLine;

    public ProjectionRulerColumn(IAnnotationModel iAnnotationModel, int n, IAnnotationAccess iAnnotationAccess) {
        super(iAnnotationModel, n, iAnnotationAccess);
    }

    public ProjectionRulerColumn(int n, IAnnotationAccess iAnnotationAccess) {
        super(n, iAnnotationAccess);
    }

    @Override
    protected void mouseClicked(int n) {
        this.clearCurrentAnnotation();
        if (this.fMouseDownLine != n) {
            return;
        }
        ProjectionAnnotation projectionAnnotation = this.findAnnotation(n, true);
        if (projectionAnnotation != null) {
            ProjectionAnnotationModel projectionAnnotationModel = (ProjectionAnnotationModel)this.getModel();
            projectionAnnotationModel.toggleExpansionState(projectionAnnotation);
        }
    }

    @Override
    protected void mouseDown(int n) {
        this.fMouseDownLine = n;
    }

    @Override
    protected void mouseDoubleClicked(int n) {
        if (this.findAnnotation(n, true) != null) {
            return;
        }
        ProjectionAnnotation projectionAnnotation = this.findAnnotation(n, false);
        if (projectionAnnotation != null) {
            ProjectionAnnotationModel projectionAnnotationModel = (ProjectionAnnotationModel)this.getModel();
            projectionAnnotationModel.toggleExpansionState(projectionAnnotation);
        }
    }

    private ProjectionAnnotation findAnnotation(int n, boolean bl) {
        ProjectionAnnotation projectionAnnotation = null;
        IAnnotationModel iAnnotationModel = this.getModel();
        if (iAnnotationModel != null) {
            IDocument iDocument = this.getCachedTextViewer().getDocument();
            int n2 = Integer.MAX_VALUE;
            Iterator iterator = iAnnotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                int n3;
                ProjectionAnnotation projectionAnnotation2;
                Position position;
                Object e = iterator.next();
                if (!(e instanceof ProjectionAnnotation) || (position = iAnnotationModel.getPosition((Annotation)(projectionAnnotation2 = (ProjectionAnnotation)e))) == null || (n3 = this.getDistance(projectionAnnotation2, position, iDocument, n)) == -1) continue;
                if (!bl) {
                    if (n3 >= n2) continue;
                    projectionAnnotation = projectionAnnotation2;
                    n2 = n3;
                    continue;
                }
                if (n3 != 0) continue;
                projectionAnnotation = projectionAnnotation2;
            }
        }
        return projectionAnnotation;
    }

    private int getDistance(ProjectionAnnotation projectionAnnotation, Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int n2 = iDocument.getLineOfOffset(position.getOffset());
                int n3 = iDocument.getLineOfOffset(position.getOffset() + position.getLength());
                if (n2 <= n && n < n3) {
                    if (projectionAnnotation.isCollapsed()) {
                        int n4 = position instanceof IProjectionPosition ? ((IProjectionPosition)position).computeCaptionOffset(iDocument) : 0;
                        int n5 = iDocument.getLineOfOffset(position.getOffset() + n4);
                        if (n2 <= n5 && n5 < n3) {
                            return Math.abs(n - n5);
                        }
                    }
                    return n - n2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    private boolean clearCurrentAnnotation() {
        if (this.fCurrentAnnotation != null) {
            this.fCurrentAnnotation.setRangeIndication(false);
            this.fCurrentAnnotation = null;
            return true;
        }
        return false;
    }

    @Override
    public Control createControl(CompositeRuler compositeRuler, Composite composite) {
        Control control = super.createControl(compositeRuler, composite);
        Color color = this.getCachedTextViewer().getTextWidget().getBackground();
        control.setBackground(color);
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent mouseEvent) {
                if (ProjectionRulerColumn.this.clearCurrentAnnotation()) {
                    ProjectionRulerColumn.this.redraw();
                }
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                boolean bl = false;
                ProjectionAnnotation projectionAnnotation = ProjectionRulerColumn.this.findAnnotation(ProjectionRulerColumn.this.toDocumentLineNumber(mouseEvent.y), false);
                if (projectionAnnotation != ProjectionRulerColumn.this.fCurrentAnnotation) {
                    if (ProjectionRulerColumn.this.fCurrentAnnotation != null) {
                        ProjectionRulerColumn.this.fCurrentAnnotation.setRangeIndication(false);
                        bl = true;
                    }
                    ProjectionRulerColumn.this.fCurrentAnnotation = projectionAnnotation;
                    if (ProjectionRulerColumn.this.fCurrentAnnotation != null && !ProjectionRulerColumn.this.fCurrentAnnotation.isCollapsed()) {
                        ProjectionRulerColumn.this.fCurrentAnnotation.setRangeIndication(true);
                        bl = true;
                    }
                }
                if (bl) {
                    ProjectionRulerColumn.this.redraw();
                }
            }
        });
        return control;
    }

    @Override
    public void setModel(IAnnotationModel iAnnotationModel) {
        if (iAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)iAnnotationModel;
            iAnnotationModel = iAnnotationModelExtension.getAnnotationModel(ProjectionSupport.PROJECTION);
        }
        super.setModel(iAnnotationModel);
    }

    @Override
    protected boolean isPropagatingMouseListener() {
        return false;
    }

    @Override
    protected boolean hasAnnotation(int n) {
        return this.findAnnotation(n, true) != null;
    }
}

