/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;

public class ProjectionAnnotationModel
extends AnnotationModel {
    public void collapse(Annotation annotation) {
        ProjectionAnnotation projectionAnnotation;
        if (annotation instanceof ProjectionAnnotation && !(projectionAnnotation = (ProjectionAnnotation)annotation).isCollapsed()) {
            projectionAnnotation.markCollapsed();
            this.modifyAnnotation(projectionAnnotation, true);
        }
    }

    public void expand(Annotation annotation) {
        ProjectionAnnotation projectionAnnotation;
        if (annotation instanceof ProjectionAnnotation && (projectionAnnotation = (ProjectionAnnotation)annotation).isCollapsed()) {
            projectionAnnotation.markExpanded();
            this.modifyAnnotation(projectionAnnotation, true);
        }
    }

    public void toggleExpansionState(Annotation annotation) {
        if (annotation instanceof ProjectionAnnotation) {
            ProjectionAnnotation projectionAnnotation = (ProjectionAnnotation)annotation;
            if (projectionAnnotation.isCollapsed()) {
                projectionAnnotation.markExpanded();
            } else {
                projectionAnnotation.markCollapsed();
            }
            this.modifyAnnotation(projectionAnnotation, true);
        }
    }

    public boolean expandAll(int n, int n2) {
        return this.expandAll(n, n2, true);
    }

    public boolean collapseAll(int n, int n2) {
        boolean bl = false;
        Iterator iterator = this.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            ProjectionAnnotation projectionAnnotation = (ProjectionAnnotation)iterator.next();
            if (projectionAnnotation.isCollapsed() || (position = this.getPosition(projectionAnnotation)) == null || !position.overlapsWith(n, n2)) continue;
            projectionAnnotation.markCollapsed();
            this.modifyAnnotation(projectionAnnotation, false);
            bl = true;
        }
        if (bl) {
            this.fireModelChanged();
        }
        return bl;
    }

    protected boolean expandAll(int n, int n2, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = this.getAnnotationIterator();
        while (iterator.hasNext()) {
            Position position;
            ProjectionAnnotation projectionAnnotation = (ProjectionAnnotation)iterator.next();
            if (!projectionAnnotation.isCollapsed() || (position = this.getPosition(projectionAnnotation)) == null || !position.overlapsWith(n, n2)) continue;
            projectionAnnotation.markExpanded();
            this.modifyAnnotation(projectionAnnotation, false);
            bl2 = true;
        }
        if (bl2 && bl) {
            this.fireModelChanged();
        }
        return bl2;
    }

    public void modifyAnnotations(Annotation[] annotationArray, Map map, Annotation[] annotationArray2) {
        try {
            this.replaceAnnotations(annotationArray, map, false);
            if (annotationArray2 != null) {
                int n = 0;
                while (n < annotationArray2.length) {
                    this.modifyAnnotation(annotationArray2[n], false);
                    ++n;
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        this.fireModelChanged();
    }
}

