/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.projection.IProjectionPosition;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.SourceViewerInformationControl;
import org.eclipse.swt.widgets.Shell;

class ProjectionAnnotationHover
implements IAnnotationHover,
IAnnotationHoverExtension,
IInformationProviderExtension2 {
    private IInformationControlCreator fInformationControlCreator;
    private IInformationControlCreator fInformationPresenterControlCreator;

    ProjectionAnnotationHover() {
    }

    public void setHoverControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fInformationControlCreator = iInformationControlCreator;
    }

    public void setInformationPresenterControlCreator(IInformationControlCreator iInformationControlCreator) {
        this.fInformationPresenterControlCreator = iInformationControlCreator;
    }

    @Override
    public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
        return null;
    }

    private boolean isCaptionLine(Position position, IDocument iDocument, int n) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                int n2 = position instanceof IProjectionPosition ? ((IProjectionPosition)position).computeCaptionOffset(iDocument) : 0;
                int n3 = iDocument.getLineOfOffset(position.getOffset() + n2);
                return n == n3;
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    private String getProjectionTextAtLine(ISourceViewer iSourceViewer, int n, int n2) {
        Object object;
        ISourceViewerExtension2 iSourceViewerExtension2;
        Object object2;
        IAnnotationModel iAnnotationModel = null;
        if (iSourceViewer instanceof ISourceViewerExtension2 && (object2 = (iSourceViewerExtension2 = (ISourceViewerExtension2)((Object)iSourceViewer)).getVisualAnnotationModel()) instanceof IAnnotationModelExtension) {
            object = (IAnnotationModelExtension)object2;
            iAnnotationModel = object.getAnnotationModel(ProjectionSupport.PROJECTION);
        }
        if (iAnnotationModel != null) {
            try {
                iSourceViewerExtension2 = iSourceViewer.getDocument();
                object2 = iAnnotationModel.getAnnotationIterator();
                while (object2.hasNext()) {
                    Position position;
                    object = (ProjectionAnnotation)object2.next();
                    if (!((ProjectionAnnotation)object).isCollapsed() || (position = iAnnotationModel.getPosition((Annotation)object)) == null || !this.isCaptionLine(position, (IDocument)iSourceViewerExtension2, n)) continue;
                    return this.getText((IDocument)iSourceViewerExtension2, position.getOffset(), position.getLength(), n2);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return null;
    }

    private String getText(IDocument iDocument, int n, int n2, int n3) throws BadLocationException {
        int n4 = n + n2;
        try {
            int n5 = iDocument.getLineOfOffset(n) + Math.max(0, n3 - 1);
            IRegion iRegion = iDocument.getLineInformation(n5);
            n4 = Math.min(n4, iRegion.getOffset() + iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {}
        return iDocument.get(n, n4 - n);
    }

    @Override
    public Object getHoverInfo(ISourceViewer iSourceViewer, ILineRange iLineRange, int n) {
        return this.getProjectionTextAtLine(iSourceViewer, iLineRange.getStartLine(), n);
    }

    @Override
    public ILineRange getHoverLineRange(ISourceViewer iSourceViewer, int n) {
        return new LineRange(n, 1);
    }

    @Override
    public boolean canHandleMouseCursor() {
        return false;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.fInformationControlCreator == null) {
            this.fInformationControlCreator = new IInformationControlCreator(){

                @Override
                public IInformationControl createInformationControl(Shell shell) {
                    return new SourceViewerInformationControl(shell, false, "org.eclipse.jface.textfont", null);
                }
            };
        }
        return this.fInformationControlCreator;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fInformationPresenterControlCreator == null) {
            this.fInformationPresenterControlCreator = new IInformationControlCreator(){

                @Override
                public IInformationControl createInformationControl(Shell shell) {
                    return new SourceViewerInformationControl(shell, true, "org.eclipse.jface.textfont", null);
                }
            };
        }
        return this.fInformationPresenterControlCreator;
    }
}

