/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.projection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;

public class ProjectionAnnotation
extends Annotation
implements IAnnotationPresentation {
    public static final String TYPE = "org.eclipse.projection";
    private static final int COLOR = 15;
    private static Image fgCollapsedImage;
    private static Image fgExpandedImage;
    private boolean fIsCollapsed = false;
    private boolean fIsRangeIndication = false;

    public ProjectionAnnotation() {
        this(false);
    }

    public ProjectionAnnotation(boolean bl) {
        super(TYPE, false, null);
        this.fIsCollapsed = bl;
    }

    public void setRangeIndication(boolean bl) {
        this.fIsRangeIndication = bl;
    }

    private void drawRangeIndication(GC gC, Canvas canvas, Rectangle rectangle) {
        int n = Math.min(rectangle.y + rectangle.height - 3, canvas.getSize().y);
        gC.setForeground(canvas.getDisplay().getSystemColor(15));
        gC.setLineWidth(0);
        gC.drawLine(rectangle.x + 4, rectangle.y + 12, rectangle.x + 4, n);
        gC.drawLine(rectangle.x + 4, n, rectangle.x + rectangle.width - 3, n);
    }

    @Override
    public void paint(GC gC, Canvas canvas, Rectangle rectangle) {
        Image image = this.getImage(canvas.getDisplay());
        if (image != null) {
            ImageUtilities.drawImage(image, gC, canvas, rectangle, 0x1000000, 128);
            if (this.fIsRangeIndication) {
                FontMetrics fontMetrics = gC.getFontMetrics();
                int n = (fontMetrics.getHeight() - image.getBounds().height) / 2;
                rectangle.y += n;
                rectangle.height -= n;
                this.drawRangeIndication(gC, canvas, rectangle);
            }
        }
    }

    @Override
    public int getLayer() {
        return 0;
    }

    private Image getImage(Display display) {
        this.initializeImages(display);
        return this.isCollapsed() ? fgCollapsedImage : fgExpandedImage;
    }

    private void initializeImages(Display display) {
        if (fgCollapsedImage == null) {
            ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile(ProjectionAnnotation.class, (String)"images/collapsed.png");
            fgCollapsedImage = imageDescriptor.createImage((Device)display);
            imageDescriptor = ImageDescriptor.createFromFile(ProjectionAnnotation.class, (String)"images/expanded.png");
            fgExpandedImage = imageDescriptor.createImage((Device)display);
            display.disposeExec((Runnable)new DisplayDisposeRunnable());
        }
    }

    public boolean isCollapsed() {
        return this.fIsCollapsed;
    }

    public void markCollapsed() {
        this.fIsCollapsed = true;
    }

    public void markExpanded() {
        this.fIsCollapsed = false;
    }

    private static class DisplayDisposeRunnable
    implements Runnable {
        private DisplayDisposeRunnable() {
        }

        @Override
        public void run() {
            if (fgCollapsedImage != null) {
                fgCollapsedImage.dispose();
                fgCollapsedImage = null;
            }
            if (fgExpandedImage != null) {
                fgExpandedImage.dispose();
                fgExpandedImage = null;
            }
        }
    }
}

