/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class VerticalRuler
implements IVerticalRuler,
IVerticalRulerExtension {
    private static final boolean IS_MAC = Util.isMac();
    private ITextViewer fTextViewer;
    private Canvas fCanvas;
    private IAnnotationModel fModel;
    private int fScrollPos;
    private Image fBuffer;
    private int fLastMouseButtonActivityLine = -1;
    private InternalListener fInternalListener = new InternalListener();
    private int fWidth;
    private IAnnotationAccess fAnnotationAccess;

    public VerticalRuler(int n) {
        this(n, null);
    }

    public VerticalRuler(int n, IAnnotationAccess iAnnotationAccess) {
        this.fWidth = n;
        this.fAnnotationAccess = iAnnotationAccess;
    }

    @Override
    public Control getControl() {
        return this.fCanvas;
    }

    @Override
    public Control createControl(Composite composite, ITextViewer iTextViewer) {
        this.fTextViewer = iTextViewer;
        this.fCanvas = new Canvas(composite, 262144);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (VerticalRuler.this.fTextViewer != null) {
                    VerticalRuler.this.doubleBufferPaint(paintEvent.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                VerticalRuler.this.handleDispose();
                VerticalRuler.this.fTextViewer = null;
            }
        });
        this.fCanvas.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent mouseEvent) {
            }

            public void mouseDown(MouseEvent mouseEvent) {
                VerticalRuler.this.fLastMouseButtonActivityLine = VerticalRuler.this.toDocumentLineNumber(mouseEvent.y);
            }

            public void mouseDoubleClick(MouseEvent mouseEvent) {
                VerticalRuler.this.fLastMouseButtonActivityLine = VerticalRuler.this.toDocumentLineNumber(mouseEvent.y);
            }
        });
        if (this.fTextViewer != null) {
            this.fTextViewer.addViewportListener(this.fInternalListener);
            this.fTextViewer.addTextListener(this.fInternalListener);
        }
        return this.fCanvas;
    }

    private void handleDispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeViewportListener(this.fInternalListener);
            this.fTextViewer.removeTextListener(this.fInternalListener);
            this.fTextViewer = null;
        }
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    private void doubleBufferPaint(GC gC) {
        Rectangle rectangle;
        Point point = this.fCanvas.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            rectangle = this.fBuffer.getBounds();
            if (rectangle.width != point.x || rectangle.height != point.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), point.x, point.y);
        }
        rectangle = new GC((Drawable)this.fBuffer);
        rectangle.setFont(this.fTextViewer.getTextWidget().getFont());
        try {
            rectangle.setBackground(this.fCanvas.getBackground());
            rectangle.fillRectangle(0, 0, point.x, point.y);
            if (this.fTextViewer instanceof ITextViewerExtension5) {
                this.doPaint1((GC)rectangle);
            } else {
                this.doPaint((GC)rectangle);
            }
        }
        finally {
            rectangle.dispose();
        }
        gC.drawImage(this.fBuffer, 0, 0);
    }

    private int getInclusiveTopIndexStartOffset() {
        StyledText styledText = this.fTextViewer.getTextWidget();
        if (styledText != null && !styledText.isDisposed()) {
            int n = JFaceTextUtil.getPartialTopIndex(this.fTextViewer);
            try {
                IDocument iDocument = this.fTextViewer.getDocument();
                return iDocument.getLineOffset(n);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    protected void doPaint(GC gC) {
        IRegion iRegion;
        if (this.fModel == null || this.fTextViewer == null) {
            return;
        }
        IAnnotationAccessExtension iAnnotationAccessExtension = null;
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            iAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
        }
        StyledText styledText = this.fTextViewer.getTextWidget();
        IDocument iDocument = this.fTextViewer.getDocument();
        int n = this.getInclusiveTopIndexStartOffset();
        int n2 = this.fTextViewer.getBottomIndexEndOffset();
        int n3 = n2 - n;
        Point point = this.fCanvas.getSize();
        this.fScrollPos = styledText.getTopPixel();
        int n4 = -1;
        int n5 = -1;
        try {
            iRegion = this.fTextViewer.getVisibleRegion();
            n4 = iDocument.getLineOfOffset(iRegion.getOffset());
            n5 = iDocument.getLineOfOffset(iRegion.getOffset() + iRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        iRegion = new Rectangle(0, 0, 0, 0);
        int n6 = 1;
        int n7 = 0;
        while (n7 < n6) {
            Iterator iterator = this.fModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Position position;
                IAnnotationPresentation iAnnotationPresentation = null;
                Annotation annotation = (Annotation)iterator.next();
                int n8 = 0;
                if (iAnnotationAccessExtension != null) {
                    n8 = iAnnotationAccessExtension.getLayer(annotation);
                } else if (annotation instanceof IAnnotationPresentation) {
                    iAnnotationPresentation = (IAnnotationPresentation)annotation;
                    n8 = iAnnotationPresentation.getLayer();
                }
                n6 = Math.max(n6, n8 + 1);
                if (n8 != n7 || (position = this.fModel.getPosition(annotation)) == null || !position.overlapsWith(n, n3)) continue;
                try {
                    int n9 = position.getOffset();
                    int n10 = position.getLength();
                    int n11 = iDocument.getLineOfOffset(n9);
                    if (n11 < n4) {
                        n11 = n4;
                    }
                    int n12 = n11;
                    if (n10 > 0) {
                        n12 = iDocument.getLineOfOffset(n9 + n10 - 1);
                    }
                    if (n12 > n5) {
                        n12 = n5;
                    }
                    iRegion.x = 0;
                    iRegion.y = JFaceTextUtil.computeLineHeight(styledText, 0, n11 -= n4, n11) - this.fScrollPos;
                    iRegion.width = point.x;
                    int n13 = (n12 -= n4) - n11;
                    iRegion.height = JFaceTextUtil.computeLineHeight(styledText, n11, n12 + 1, n13 + 1);
                    if (iRegion.y < point.y && iAnnotationAccessExtension != null) {
                        iAnnotationAccessExtension.paint(annotation, gC, this.fCanvas, (Rectangle)iRegion);
                        continue;
                    }
                    if (iAnnotationPresentation == null) continue;
                    iAnnotationPresentation.paint(gC, this.fCanvas, (Rectangle)iRegion);
                }
                catch (BadLocationException badLocationException) {}
            }
            ++n7;
        }
    }

    protected void doPaint1(GC gC) {
        if (this.fModel == null || this.fTextViewer == null) {
            return;
        }
        IAnnotationAccessExtension iAnnotationAccessExtension = null;
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            iAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
        }
        ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fTextViewer);
        StyledText styledText = this.fTextViewer.getTextWidget();
        this.fScrollPos = styledText.getTopPixel();
        Point point = this.fCanvas.getSize();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        int n = 1;
        int n2 = 0;
        while (n2 < n) {
            Iterator iterator = this.fModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                int n3;
                int n4;
                IRegion iRegion;
                Position position;
                IAnnotationPresentation iAnnotationPresentation = null;
                Annotation annotation = (Annotation)iterator.next();
                int n5 = 0;
                if (iAnnotationAccessExtension != null) {
                    n5 = iAnnotationAccessExtension.getLayer(annotation);
                } else if (annotation instanceof IAnnotationPresentation) {
                    iAnnotationPresentation = (IAnnotationPresentation)annotation;
                    n5 = iAnnotationPresentation.getLayer();
                }
                n = Math.max(n, n5 + 1);
                if (n5 != n2 || (position = this.fModel.getPosition(annotation)) == null || (iRegion = iTextViewerExtension5.modelRange2WidgetRange((IRegion)new Region(position.getOffset(), position.getLength()))) == null || (n4 = iTextViewerExtension5.widgetLineOfWidgetOffset(iRegion.getOffset())) == -1 || (n3 = iTextViewerExtension5.widgetLineOfWidgetOffset(iRegion.getOffset() + Math.max(iRegion.getLength() - 1, 0))) == -1) continue;
                rectangle.x = 0;
                rectangle.y = JFaceTextUtil.computeLineHeight(styledText, 0, n4, n4) - this.fScrollPos;
                rectangle.width = point.x;
                int n6 = n3 - n4;
                rectangle.height = JFaceTextUtil.computeLineHeight(styledText, n4, n3 + 1, n6 + 1);
                if (rectangle.y < point.y && iAnnotationAccessExtension != null) {
                    iAnnotationAccessExtension.paint(annotation, gC, this.fCanvas, rectangle);
                    continue;
                }
                if (iAnnotationPresentation == null) continue;
                iAnnotationPresentation.paint(gC, this.fCanvas, rectangle);
            }
            ++n2;
        }
    }

    @Override
    public void update() {
        Display display;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (display = this.fCanvas.getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    VerticalRuler.this.redraw();
                }
            });
        }
    }

    private void redraw() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            if (IS_MAC) {
                this.fCanvas.redraw();
                this.fCanvas.update();
            } else {
                GC gC = new GC((Drawable)this.fCanvas);
                this.doubleBufferPaint(gC);
                gC.dispose();
            }
        }
    }

    @Override
    public void setModel(IAnnotationModel iAnnotationModel) {
        if (iAnnotationModel != this.fModel) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.fModel = iAnnotationModel;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.update();
        }
    }

    @Override
    public IAnnotationModel getModel() {
        return this.fModel;
    }

    @Override
    public int getWidth() {
        return this.fWidth;
    }

    @Override
    public int getLineOfLastMouseButtonActivity() {
        IDocument iDocument = this.fTextViewer.getDocument();
        if (iDocument == null || this.fLastMouseButtonActivityLine >= this.fTextViewer.getDocument().getNumberOfLines()) {
            this.fLastMouseButtonActivityLine = -1;
        }
        return this.fLastMouseButtonActivityLine;
    }

    @Override
    public int toDocumentLineNumber(int n) {
        if (this.fTextViewer == null || n == -1) {
            return -1;
        }
        StyledText styledText = this.fTextViewer.getTextWidget();
        int n2 = styledText.getLineIndex(n);
        if (n2 == styledText.getLineCount() - 1 && n > styledText.getLinePixel(n2 + 1)) {
            return -1;
        }
        return VerticalRuler.widgetLine2ModelLine(this.fTextViewer, n2);
    }

    protected static final int widgetLine2ModelLine(ITextViewer iTextViewer, int n) {
        if (iTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)iTextViewer);
            return iTextViewerExtension5.widgetLine2ModelLine(n);
        }
        try {
            IRegion iRegion = iTextViewer.getVisibleRegion();
            IDocument iDocument = iTextViewer.getDocument();
            return n += iDocument.getLineOfOffset(iRegion.getOffset());
        }
        catch (BadLocationException badLocationException) {
            return n;
        }
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void setLocationOfLastMouseButtonActivity(int n, int n2) {
        this.fLastMouseButtonActivityLine = this.toDocumentLineNumber(n2);
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.addMouseListener(mouseListener);
        }
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.removeMouseListener(mouseListener);
        }
    }

    class InternalListener
    implements IViewportListener,
    IAnnotationModelListener,
    ITextListener {
        InternalListener() {
        }

        @Override
        public void viewportChanged(int n) {
            if (n != VerticalRuler.this.fScrollPos) {
                VerticalRuler.this.redraw();
            }
        }

        public void modelChanged(IAnnotationModel iAnnotationModel) {
            VerticalRuler.this.update();
        }

        @Override
        public void textChanged(TextEvent textEvent) {
            if (VerticalRuler.this.fTextViewer != null && textEvent.getViewerRedrawState()) {
                VerticalRuler.this.redraw();
            }
        }
    }
}

