/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.jface.internal.text.NonDeletingPositionUpdater;
import org.eclipse.jface.internal.text.StickyHoverManager;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IBlockTextSelection;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.ISlaveDocumentManagerExtension;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension8;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension4;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.projection.ChildDocument;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ContentAssistantFacade;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.ISourceViewerExtension3;
import org.eclipse.jface.text.source.ISourceViewerExtension4;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.OverviewRulerHoverManager;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;

public class SourceViewer
extends TextViewer
implements ISourceViewer,
ISourceViewerExtension,
ISourceViewerExtension2,
ISourceViewerExtension3,
ISourceViewerExtension4 {
    protected static final int GAP_SIZE = 2;
    protected static final int GAP_SIZE_1 = 1;
    protected static final String _SELECTION_POSITION_CATEGORY = "__selection_category";
    protected static final Object MODEL_ANNOTATION_MODEL = new Object();
    protected IContentAssistant fContentAssistant;
    private ContentAssistantFacade fContentAssistantFacade;
    protected boolean fContentAssistantInstalled;
    protected IQuickAssistAssistant fQuickAssistAssistant;
    protected boolean fQuickAssistAssistantInstalled;
    protected IContentFormatter fContentFormatter;
    protected IReconciler fReconciler;
    protected IPresentationReconciler fPresentationReconciler;
    protected IAnnotationHover fAnnotationHover;
    protected final Stack fSelections = new Stack();
    protected IPositionUpdater fSelectionUpdater = null;
    protected String fSelectionCategory;
    protected IAnnotationHover fOverviewRulerAnnotationHover;
    protected IInformationPresenter fInformationPresenter;
    private IVerticalRuler fVerticalRuler;
    private boolean fIsVerticalRulerVisible;
    private Composite fComposite;
    private IAnnotationModel fVisualAnnotationModel;
    private Annotation fRangeIndicator;
    private AnnotationBarHoverManager fVerticalRulerHoveringController;
    private AbstractHoverInformationControlManager fOverviewRulerHoveringController;
    private IOverviewRuler fOverviewRuler;
    private boolean fIsOverviewRulerVisible;

    public SourceViewer(Composite composite, IVerticalRuler iVerticalRuler, int n) {
        this(composite, iVerticalRuler, null, false, n);
    }

    public SourceViewer(Composite composite, IVerticalRuler iVerticalRuler, IOverviewRuler iOverviewRuler, boolean bl, int n) {
        this.fVerticalRuler = iVerticalRuler;
        this.fIsVerticalRulerVisible = iVerticalRuler != null;
        this.fOverviewRuler = iOverviewRuler;
        this.fIsOverviewRulerVisible = bl && iOverviewRuler != null;
        this.createControl(composite, n);
    }

    @Override
    protected void createControl(Composite composite, int n) {
        if (this.fVerticalRuler != null || this.fOverviewRuler != null) {
            n &= 0xFFFFF7FF;
            this.fComposite = new Canvas(composite, 0);
            this.fComposite.setLayout(this.createLayout());
            composite = this.fComposite;
        }
        super.createControl(composite, n);
        if (this.fVerticalRuler != null) {
            this.fVerticalRuler.createControl(this.fComposite, this);
        }
        if (this.fOverviewRuler != null) {
            this.fOverviewRuler.createControl(this.fComposite, this);
        }
    }

    protected Layout createLayout() {
        return new RulerLayout(1);
    }

    @Override
    public Control getControl() {
        if (this.fComposite != null) {
            return this.fComposite;
        }
        return super.getControl();
    }

    @Override
    public void setAnnotationHover(IAnnotationHover iAnnotationHover) {
        this.fAnnotationHover = iAnnotationHover;
    }

    public void setOverviewRulerAnnotationHover(IAnnotationHover iAnnotationHover) {
        this.fOverviewRulerAnnotationHover = iAnnotationHover;
    }

    @Override
    public void configure(SourceViewerConfiguration sourceViewerConfiguration) {
        if (this.getTextWidget() == null) {
            return;
        }
        this.setDocumentPartitioning(sourceViewerConfiguration.getConfiguredDocumentPartitioning(this));
        this.fPresentationReconciler = sourceViewerConfiguration.getPresentationReconciler(this);
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.install(this);
        }
        this.fReconciler = sourceViewerConfiguration.getReconciler(this);
        if (this.fReconciler != null) {
            this.fReconciler.install(this);
        }
        this.fContentAssistant = sourceViewerConfiguration.getContentAssistant(this);
        if (this.fContentAssistant != null) {
            this.fContentAssistant.install(this);
            if (this.fContentAssistant instanceof IContentAssistantExtension2 && this.fContentAssistant instanceof IContentAssistantExtension4) {
                this.fContentAssistantFacade = new ContentAssistantFacade(this.fContentAssistant);
            }
            this.fContentAssistantInstalled = true;
        }
        this.fQuickAssistAssistant = sourceViewerConfiguration.getQuickAssistAssistant(this);
        if (this.fQuickAssistAssistant != null) {
            this.fQuickAssistAssistant.install(this);
            this.fQuickAssistAssistantInstalled = true;
        }
        this.fContentFormatter = sourceViewerConfiguration.getContentFormatter(this);
        this.fInformationPresenter = sourceViewerConfiguration.getInformationPresenter(this);
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.install(this);
        }
        this.setUndoManager(sourceViewerConfiguration.getUndoManager(this));
        this.getTextWidget().setTabs(sourceViewerConfiguration.getTabWidth(this));
        this.setAnnotationHover(sourceViewerConfiguration.getAnnotationHover(this));
        this.setOverviewRulerAnnotationHover(sourceViewerConfiguration.getOverviewRulerAnnotationHover(this));
        this.setHoverControlCreator(sourceViewerConfiguration.getInformationControlCreator(this));
        this.setHyperlinkPresenter(sourceViewerConfiguration.getHyperlinkPresenter(this));
        IHyperlinkDetector[] iHyperlinkDetectorArray = sourceViewerConfiguration.getHyperlinkDetectors(this);
        int n = sourceViewerConfiguration.getHyperlinkStateMask(this);
        this.setHyperlinkDetectors(iHyperlinkDetectorArray, n);
        String[] stringArray = sourceViewerConfiguration.getConfiguredContentTypes(this);
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            this.setAutoEditStrategies(sourceViewerConfiguration.getAutoEditStrategies(this, string), string);
            this.setTextDoubleClickStrategy(sourceViewerConfiguration.getDoubleClickStrategy(this, string), string);
            int[] nArray = sourceViewerConfiguration.getConfiguredTextHoverStateMasks(this, string);
            if (nArray != null) {
                int n3 = 0;
                while (n3 < nArray.length) {
                    int n4 = nArray[n3];
                    this.setTextHover(sourceViewerConfiguration.getTextHover(this, string, n4), string, n4);
                    ++n3;
                }
            } else {
                this.setTextHover(sourceViewerConfiguration.getTextHover(this, string), string, 255);
            }
            String[] stringArray2 = sourceViewerConfiguration.getIndentPrefixes(this, string);
            if (stringArray2 != null && stringArray2.length > 0) {
                this.setIndentPrefixes(stringArray2, string);
            }
            if ((stringArray2 = sourceViewerConfiguration.getDefaultPrefixes(this, string)) != null && stringArray2.length > 0) {
                this.setDefaultPrefixes(stringArray2, string);
            }
            ++n2;
        }
        this.activatePlugins();
    }

    protected void ensureAnnotationHoverManagerInstalled() {
        if (!(this.fVerticalRuler == null || this.fAnnotationHover == null && this.isVerticalRulerOnlyShowingAnnotations() || this.fVerticalRulerHoveringController != null || this.fHoverControlCreator == null)) {
            this.fVerticalRulerHoveringController = new AnnotationBarHoverManager(this.fVerticalRuler, this, this.fAnnotationHover, this.fHoverControlCreator);
            this.fVerticalRulerHoveringController.install(this.fVerticalRuler.getControl());
            this.fVerticalRulerHoveringController.getInternalAccessor().setInformationControlReplacer(new StickyHoverManager(this));
        }
    }

    protected void ensureOverviewHoverManagerInstalled() {
        if (this.fOverviewRuler != null && this.fOverviewRulerAnnotationHover != null && this.fOverviewRulerHoveringController == null && this.fHoverControlCreator != null) {
            this.fOverviewRulerHoveringController = new OverviewRulerHoverManager(this.fOverviewRuler, (ISourceViewer)this, this.fOverviewRulerAnnotationHover, this.fHoverControlCreator);
            this.fOverviewRulerHoveringController.install(this.fOverviewRuler.getControl());
            this.fOverviewRulerHoveringController.getInternalAccessor().setInformationControlReplacer(new StickyHoverManager(this));
        }
    }

    @Override
    public void setHoverEnrichMode(ITextViewerExtension8.EnrichMode enrichMode) {
        super.setHoverEnrichMode(enrichMode);
        if (this.fVerticalRulerHoveringController != null) {
            this.fVerticalRulerHoveringController.getInternalAccessor().setHoverEnrichMode(enrichMode);
        }
        if (this.fOverviewRulerHoveringController != null) {
            this.fOverviewRulerHoveringController.getInternalAccessor().setHoverEnrichMode(enrichMode);
        }
    }

    @Override
    public void activatePlugins() {
        this.ensureAnnotationHoverManagerInstalled();
        this.ensureOverviewHoverManagerInstalled();
        super.activatePlugins();
    }

    @Override
    public void setDocument(IDocument iDocument) {
        this.setDocument(iDocument, null, -1, -1);
    }

    @Override
    public void setDocument(IDocument iDocument, int n, int n2) {
        this.setDocument(iDocument, null, n, n2);
    }

    @Override
    public void setDocument(IDocument iDocument, IAnnotationModel iAnnotationModel) {
        this.setDocument(iDocument, iAnnotationModel, -1, -1);
    }

    protected IAnnotationModel createVisualAnnotationModel(IAnnotationModel iAnnotationModel) {
        AnnotationModel annotationModel = new AnnotationModel();
        annotationModel.addAnnotationModel(MODEL_ANNOTATION_MODEL, iAnnotationModel);
        return (IAnnotationModel)annotationModel;
    }

    protected void disposeVisualAnnotationModel() {
        if (this.fVisualAnnotationModel != null) {
            if (this.getDocument() != null) {
                this.fVisualAnnotationModel.disconnect(this.getDocument());
            }
            if (this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fVisualAnnotationModel).removeAnnotationModel(MODEL_ANNOTATION_MODEL);
            }
            this.fVisualAnnotationModel = null;
        }
    }

    @Override
    public void setDocument(IDocument iDocument, IAnnotationModel iAnnotationModel, int n, int n2) {
        this.disposeVisualAnnotationModel();
        if (iAnnotationModel != null && iDocument != null) {
            this.fVisualAnnotationModel = this.createVisualAnnotationModel(iAnnotationModel);
            if (iAnnotationModel instanceof ISynchronizable && this.fVisualAnnotationModel instanceof ISynchronizable) {
                ISynchronizable iSynchronizable = (ISynchronizable)this.fVisualAnnotationModel;
                iSynchronizable.setLockObject(((ISynchronizable)iAnnotationModel).getLockObject());
            }
            this.fVisualAnnotationModel.connect(iDocument);
        }
        if (n == -1 && n2 == -1) {
            super.setDocument(iDocument);
        } else {
            super.setDocument(iDocument, n, n2);
        }
        if (this.fVerticalRuler != null) {
            this.fVerticalRuler.setModel(this.fVisualAnnotationModel);
        }
        if (this.fOverviewRuler != null) {
            this.fOverviewRuler.setModel(this.fVisualAnnotationModel);
        }
    }

    @Override
    public IAnnotationModel getAnnotationModel() {
        if (this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)this.fVisualAnnotationModel;
            return iAnnotationModelExtension.getAnnotationModel(MODEL_ANNOTATION_MODEL);
        }
        return null;
    }

    @Override
    public IQuickAssistAssistant getQuickAssistAssistant() {
        return this.fQuickAssistAssistant;
    }

    @Override
    public final ContentAssistantFacade getContentAssistantFacade() {
        return this.fContentAssistantFacade;
    }

    @Override
    public IQuickAssistInvocationContext getQuickAssistInvocationContext() {
        Point point = this.getSelectedRange();
        return new TextInvocationContext(this, point.x, point.y);
    }

    @Override
    public IAnnotationModel getVisualAnnotationModel() {
        return this.fVisualAnnotationModel;
    }

    @Override
    public void unconfigure() {
        this.clearRememberedSelection();
        if (this.fPresentationReconciler != null) {
            this.fPresentationReconciler.uninstall();
            this.fPresentationReconciler = null;
        }
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fContentAssistant != null) {
            this.fContentAssistant.uninstall();
            this.fContentAssistantInstalled = false;
            this.fContentAssistant = null;
            if (this.fContentAssistantFacade != null) {
                this.fContentAssistantFacade = null;
            }
        }
        if (this.fQuickAssistAssistant != null) {
            this.fQuickAssistAssistant.uninstall();
            this.fQuickAssistAssistantInstalled = false;
            this.fQuickAssistAssistant = null;
        }
        this.fContentFormatter = null;
        if (this.fInformationPresenter != null) {
            this.fInformationPresenter.uninstall();
            this.fInformationPresenter = null;
        }
        this.fAutoIndentStrategies = null;
        this.fDoubleClickStrategies = null;
        this.fTextHovers = null;
        this.fIndentChars = null;
        this.fDefaultPrefixChars = null;
        if (this.fVerticalRulerHoveringController != null) {
            this.fVerticalRulerHoveringController.dispose();
            this.fVerticalRulerHoveringController = null;
        }
        if (this.fOverviewRulerHoveringController != null) {
            this.fOverviewRulerHoveringController.dispose();
            this.fOverviewRulerHoveringController = null;
        }
        if (this.fUndoManager != null) {
            this.fUndoManager.disconnect();
            this.fUndoManager = null;
        }
        this.setHyperlinkDetectors(null, 0);
    }

    @Override
    protected void handleDispose() {
        this.unconfigure();
        this.disposeVisualAnnotationModel();
        this.fVerticalRuler = null;
        this.fOverviewRuler = null;
        this.fComposite = null;
        super.handleDispose();
    }

    @Override
    public boolean canDoOperation(int n) {
        if (this.getTextWidget() == null || !this.redraws() && n != 15) {
            return false;
        }
        if (n == 13) {
            return this.fContentAssistant != null && this.fContentAssistantInstalled && this.isEditable();
        }
        if (n == 14) {
            return this.fContentAssistant != null && this.fContentAssistantInstalled && this.isEditable();
        }
        if (n == 22) {
            return this.fQuickAssistAssistant != null && this.fQuickAssistAssistantInstalled && this.isEditable();
        }
        if (n == 16) {
            return this.fInformationPresenter != null;
        }
        if (n == 15) {
            return this.fContentFormatter != null && this.isEditable();
        }
        return super.canDoOperation(n);
    }

    protected IFormattingContext createFormattingContext() {
        return new FormattingContext();
    }

    protected Point rememberSelection() {
        ITextSelection iTextSelection = (ITextSelection)this.getSelection();
        IDocument iDocument = this.getDocument();
        if (this.fSelections.isEmpty()) {
            this.fSelectionCategory = _SELECTION_POSITION_CATEGORY + this.hashCode();
            this.fSelectionUpdater = new NonDeletingPositionUpdater(this.fSelectionCategory);
            iDocument.addPositionCategory(this.fSelectionCategory);
            iDocument.addPositionUpdater(this.fSelectionUpdater);
        }
        try {
            Position position = iTextSelection instanceof IBlockTextSelection ? new ColumnPosition(iTextSelection.getOffset(), iTextSelection.getLength(), ((IBlockTextSelection)iTextSelection).getStartColumn(), ((IBlockTextSelection)iTextSelection).getEndColumn()) : new Position(iTextSelection.getOffset(), iTextSelection.getLength());
            iDocument.addPosition(this.fSelectionCategory, position);
            this.fSelections.push(position);
        }
        catch (BadLocationException badLocationException) {
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
        return new Point(iTextSelection.getOffset(), iTextSelection.getLength());
    }

    protected void restoreSelection() {
        if (!this.fSelections.isEmpty()) {
            IDocument iDocument = this.getDocument();
            Position position = (Position)this.fSelections.pop();
            try {
                iDocument.removePosition(this.fSelectionCategory, position);
                Point point = this.getSelectedRange();
                if (point == null || point.x != position.getOffset() || point.y != position.getLength()) {
                    if (position instanceof ColumnPosition && this.getTextWidget().getBlockSelection()) {
                        this.setSelection(new BlockTextSelection(iDocument, iDocument.getLineOfOffset(position.getOffset()), ((ColumnPosition)position).fStartColumn, iDocument.getLineOfOffset(position.getOffset() + position.getLength()), ((ColumnPosition)position).fEndColumn, this.getTextWidget().getTabs()));
                    } else {
                        this.setSelectedRange(position.getOffset(), position.getLength());
                    }
                }
                if (this.fSelections.isEmpty()) {
                    this.clearRememberedSelection();
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected void clearRememberedSelection() {
        IDocument iDocument;
        if (!this.fSelections.isEmpty()) {
            this.fSelections.clear();
        }
        if ((iDocument = this.getDocument()) != null && this.fSelectionUpdater != null) {
            iDocument.removePositionUpdater(this.fSelectionUpdater);
            try {
                iDocument.removePositionCategory(this.fSelectionCategory);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        this.fSelectionUpdater = null;
        this.fSelectionCategory = null;
    }

    @Override
    public void doOperation(int n) {
        if (this.getTextWidget() == null || !this.redraws() && n != 15) {
            return;
        }
        switch (n) {
            case 13: {
                this.fContentAssistant.showPossibleCompletions();
                return;
            }
            case 14: {
                this.fContentAssistant.showContextInformation();
                return;
            }
            case 22: {
                this.fQuickAssistAssistant.showPossibleQuickAssists();
                return;
            }
            case 16: {
                this.fInformationPresenter.showInformation();
                return;
            }
            case 15: {
                Object object;
                Object object2;
                Point point = this.rememberSelection();
                IRewriteTarget iRewriteTarget = this.getRewriteTarget();
                IDocument iDocument = this.getDocument();
                IFormattingContext iFormattingContext = null;
                DocumentRewriteSession documentRewriteSession = null;
                if (iDocument instanceof IDocumentExtension4) {
                    object2 = (IDocumentExtension4)iDocument;
                    object = point.y == 0 && iDocument.getLength() > 1000 || point.y > 1000 ? DocumentRewriteSessionType.SEQUENTIAL : DocumentRewriteSessionType.UNRESTRICTED_SMALL;
                    documentRewriteSession = object2.startRewriteSession((DocumentRewriteSessionType)object);
                } else {
                    this.setRedraw(false);
                    iRewriteTarget.beginCompoundChange();
                }
                try {
                    object2 = iDocument.get();
                    try {
                        if (this.fContentFormatter instanceof IContentFormatterExtension) {
                            object = (IContentFormatterExtension)((Object)this.fContentFormatter);
                            iFormattingContext = this.createFormattingContext();
                            if (point.y == 0) {
                                iFormattingContext.setProperty("formatting.context.document", Boolean.TRUE);
                            } else {
                                iFormattingContext.setProperty("formatting.context.document", Boolean.FALSE);
                                iFormattingContext.setProperty("formatting.context.region", new Region(point.x, point.y));
                            }
                            object.format(iDocument, iFormattingContext);
                        } else {
                            IRegion iRegion;
                            object = point.y == 0 ? ((iRegion = this.getModelCoverage()) == null ? new Region(0, 0) : iRegion) : new Region(point.x, point.y);
                            this.fContentFormatter.format(iDocument, (IRegion)object);
                        }
                        this.updateSlaveDocuments(iDocument);
                    }
                    catch (RuntimeException runtimeException) {
                        iDocument.set((String)object2);
                        throw runtimeException;
                    }
                }
                finally {
                    if (iDocument instanceof IDocumentExtension4) {
                        IDocumentExtension4 iDocumentExtension4 = (IDocumentExtension4)iDocument;
                        iDocumentExtension4.stopRewriteSession(documentRewriteSession);
                    } else {
                        iRewriteTarget.endCompoundChange();
                        this.setRedraw(true);
                    }
                    this.restoreSelection();
                    if (iFormattingContext != null) {
                        iFormattingContext.dispose();
                    }
                }
                return;
            }
        }
        super.doOperation(n);
    }

    protected void updateSlaveDocuments(IDocument iDocument) {
        ISlaveDocumentManagerExtension iSlaveDocumentManagerExtension;
        IDocument[] iDocumentArray;
        ISlaveDocumentManager iSlaveDocumentManager = this.getSlaveDocumentManager();
        if (iSlaveDocumentManager instanceof ISlaveDocumentManagerExtension && (iDocumentArray = (iSlaveDocumentManagerExtension = (ISlaveDocumentManagerExtension)iSlaveDocumentManager).getSlaveDocuments(iDocument)) != null) {
            int n = 0;
            while (n < iDocumentArray.length) {
                if (iDocumentArray[n] instanceof ChildDocument) {
                    ChildDocument childDocument = (ChildDocument)iDocumentArray[n];
                    Position position = childDocument.getParentDocumentRange();
                    try {
                        if (!this.updateSlaveDocument((IDocument)childDocument, position.getOffset(), position.getLength())) {
                            childDocument.repairLineInformation();
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ++n;
            }
        }
    }

    @Override
    public void enableOperation(int n, boolean bl) {
        switch (n) {
            case 13: 
            case 14: {
                if (this.fContentAssistant == null) {
                    return;
                }
                if (bl) {
                    if (this.fContentAssistantInstalled) break;
                    this.fContentAssistant.install(this);
                    this.fContentAssistantInstalled = true;
                    break;
                }
                if (!this.fContentAssistantInstalled) break;
                this.fContentAssistant.uninstall();
                this.fContentAssistantInstalled = false;
                break;
            }
            case 22: {
                if (this.fQuickAssistAssistant == null) {
                    return;
                }
                if (bl) {
                    if (this.fQuickAssistAssistantInstalled) break;
                    this.fQuickAssistAssistant.install(this);
                    this.fQuickAssistAssistantInstalled = true;
                    break;
                }
                if (!this.fQuickAssistAssistantInstalled) break;
                this.fQuickAssistAssistant.uninstall();
                this.fQuickAssistAssistantInstalled = false;
            }
        }
    }

    @Override
    public void setRangeIndicator(Annotation annotation) {
        this.fRangeIndicator = annotation;
    }

    @Override
    public void setRangeIndication(int n, int n2, boolean bl) {
        if (bl) {
            this.setSelectedRange(n, 0);
            this.revealRange(n, n2);
        }
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension iAnnotationModelExtension = (IAnnotationModelExtension)this.fVisualAnnotationModel;
            iAnnotationModelExtension.modifyAnnotationPosition(this.fRangeIndicator, new Position(n, n2));
        }
    }

    @Override
    public IRegion getRangeIndication() {
        Position position;
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel != null && (position = this.fVisualAnnotationModel.getPosition(this.fRangeIndicator)) != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    @Override
    public void removeRangeIndication() {
        if (this.fRangeIndicator != null && this.fVisualAnnotationModel != null) {
            this.fVisualAnnotationModel.removeAnnotation(this.fRangeIndicator);
        }
    }

    @Override
    public void showAnnotations(boolean bl) {
        boolean bl2 = this.fIsVerticalRulerVisible;
        boolean bl3 = this.fIsVerticalRulerVisible = this.fVerticalRuler != null && (bl || !this.isVerticalRulerOnlyShowingAnnotations());
        if (bl2 != this.fIsVerticalRulerVisible && this.fComposite != null && !this.fComposite.isDisposed()) {
            this.fComposite.layout();
        }
        if (this.fIsVerticalRulerVisible && bl) {
            this.ensureAnnotationHoverManagerInstalled();
        } else if (this.fVerticalRulerHoveringController != null) {
            this.fVerticalRulerHoveringController.dispose();
            this.fVerticalRulerHoveringController = null;
        }
    }

    private boolean isVerticalRulerOnlyShowingAnnotations() {
        if (this.fVerticalRuler instanceof VerticalRuler) {
            return true;
        }
        if (this.fVerticalRuler instanceof CompositeRuler) {
            Iterator iterator = ((CompositeRuler)this.fVerticalRuler).getDecoratorIterator();
            return iterator.hasNext() && iterator.next() instanceof AnnotationRulerColumn && !iterator.hasNext();
        }
        return false;
    }

    protected final IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    public void addVerticalRulerColumn(IVerticalRulerColumn iVerticalRulerColumn) {
        IVerticalRuler iVerticalRuler = this.getVerticalRuler();
        if (iVerticalRuler instanceof CompositeRuler) {
            CompositeRuler compositeRuler = (CompositeRuler)iVerticalRuler;
            compositeRuler.addDecorator(99, iVerticalRulerColumn);
        }
    }

    public void removeVerticalRulerColumn(IVerticalRulerColumn iVerticalRulerColumn) {
        IVerticalRuler iVerticalRuler = this.getVerticalRuler();
        if (iVerticalRuler instanceof CompositeRuler) {
            CompositeRuler compositeRuler = (CompositeRuler)iVerticalRuler;
            compositeRuler.removeDecorator(iVerticalRulerColumn);
        }
    }

    @Override
    public void showAnnotationsOverview(boolean bl) {
        boolean bl2 = this.fIsOverviewRulerVisible;
        boolean bl3 = this.fIsOverviewRulerVisible = bl && this.fOverviewRuler != null;
        if (bl2 != this.fIsOverviewRulerVisible) {
            if (this.fComposite != null && !this.fComposite.isDisposed()) {
                this.fComposite.layout();
            }
            if (this.fIsOverviewRulerVisible) {
                this.ensureOverviewHoverManagerInstalled();
            } else if (this.fOverviewRulerHoveringController != null) {
                this.fOverviewRulerHoveringController.dispose();
                this.fOverviewRulerHoveringController = null;
            }
        }
    }

    @Override
    public IAnnotationHover getCurrentAnnotationHover() {
        if (this.fVerticalRulerHoveringController == null) {
            return null;
        }
        return this.fVerticalRulerHoveringController.getCurrentAnnotationHover();
    }

    private static final class ColumnPosition
    extends Position {
        int fStartColumn;
        int fEndColumn;

        ColumnPosition(int n, int n2, int n3, int n4) {
            super(n, n2);
            this.fStartColumn = n3;
            this.fEndColumn = n4;
        }
    }

    protected class RulerLayout
    extends Layout {
        protected int fGap;
        private int[] fScrollArrowHeights;

        public RulerLayout(int n) {
            this.fGap = n;
        }

        protected Point computeSize(Composite composite, int n, int n2, boolean bl) {
            Control[] controlArray = composite.getChildren();
            Point point = controlArray[controlArray.length - 1].computeSize(-1, -1, bl);
            if (SourceViewer.this.fVerticalRuler != null && SourceViewer.this.fIsVerticalRulerVisible) {
                point.x += SourceViewer.this.fVerticalRuler.getWidth() + this.fGap;
            }
            return point;
        }

        protected void layout(Composite composite, boolean bl) {
            int n;
            Object object;
            int n2;
            Rectangle rectangle = composite.getClientArea();
            StyledText styledText = SourceViewer.this.getTextWidget();
            Rectangle rectangle2 = styledText.computeTrim(0, 0, 0, 0);
            int n3 = -rectangle2.y;
            int n4 = rectangle2.height - n3;
            if ((styledText.getScrollbarsMode() & 2) != 0) {
                n4 = 0;
            }
            int n5 = rectangle.x;
            int n6 = rectangle.width;
            int n7 = -1;
            if (SourceViewer.this.fOverviewRuler != null && SourceViewer.this.fIsOverviewRulerVisible) {
                n7 = SourceViewer.this.fOverviewRuler.getWidth();
                n6 -= n7 + this.fGap;
            }
            if (SourceViewer.this.fVerticalRuler != null && SourceViewer.this.fIsVerticalRulerVisible) {
                n2 = SourceViewer.this.fVerticalRuler.getWidth();
                object = SourceViewer.this.fVerticalRuler.getControl();
                n = object.getBounds().width;
                object.setBounds(rectangle.x, rectangle.y + n3, n2, rectangle.height - n4 - n3);
                if (bl && SourceViewer.this.getVisualAnnotationModel() != null && n == n2) {
                    object.redraw();
                }
                n5 += n2 + this.fGap;
                n6 -= n2 + this.fGap;
            }
            styledText.setBounds(n5, rectangle.y, n6, rectangle.height);
            if (n7 != -1) {
                boolean bl2;
                if (n4 <= 0) {
                    n4 = n7;
                }
                n2 = rectangle.y + rectangle.height - n4;
                object = this.getVerticalScrollArrowHeights(styledText, n2);
                n = rectangle.x + rectangle.width - n7 - 1;
                SourceViewer.this.fOverviewRuler.getControl().setBounds(n, rectangle.y + object[0], n7, rectangle.height - object[0] - object[1] - n4);
                Control control = SourceViewer.this.fOverviewRuler.getHeaderControl();
                boolean bl3 = bl2 = object[0] < 6 && object[1] < 6;
                if (bl2 || object[0] < object[1] && object[0] < n4 && object[1] > n4) {
                    int n8 = bl2 ? n4 : (int)object[1];
                    control.setBounds(n, rectangle.y + rectangle.height - object[1] - n4, n7, n8);
                } else {
                    control.setBounds(n, rectangle.y, n7, (int)object[0]);
                }
                control.redraw();
            }
        }

        private int[] getVerticalScrollArrowHeights(StyledText styledText, int n) {
            ScrollBar scrollBar = styledText.getVerticalBar();
            if (scrollBar == null) {
                return new int[2];
            }
            int[] nArray = this.computeScrollArrowHeights(styledText, n);
            if (nArray[0] > 0 || nArray[1] > 0) {
                this.fScrollArrowHeights = nArray;
            } else {
                if (this.fScrollArrowHeights != null) {
                    return this.fScrollArrowHeights;
                }
                Point point = styledText.getSize();
                try {
                    int n2 = 1000;
                    n = n - point.y + n2;
                    styledText.setSize(point.x, n2);
                    scrollBar.setValues(0, 0, 0x40000000, 1, 10, 10);
                    nArray = this.computeScrollArrowHeights(styledText, n);
                    this.fScrollArrowHeights = nArray;
                }
                finally {
                    styledText.setSize(point);
                }
            }
            return nArray;
        }

        private int[] computeScrollArrowHeights(StyledText styledText, int n) {
            ScrollBar scrollBar = styledText.getVerticalBar();
            Rectangle rectangle = scrollBar.getThumbTrackBounds();
            if (rectangle.height == 0) {
                return new int[2];
            }
            int n2 = rectangle.y;
            int n3 = n - (rectangle.y + rectangle.height);
            return new int[]{n2, n3};
        }
    }
}

