/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.source.AnnotationBarHoverManager;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ScrollBar;

class OverviewRulerHoverManager
extends AnnotationBarHoverManager {
    public OverviewRulerHoverManager(IOverviewRuler iOverviewRuler, ISourceViewer iSourceViewer, IAnnotationHover iAnnotationHover, IInformationControlCreator iInformationControlCreator) {
        super(iOverviewRuler, iSourceViewer, iAnnotationHover, iInformationControlCreator);
        ScrollBar scrollBar;
        this.setAnchor(ANCHOR_LEFT);
        StyledText styledText = iSourceViewer.getTextWidget();
        if (styledText != null && (scrollBar = styledText.getVerticalBar()) != null) {
            this.setMargins(scrollBar.getSize().x, 5);
        }
    }

    @Override
    protected void computeInformation() {
        Point point = this.getHoverEventLocation();
        int n = this.getVerticalRulerInfo().toDocumentLineNumber(point.y);
        IAnnotationHover iAnnotationHover = this.getAnnotationHover();
        IInformationControlCreator iInformationControlCreator = null;
        if (iAnnotationHover instanceof IAnnotationHoverExtension) {
            iInformationControlCreator = ((IAnnotationHoverExtension)((Object)iAnnotationHover)).getHoverControlCreator();
        }
        this.setCustomInformationControlCreator(iInformationControlCreator);
        this.setInformation(iAnnotationHover.getHoverInfo(this.getSourceViewer(), n), this.computeArea(point.y));
    }

    private Rectangle computeArea(int n) {
        IOverviewRuler iOverviewRuler = (IOverviewRuler)this.getVerticalRulerInfo();
        int n2 = iOverviewRuler.getAnnotationHeight();
        int n3 = this.getVerticalRulerInfo().getControl().getSize().x;
        int n4 = n;
        boolean bl = true;
        while (bl && n4 > n - n2) {
            bl = iOverviewRuler.hasAnnotation(--n4);
        }
        return new Rectangle(0, ++n4, n3, n2);
    }
}

