/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationAccessExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IOverviewRulerExtension;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.JFaceTextMessages;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;

public class OverviewRuler
implements IOverviewRulerExtension,
IOverviewRuler {
    private static final boolean DEBUG_DRAW = false;
    private static final boolean DEBUG_COMPUTE_Y = false;
    private static final boolean DEBUG_TO_DOCUMENT_LINE_NUMBER = false;
    private static final boolean IS_MAC = Util.isMac();
    private static final int INSET = 2;
    private static final int ANNOTATION_HEIGHT = 4;
    private static boolean ANNOTATION_HEIGHT_SCALABLE = true;
    private IAnnotationModel fModel;
    private ITextViewer fTextViewer;
    private Canvas fCanvas;
    private Canvas fHeader;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private int fWidth;
    private Cursor fHitDetectionCursor;
    private Cursor fLastCursor;
    private int fLastMouseButtonActivityLine = -1;
    private int fAnnotationHeight = -1;
    private IAnnotationAccess fAnnotationAccess;
    private HeaderPainter fHeaderPainter;
    private Set fConfiguredAnnotationTypes = new HashSet();
    private Set fConfiguredHeaderAnnotationTypes = new HashSet();
    private Map fAnnotationTypes2Colors = new HashMap();
    private ISharedTextColors fSharedTextColors;
    private List fAnnotationsSortedByLayer = new ArrayList();
    private List fLayersSortedByLayer = new ArrayList();
    private Map fAllowedAnnotationTypes = new HashMap();
    private Map fAllowedHeaderAnnotationTypes = new HashMap();
    private List fCachedAnnotations = new ArrayList();
    private Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted = false;
    private Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = OverviewRuler.this.fRunnableLock;
            synchronized (object) {
                OverviewRuler.this.fIsRunnablePosted = false;
            }
            OverviewRuler.this.redraw();
            OverviewRuler.this.updateHeader();
        }
    };
    private boolean fIsTemporaryAnnotationDiscolored;
    private boolean fUseSaturatedColors = false;

    public OverviewRuler(IAnnotationAccess iAnnotationAccess, int n, ISharedTextColors iSharedTextColors) {
        this(iAnnotationAccess, n, iSharedTextColors, false);
    }

    public OverviewRuler(IAnnotationAccess iAnnotationAccess, int n, ISharedTextColors iSharedTextColors, boolean bl) {
        this.fAnnotationAccess = iAnnotationAccess;
        this.fWidth = n;
        this.fSharedTextColors = iSharedTextColors;
        this.fIsTemporaryAnnotationDiscolored = bl;
    }

    @Override
    public Control getControl() {
        return this.fCanvas;
    }

    @Override
    public int getWidth() {
        return this.fWidth;
    }

    @Override
    public void setModel(IAnnotationModel iAnnotationModel) {
        if (iAnnotationModel != this.fModel || iAnnotationModel != null) {
            if (this.fModel != null) {
                this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.fModel = iAnnotationModel;
            if (this.fModel != null) {
                this.fModel.addAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
            }
            this.update();
        }
    }

    @Override
    public Control createControl(Composite composite, ITextViewer iTextViewer) {
        this.fTextViewer = iTextViewer;
        this.fHitDetectionCursor = composite.getDisplay().getSystemCursor(21);
        this.fHeader = new Canvas(composite, 0);
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            this.fHeader.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent mouseEvent) {
                    OverviewRuler.this.updateHeaderToolTipText();
                }
            });
        }
        this.fCanvas = new Canvas(composite, 262144);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (OverviewRuler.this.fTextViewer != null) {
                    OverviewRuler.this.doubleBufferPaint(paintEvent.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                OverviewRuler.this.handleDispose();
                OverviewRuler.this.fTextViewer = null;
            }
        });
        this.fCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                OverviewRuler.this.handleMouseDown(mouseEvent);
            }
        });
        this.fCanvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent mouseEvent) {
                OverviewRuler.this.handleMouseMove(mouseEvent);
            }
        });
        if (this.fTextViewer != null) {
            this.fTextViewer.addTextListener(this.fInternalListener);
        }
        return this.fCanvas;
    }

    private void handleDispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeTextListener(this.fInternalListener);
            this.fTextViewer = null;
        }
        if (this.fModel != null) {
            this.fModel.removeAnnotationModelListener((IAnnotationModelListener)this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
        this.fConfiguredAnnotationTypes.clear();
        this.fAllowedAnnotationTypes.clear();
        this.fConfiguredHeaderAnnotationTypes.clear();
        this.fAllowedHeaderAnnotationTypes.clear();
        this.fAnnotationTypes2Colors.clear();
        this.fAnnotationsSortedByLayer.clear();
        this.fLayersSortedByLayer.clear();
    }

    private void doubleBufferPaint(GC gC) {
        Rectangle rectangle;
        Point point = this.fCanvas.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            rectangle = this.fBuffer.getBounds();
            if (rectangle.width != point.x || rectangle.height != point.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), point.x, point.y);
        }
        rectangle = new GC((Drawable)this.fBuffer);
        try {
            rectangle.setBackground(this.fCanvas.getBackground());
            rectangle.fillRectangle(0, 0, point.x, point.y);
            this.cacheAnnotations();
            this.doPaint((GC)rectangle);
        }
        finally {
            rectangle.dispose();
        }
        gC.drawImage(this.fBuffer, 0, 0);
    }

    private void cacheAnnotations() {
        this.fCachedAnnotations.clear();
        if (this.fModel != null) {
            Iterator iterator = this.fModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                Annotation annotation = (Annotation)iterator.next();
                if (annotation.isMarkedDeleted() || this.skip(annotation.getType())) continue;
                this.fCachedAnnotations.add(annotation);
            }
        }
    }

    private void doPaint(GC gC) {
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        int n = 4;
        IDocument iDocument = this.fTextViewer.getDocument();
        StyledText styledText = this.fTextViewer.getTextWidget();
        ITextViewerExtension5 iTextViewerExtension5 = null;
        IRegion iRegion = null;
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fTextViewer);
        } else {
            iRegion = this.fTextViewer.getVisibleRegion();
        }
        WidgetInfos widgetInfos = null;
        for (Object e : this.fAnnotationsSortedByLayer) {
            if (this.skip(e)) continue;
            int[] nArray = new int[]{4, 2};
            int n2 = 0;
            while (n2 < nArray.length) {
                boolean bl = false;
                Color color = null;
                Color color2 = null;
                FilterIterator filterIterator = new FilterIterator(e, nArray[n2], this.fCachedAnnotations.iterator());
                while (filterIterator.hasNext()) {
                    int n3;
                    Annotation annotation = (Annotation)filterIterator.next();
                    Position position = this.fModel.getPosition(annotation);
                    if (position == null || iRegion != null && !position.overlapsWith(iRegion.getOffset(), iRegion.getLength())) continue;
                    int n4 = position.getOffset();
                    int n5 = position.getLength();
                    IRegion iRegion2 = null;
                    if (iRegion != null) {
                        n4 = Math.max(position.getOffset(), iRegion.getOffset());
                        n3 = Math.min(position.getOffset() + position.getLength(), iRegion.getOffset() + iRegion.getLength());
                        n5 = n3 - n4;
                    } else {
                        iRegion2 = iTextViewerExtension5.modelRange2WidgetRange((IRegion)new Region(n4, n5));
                        if (iRegion2 == null) continue;
                    }
                    if (widgetInfos == null) {
                        widgetInfos = new WidgetInfos(styledText, this.fCanvas);
                        rectangle.x = 2;
                        rectangle.width = widgetInfos.bounds.width - 4;
                    }
                    try {
                        n3 = iRegion != null ? n4 - iRegion.getOffset() : iRegion2.getOffset();
                        int n6 = styledText.getLineAtOffset(n3);
                        int n7 = this.computeY(n6, widgetInfos);
                        if (ANNOTATION_HEIGHT_SCALABLE) {
                            int n8 = iDocument.getNumberOfLines(n4, n5);
                            IRegion iRegion3 = iDocument.getLineInformationOfOffset(n4 + n5);
                            if (iRegion3.getOffset() == n4 + n5) {
                                --n8;
                            }
                            if (n8 > 1) {
                                int n9 = this.computeY(n6 + n8 - 1, widgetInfos);
                                n = Math.max(n9 - n7, 4);
                            } else {
                                n = 4;
                            }
                        }
                        this.fAnnotationHeight = n;
                        if (!bl) {
                            color2 = this.getStrokeColor(e, nArray[n2] == 2);
                            color = this.fUseSaturatedColors ? color2 : this.getFillColor(e, nArray[n2] == 2);
                            bl = true;
                        }
                        if (color != null) {
                            gC.setBackground(color);
                            gC.fillRectangle(2, n7, widgetInfos.bounds.width - 4, n);
                        }
                        if (color2 == null) continue;
                        gC.setForeground(color2);
                        rectangle.y = n7;
                        if (n7 + n == widgetInfos.bounds.height) {
                            --rectangle.y;
                        }
                        rectangle.height = n;
                        gC.setLineWidth(0);
                        gC.drawRectangle(rectangle);
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ++n2;
            }
        }
    }

    private int computeY(int n, WidgetInfos widgetInfos) {
        int n2 = widgetInfos.bounds.height > widgetInfos.writable || widgetInfos.invisibleLines <= 0.0 ? Math.max(0, (2 * n + 1) * widgetInfos.writable / (widgetInfos.maxLines * 2) - widgetInfos.bounds.y) : ((double)(n + 1) < widgetInfos.visibleLines / 2.0 ? (int)((double)(n * widgetInfos.thumbHeight) / widgetInfos.visibleLines) : ((double)widgetInfos.maxLines - widgetInfos.visibleLines / 2.0 <= (double)n ? (int)((double)(widgetInfos.bounds.height - 1) - (double)widgetInfos.thumbHeight / 2.0 + ((double)n - ((double)widgetInfos.maxLines - widgetInfos.visibleLines / 2.0) + 1.0) * (double)widgetInfos.thumbHeight / widgetInfos.visibleLines) : (int)((double)widgetInfos.thumbHeight / 2.0 + ((double)(n + 1) - widgetInfos.visibleLines / 2.0) * (double)(widgetInfos.bounds.height - 1 - widgetInfos.thumbHeight) / widgetInfos.invisibleLines)));
        n2 -= 2;
        n2 = Math.max(0, Math.min(n2, widgetInfos.bounds.height - 1 - 4));
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        Display display;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (display = this.fCanvas.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            display.asyncExec(this.fRunnable);
        }
    }

    private void redraw() {
        if (this.fTextViewer == null || this.fModel == null) {
            return;
        }
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            if (IS_MAC) {
                this.fCanvas.redraw();
                this.fCanvas.update();
            } else {
                GC gC = new GC((Drawable)this.fCanvas);
                this.doubleBufferPaint(gC);
                gC.dispose();
            }
        }
    }

    private int[] toLineNumbers(int n, boolean bl) {
        int n2;
        int[] nArray;
        WidgetInfos widgetInfos = new WidgetInfos(this.fTextViewer.getTextWidget(), this.fCanvas);
        if (n >= widgetInfos.writable || n >= widgetInfos.bounds.height || n < 0) {
            return new int[]{-1, -1};
        }
        if (bl && 4 >= widgetInfos.bounds.height / widgetInfos.maxLines) {
            bl = false;
        }
        int[] nArray2 = new int[2];
        int n3 = Math.min(widgetInfos.bounds.height, n + 2 + 1);
        if (bl) {
            nArray = new int[]{n3};
        } else {
            n2 = Math.max(n - 2 + 1, 0);
            nArray = new int[]{n2, n3};
        }
        if (widgetInfos.bounds.height > widgetInfos.writable || widgetInfos.invisibleLines <= 0.0) {
            n2 = 0;
            while (n2 < nArray.length) {
                nArray2[n2] = (int)((double)((nArray[n2] + widgetInfos.bounds.y) * widgetInfos.maxLines) / (double)widgetInfos.writable);
                ++n2;
            }
        } else if (n < widgetInfos.thumbHeight / 2) {
            n2 = 0;
            while (n2 < nArray.length) {
                nArray2[n2] = (int)((double)nArray[n2] * widgetInfos.visibleLines / (double)widgetInfos.thumbHeight);
                ++n2;
            }
        } else if (widgetInfos.bounds.height - 1 - widgetInfos.thumbHeight / 2 < n) {
            n2 = 0;
            while (n2 < nArray.length) {
                nArray2[n2] = (int)(((double)(nArray[n2] - (widgetInfos.bounds.height - 1)) + (double)widgetInfos.thumbHeight / 2.0) * widgetInfos.visibleLines / (double)widgetInfos.thumbHeight - 1.0 + ((double)widgetInfos.maxLines - widgetInfos.visibleLines / 2.0));
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < nArray.length) {
                nArray2[n2] = (int)(((double)nArray[n2] - (double)widgetInfos.thumbHeight / 2.0) * widgetInfos.invisibleLines / (double)(widgetInfos.bounds.height - 1 - widgetInfos.thumbHeight) - 1.0 + widgetInfos.visibleLines / 2.0);
                ++n2;
            }
        }
        if (n < 4 && n < widgetInfos.bounds.y) {
            nArray2[0] = 0;
        } else if (nArray2[0] < 0) {
            nArray2[0] = 0;
        }
        if (bl) {
            n2 = this.computeY(nArray2[0], widgetInfos);
            if (n < n2 || n2 + 4 < n) {
                nArray2[0] = -1;
                nArray2[1] = -1;
                return nArray2;
            }
            nArray2[1] = nArray2[0];
        }
        if (nArray2[1] > widgetInfos.maxLines) {
            nArray2[1] = widgetInfos.maxLines;
        }
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fTextViewer);
            nArray2[0] = iTextViewerExtension5.widgetLine2ModelLine(nArray2[0]);
            nArray2[1] = iTextViewerExtension5.widgetLine2ModelLine(nArray2[1]);
        } else {
            try {
                IRegion iRegion = this.fTextViewer.getVisibleRegion();
                int n4 = this.fTextViewer.getDocument().getLineOfOffset(iRegion.getOffset());
                nArray2[0] = nArray2[0] + n4;
                nArray2[1] = nArray2[1] + n4;
            }
            catch (BadLocationException badLocationException) {}
        }
        return nArray2;
    }

    private Position getAnnotationPosition(int[] nArray) {
        if (nArray[0] == -1) {
            return null;
        }
        Position position = null;
        try {
            IDocument iDocument = this.fTextViewer.getDocument();
            IRegion iRegion = iDocument.getLineInformation(nArray[0]);
            int n = iRegion.getOffset();
            iRegion = iDocument.getLineInformation(nArray[nArray.length - 1]);
            int n2 = iRegion.getOffset() + iRegion.getLength();
            int n3 = this.fAnnotationsSortedByLayer.size() - 1;
            while (n3 >= 0) {
                Object e = this.fAnnotationsSortedByLayer.get(n3);
                FilterIterator filterIterator = new FilterIterator(e, 6);
                while (filterIterator.hasNext() && position == null) {
                    Position position2;
                    Annotation annotation = (Annotation)filterIterator.next();
                    if (annotation.isMarkedDeleted() || this.skip(annotation.getType()) || (position2 = this.fModel.getPosition(annotation)) == null) continue;
                    int n4 = position2.getOffset();
                    int n5 = n4 + position2.getLength();
                    IRegion iRegion2 = iDocument.getLineInformationOfOffset(n5);
                    if (n5 > n4 && iRegion2.getOffset() == n5) {
                        iRegion2 = iDocument.getLineInformationOfOffset(--n5);
                    }
                    if (n4 > n2 || n5 < n) continue;
                    position = position2;
                }
                --n3;
            }
        }
        catch (BadLocationException badLocationException) {}
        return position;
    }

    private int findBestMatchingLineNumber(int[] nArray) {
        Position position;
        block4: {
            if (nArray == null || nArray.length < 1) {
                return -1;
            }
            try {
                position = this.getAnnotationPosition(nArray);
                if (position != null) break block4;
                return -1;
            }
            catch (BadLocationException badLocationException) {
                return -1;
            }
        }
        return this.fTextViewer.getDocument().getLineOfOffset(position.getOffset());
    }

    private void handleMouseDown(MouseEvent mouseEvent) {
        if (this.fTextViewer != null) {
            Position position;
            int[] nArray = this.toLineNumbers(mouseEvent.y, true);
            if (nArray[0] == -1) {
                nArray = this.toLineNumbers(mouseEvent.y, false);
            }
            if ((position = this.getAnnotationPosition(nArray)) == null && mouseEvent.button == 1) {
                try {
                    position = new Position(this.fTextViewer.getDocument().getLineInformation(nArray[0]).getOffset(), 0);
                }
                catch (BadLocationException badLocationException) {}
            }
            if (position != null) {
                this.fTextViewer.revealRange(position.getOffset(), position.getLength());
                this.fTextViewer.setSelectedRange(position.getOffset(), position.getLength());
            }
            this.fTextViewer.getTextWidget().setFocus();
        }
        this.fLastMouseButtonActivityLine = this.toDocumentLineNumber(mouseEvent.y);
    }

    private void handleMouseMove(MouseEvent mouseEvent) {
        if (this.fTextViewer != null) {
            Cursor cursor;
            int[] nArray = this.toLineNumbers(mouseEvent.y, true);
            Position position = this.getAnnotationPosition(nArray);
            Cursor cursor2 = cursor = position != null ? this.fHitDetectionCursor : null;
            if (cursor != this.fLastCursor) {
                this.fCanvas.setCursor(cursor);
                this.fLastCursor = cursor;
            }
        }
    }

    @Override
    public void addAnnotationType(Object object) {
        this.fConfiguredAnnotationTypes.add(object);
        this.fAllowedAnnotationTypes.clear();
    }

    @Override
    public void removeAnnotationType(Object object) {
        this.fConfiguredAnnotationTypes.remove(object);
        this.fAllowedAnnotationTypes.clear();
    }

    @Override
    public void setAnnotationTypeLayer(Object object, int n) {
        int n2 = this.fAnnotationsSortedByLayer.indexOf(object);
        if (n2 != -1) {
            this.fAnnotationsSortedByLayer.remove(n2);
            this.fLayersSortedByLayer.remove(n2);
        }
        if (n >= 0) {
            int n3 = 0;
            int n4 = this.fLayersSortedByLayer.size();
            while (n3 < n4 && n >= (Integer)this.fLayersSortedByLayer.get(n3)) {
                ++n3;
            }
            Integer n5 = new Integer(n);
            this.fLayersSortedByLayer.add(n3, n5);
            this.fAnnotationsSortedByLayer.add(n3, object);
        }
    }

    @Override
    public void setAnnotationTypeColor(Object object, Color color) {
        if (color != null) {
            this.fAnnotationTypes2Colors.put(object, color);
        } else {
            this.fAnnotationTypes2Colors.remove(object);
        }
    }

    private boolean skip(Object object) {
        return !this.contains(object, this.fAllowedAnnotationTypes, this.fConfiguredAnnotationTypes);
    }

    private boolean skipInHeader(Object object) {
        return !this.contains(object, this.fAllowedHeaderAnnotationTypes, this.fConfiguredHeaderAnnotationTypes);
    }

    private boolean contains(Object object, Map map, Set set) {
        Boolean bl = (Boolean)map.get(object);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = this.isCovered(object, set);
        map.put(object, bl2 ? Boolean.TRUE : Boolean.FALSE);
        return bl2;
    }

    private boolean isCovered(Object object, Set set) {
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
            IAnnotationAccessExtension iAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                if (!iAnnotationAccessExtension.isSubtype(object, iterator.next())) continue;
                return true;
            }
            return false;
        }
        return set.contains(object);
    }

    private static RGB interpolate(RGB rGB, RGB rGB2, double d) {
        return new RGB((int)((1.0 - d) * (double)rGB.red + d * (double)rGB2.red), (int)((1.0 - d) * (double)rGB.green + d * (double)rGB2.green), (int)((1.0 - d) * (double)rGB.blue + d * (double)rGB2.blue));
    }

    private static double greyLevel(RGB rGB) {
        if (rGB.red == rGB.green && rGB.green == rGB.blue) {
            return rGB.red;
        }
        return 0.299 * (double)rGB.red + 0.587 * (double)rGB.green + 0.114 * (double)rGB.blue + 0.5;
    }

    private static boolean isDark(RGB rGB) {
        return OverviewRuler.greyLevel(rGB) > 128.0;
    }

    private Color getColor(Object object, double d) {
        Color color = this.findColor(object);
        if (color == null) {
            return null;
        }
        RGB rGB = color.getRGB();
        RGB rGB2 = this.fCanvas.getBackground().getRGB();
        boolean bl = OverviewRuler.isDark(rGB);
        boolean bl2 = OverviewRuler.isDark(rGB2);
        if (bl && bl2) {
            rGB2 = new RGB(255, 255, 255);
        } else if (!bl && !bl2) {
            rGB2 = new RGB(0, 0, 0);
        }
        return this.fSharedTextColors.getColor(OverviewRuler.interpolate(rGB, rGB2, d));
    }

    private Color findColor(Object object) {
        IAnnotationAccessExtension iAnnotationAccessExtension;
        Object[] objectArray;
        Color color = (Color)this.fAnnotationTypes2Colors.get(object);
        if (color != null) {
            return color;
        }
        if (this.fAnnotationAccess instanceof IAnnotationAccessExtension && (objectArray = (iAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)this.fAnnotationAccess)).getSupertypes(object)) != null) {
            int n = 0;
            while (n < objectArray.length) {
                color = (Color)this.fAnnotationTypes2Colors.get(objectArray[n]);
                if (color != null) {
                    return color;
                }
                ++n;
            }
        }
        return null;
    }

    private Color getStrokeColor(Object object, boolean bl) {
        return this.getColor(object, bl && this.fIsTemporaryAnnotationDiscolored ? 0.5 : 0.2);
    }

    private Color getFillColor(Object object, boolean bl) {
        return this.getColor(object, bl && this.fIsTemporaryAnnotationDiscolored ? 0.9 : 0.75);
    }

    @Override
    public int getLineOfLastMouseButtonActivity() {
        if (this.fLastMouseButtonActivityLine >= this.fTextViewer.getDocument().getNumberOfLines()) {
            this.fLastMouseButtonActivityLine = -1;
        }
        return this.fLastMouseButtonActivityLine;
    }

    @Override
    public int toDocumentLineNumber(int n) {
        int n2;
        if (this.fTextViewer == null || n == -1) {
            return -1;
        }
        int[] nArray = this.toLineNumbers(n, true);
        if (nArray[0] == -1) {
            nArray = this.toLineNumbers(n, false);
        }
        if ((n2 = this.findBestMatchingLineNumber(nArray)) == -1 && nArray.length > 0) {
            return nArray[0];
        }
        return n2;
    }

    @Override
    public IAnnotationModel getModel() {
        return this.fModel;
    }

    @Override
    public int getAnnotationHeight() {
        return this.fAnnotationHeight;
    }

    @Override
    public boolean hasAnnotation(int n) {
        return this.findBestMatchingLineNumber(this.toLineNumbers(n, true)) != -1;
    }

    @Override
    public Control getHeaderControl() {
        return this.fHeader;
    }

    @Override
    public void addHeaderAnnotationType(Object object) {
        this.fConfiguredHeaderAnnotationTypes.add(object);
        this.fAllowedHeaderAnnotationTypes.clear();
    }

    @Override
    public void removeHeaderAnnotationType(Object object) {
        this.fConfiguredHeaderAnnotationTypes.remove(object);
        this.fAllowedHeaderAnnotationTypes.clear();
    }

    private void updateHeader() {
        if (this.fHeader == null || this.fHeader.isDisposed()) {
            return;
        }
        this.fHeader.setToolTipText(null);
        Object var1_1 = null;
        int n = this.fAnnotationsSortedByLayer.size() - 1;
        block0: while (n >= 0) {
            Object e = this.fAnnotationsSortedByLayer.get(n);
            if (!this.skipInHeader(e) && !this.skip(e)) {
                FilterIterator filterIterator = new FilterIterator(e, 14, this.fCachedAnnotations.iterator());
                while (filterIterator.hasNext()) {
                    if (filterIterator.next() == null) continue;
                    var1_1 = e;
                    break block0;
                }
            }
            --n;
        }
        Color color = null;
        if (var1_1 != null) {
            color = this.findColor(var1_1);
        }
        if (color == null) {
            if (this.fHeaderPainter != null) {
                this.fHeaderPainter.setColor(null);
            }
        } else {
            if (this.fHeaderPainter == null) {
                this.fHeaderPainter = new HeaderPainter();
                this.fHeader.addPaintListener((PaintListener)this.fHeaderPainter);
            }
            this.fHeaderPainter.setColor(color);
        }
        this.fHeader.redraw();
    }

    private void updateHeaderToolTipText() {
        if (this.fHeader == null || this.fHeader.isDisposed()) {
            return;
        }
        if (this.fHeader.getToolTipText() != null) {
            return;
        }
        String string = "";
        int n = this.fAnnotationsSortedByLayer.size() - 1;
        while (n >= 0) {
            Object e = this.fAnnotationsSortedByLayer.get(n);
            if (!this.skipInHeader(e) && !this.skip(e)) {
                int n2 = 0;
                String string2 = null;
                FilterIterator filterIterator = new FilterIterator(e, 14, this.fCachedAnnotations.iterator());
                while (filterIterator.hasNext()) {
                    Annotation annotation = (Annotation)filterIterator.next();
                    if (annotation == null) continue;
                    if (string2 == null) {
                        string2 = ((IAnnotationAccessExtension)((Object)this.fAnnotationAccess)).getTypeLabel(annotation);
                    }
                    ++n2;
                }
                if (string2 != null) {
                    if (string.length() > 0) {
                        string = String.valueOf(string) + "\n";
                    }
                    string = String.valueOf(string) + JFaceTextMessages.getFormattedString("OverviewRulerHeader.toolTipTextEntry", new Object[]{string2, new Integer(n2)});
                }
            }
            --n;
        }
        if (string.length() > 0) {
            this.fHeader.setToolTipText(string);
        }
    }

    @Override
    public void setUseSaturatedColors(boolean bl) {
        this.fUseSaturatedColors = bl;
    }

    class FilterIterator
    implements Iterator {
        static final int TEMPORARY = 2;
        static final int PERSISTENT = 4;
        static final int IGNORE_BAGS = 8;
        private Iterator fIterator;
        private Object fType;
        private Annotation fNext;
        private int fStyle;

        public FilterIterator(Object object, int n) {
            this.fType = object;
            this.fStyle = n;
            if (OverviewRuler.this.fModel != null) {
                this.fIterator = OverviewRuler.this.fModel.getAnnotationIterator();
                this.skip();
            }
        }

        public FilterIterator(Object object, int n, Iterator iterator) {
            this.fType = object;
            this.fStyle = n;
            this.fIterator = iterator;
            this.skip();
        }

        private void skip() {
            boolean bl = (this.fStyle & 2) != 0;
            boolean bl2 = (this.fStyle & 4) != 0;
            boolean bl3 = (this.fStyle & 8) != 0;
            while (this.fIterator.hasNext()) {
                Annotation annotation = (Annotation)this.fIterator.next();
                if (annotation.isMarkedDeleted() || bl3 && annotation instanceof AnnotationBag) continue;
                this.fNext = annotation;
                String string = annotation.getType();
                if (this.fType != null && !this.fType.equals(string) && (OverviewRuler.this.fConfiguredAnnotationTypes.contains(string) || !this.isSubtype(string))) continue;
                if (bl && bl2) {
                    return;
                }
                if (bl2 && annotation.isPersistent()) {
                    return;
                }
                if (!bl || annotation.isPersistent()) continue;
                return;
            }
            this.fNext = null;
        }

        private boolean isSubtype(Object object) {
            if (OverviewRuler.this.fAnnotationAccess instanceof IAnnotationAccessExtension) {
                IAnnotationAccessExtension iAnnotationAccessExtension = (IAnnotationAccessExtension)((Object)OverviewRuler.this.fAnnotationAccess);
                return iAnnotationAccessExtension.isSubtype(object, this.fType);
            }
            return this.fType.equals(object);
        }

        @Override
        public boolean hasNext() {
            return this.fNext != null;
        }

        public Object next() {
            try {
                Annotation annotation = this.fNext;
                return annotation;
            }
            finally {
                if (this.fIterator != null) {
                    this.skip();
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class HeaderPainter
    implements PaintListener {
        private Color fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = OverviewRuler.this.fHeader.getDisplay().getSystemColor(18);
        }

        public void setColor(Color color) {
            this.fIndicatorColor = color;
        }

        private void drawBevelRect(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
            gC.setForeground(color);
            gC.drawLine(n, n2, n + n3 - 1, n2);
            gC.drawLine(n, n2, n, n2 + n4 - 1);
            gC.setForeground(color2);
            gC.drawLine(n + n3, n2, n + n3, n2 + n4);
            gC.drawLine(n, n2 + n4, n + n3, n2 + n4);
        }

        public void paintControl(PaintEvent paintEvent) {
            boolean bl;
            if (this.fIndicatorColor == null) {
                return;
            }
            Point point = OverviewRuler.this.fHeader.getSize();
            paintEvent.gc.setBackground(this.fIndicatorColor);
            Rectangle rectangle = OverviewRuler.this.fHeader.getBounds();
            boolean bl2 = rectangle.y + rectangle.height <= ((OverviewRuler)OverviewRuler.this).fCanvas.getLocation().y;
            boolean bl3 = bl = point.y > point.x + 8;
            int n = !bl2 ? point.y - 12 : (bl ? 4 : (point.y - 8) / 2);
            Rectangle rectangle2 = new Rectangle(2, n, point.x - 4, 8);
            paintEvent.gc.fillRectangle(rectangle2);
            this.drawBevelRect(paintEvent.gc, rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1, this.fSeparatorColor, this.fSeparatorColor);
            paintEvent.gc.setForeground(this.fSeparatorColor);
            paintEvent.gc.setLineWidth(0);
            if (!bl2 || !bl) {
                paintEvent.gc.drawLine(0, point.y - 1, point.x - 1, point.y - 1);
            }
        }
    }

    class InternalListener
    implements ITextListener,
    IAnnotationModelListener,
    IAnnotationModelListenerExtension {
        InternalListener() {
        }

        @Override
        public void textChanged(TextEvent textEvent) {
            if (OverviewRuler.this.fTextViewer != null && textEvent.getDocumentEvent() == null && textEvent.getViewerRedrawState()) {
                OverviewRuler.this.redraw();
            }
        }

        public void modelChanged(IAnnotationModel iAnnotationModel) {
            OverviewRuler.this.update();
        }

        public void modelChanged(AnnotationModelEvent annotationModelEvent) {
            if (!annotationModelEvent.isValid()) {
                return;
            }
            if (annotationModelEvent.isWorldChange()) {
                OverviewRuler.this.update();
                return;
            }
            Annotation[] annotationArray = annotationModelEvent.getAddedAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                if (!OverviewRuler.this.skip(annotationArray[n2].getType())) {
                    OverviewRuler.this.update();
                    return;
                }
                ++n2;
            }
            annotationArray = annotationModelEvent.getRemovedAnnotations();
            n = annotationArray.length;
            n2 = 0;
            while (n2 < n) {
                if (!OverviewRuler.this.skip(annotationArray[n2].getType())) {
                    OverviewRuler.this.update();
                    return;
                }
                ++n2;
            }
            annotationArray = annotationModelEvent.getChangedAnnotations();
            n = annotationArray.length;
            n2 = 0;
            while (n2 < n) {
                if (!OverviewRuler.this.skip(annotationArray[n2].getType())) {
                    OverviewRuler.this.update();
                    return;
                }
                ++n2;
            }
        }
    }

    static class WidgetInfos {
        int maxLines;
        int thumbHeight;
        double visibleLines;
        double invisibleLines;
        Rectangle bounds;
        int writable;

        public WidgetInfos(StyledText styledText, Canvas canvas) {
            this.maxLines = styledText.getLineCount();
            this.bounds = canvas.getBounds();
            this.writable = JFaceTextUtil.computeLineHeight(styledText, 0, this.maxLines, this.maxLines);
            ScrollBar scrollBar = styledText.getVerticalBar();
            this.thumbHeight = scrollBar != null ? Math.max(Math.min(this.bounds.height, scrollBar.getThumbBounds().height), 0) : 0;
            int n = JFaceTextUtil.getPartialTopIndex(styledText);
            int n2 = styledText.getLineHeight(styledText.getOffsetAtLine(n));
            int n3 = styledText.getLinePixel(n);
            double d = (double)n - (double)n3 / (double)n2;
            int n4 = JFaceTextUtil.getPartialBottomIndex(styledText);
            int n5 = styledText.getLineHeight(styledText.getOffsetAtLine(n4));
            int n6 = styledText.getLinePixel(n4);
            double d2 = (double)n4 - ((double)n6 - (double)styledText.getClientArea().height) / (double)n5;
            this.visibleLines = d2 - d;
            this.invisibleLines = (double)this.maxLines - this.visibleLines;
        }
    }
}

