/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public final class MatchingCharacterPainter
implements IPainter,
PaintListener {
    private boolean fIsActive = false;
    private ISourceViewer fSourceViewer;
    private StyledText fTextWidget;
    private Color fColor;
    private IPaintPositionManager fPaintPositionManager;
    private ICharacterPairMatcher fMatcher;
    private Position fPairPosition = new Position(0, 0);
    private int fAnchor;
    private boolean fHighlightEnclosingPeerCharacters;
    private boolean fHighlightCharacterAtCaretLocation;
    private boolean fCharacterPresentAtCaretLocation;
    private IDocument fDocument;
    private IRegion fPreviousSelection;
    private int fPreviousLengthOfDocument;
    private boolean fDocumentChanged;
    private TextListener fTextListener;

    public MatchingCharacterPainter(ISourceViewer iSourceViewer, ICharacterPairMatcher iCharacterPairMatcher) {
        this.fSourceViewer = iSourceViewer;
        this.fMatcher = iCharacterPairMatcher;
        this.fTextWidget = iSourceViewer.getTextWidget();
        this.fDocument = this.fSourceViewer.getDocument();
    }

    public void setHighlightCharacterAtCaretLocation(boolean bl) {
        this.handleDrawRequest(null);
        this.fHighlightCharacterAtCaretLocation = bl;
    }

    public void setHighlightEnclosingPeerCharacters(boolean bl) {
        this.fHighlightEnclosingPeerCharacters = bl;
        this.installUninstallTextListener(bl);
    }

    public void setColor(Color color) {
        this.fColor = color;
    }

    @Override
    public void dispose() {
        if (this.fMatcher != null) {
            if (this.fMatcher instanceof ICharacterPairMatcherExtension && this.fTextListener != null) {
                this.installUninstallTextListener(false);
            }
            this.fMatcher.clear();
            this.fMatcher = null;
        }
        this.fColor = null;
        this.fTextWidget = null;
    }

    @Override
    public void deactivate(boolean bl) {
        if (this.fIsActive) {
            this.fIsActive = false;
            this.fTextWidget.removePaintListener((PaintListener)this);
            if (this.fPaintPositionManager != null) {
                this.fPaintPositionManager.unmanagePosition(this.fPairPosition);
            }
            if (bl) {
                this.handleDrawRequest(null);
            }
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        if (this.fTextWidget != null) {
            this.handleDrawRequest(paintEvent.gc);
        }
    }

    private void handleDrawRequest(GC gC) {
        if (this.fPairPosition.isDeleted) {
            return;
        }
        int n = this.fPairPosition.getOffset();
        int n2 = this.fPairPosition.getLength();
        if (n2 < 1) {
            return;
        }
        if (this.fSourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)this.fSourceViewer);
            IRegion iRegion = iTextViewerExtension5.modelRange2WidgetRange((IRegion)new Region(n, n2));
            if (iRegion == null) {
                return;
            }
            try {
                IDocument iDocument = this.fSourceViewer.getDocument();
                int n3 = iDocument.getLineOfOffset(n);
                int n4 = iDocument.getLineOfOffset(n + n2);
                if (iTextViewerExtension5.modelLine2WidgetLine(n3) == -1 || iTextViewerExtension5.modelLine2WidgetLine(n4) == -1) {
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            n = iRegion.getOffset();
            n2 = iRegion.getLength();
        } else {
            IRegion iRegion = this.fSourceViewer.getVisibleRegion();
            if (iRegion.getOffset() > n || iRegion.getOffset() + iRegion.getLength() < n + n2) {
                return;
            }
            n -= iRegion.getOffset();
        }
        if (this.fHighlightCharacterAtCaretLocation || this.fHighlightEnclosingPeerCharacters && !this.fCharacterPresentAtCaretLocation) {
            this.draw(gC, n, 1);
            this.draw(gC, n + n2 - 1, 1);
        } else if (this.fAnchor == 0) {
            this.draw(gC, n, 1);
        } else {
            this.draw(gC, n + n2 - 1, 1);
        }
    }

    private void draw(GC gC, int n, int n2) {
        if (gC != null) {
            Rectangle rectangle;
            gC.setForeground(this.fColor);
            if (n2 > 0) {
                rectangle = this.fTextWidget.getTextBounds(n, n + n2 - 1);
            } else {
                Point point = this.fTextWidget.getLocationAtOffset(n);
                rectangle = new Rectangle(point.x, point.y, 1, this.fTextWidget.getLineHeight(n));
            }
            gC.drawRectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        } else {
            this.fTextWidget.redrawRange(n, n2, true);
        }
    }

    private static final IRegion getSignedSelection(ISourceViewer iSourceViewer) {
        Point point = iSourceViewer.getSelectedRange();
        StyledText styledText = iSourceViewer.getTextWidget();
        Point point2 = styledText.getSelectionRange();
        if (styledText.getCaretOffset() == point2.x) {
            point.x += point.y;
            point.y = -point.y;
        }
        return new Region(point.x, point.y);
    }

    @Override
    public void paint(int n) {
        boolean bl;
        IRegion iRegion;
        IDocument iDocument = this.fDocument;
        if (iDocument == null) {
            this.deactivate(false);
            return;
        }
        IRegion iRegion2 = MatchingCharacterPainter.getSignedSelection(this.fSourceViewer);
        if (this.fMatcher instanceof ICharacterPairMatcherExtension) {
            ICharacterPairMatcherExtension iCharacterPairMatcherExtension = (ICharacterPairMatcherExtension)((Object)this.fMatcher);
            iRegion = iCharacterPairMatcherExtension.match(iDocument, iRegion2.getOffset(), iRegion2.getLength());
            boolean bl2 = bl = iRegion != null;
            if (iRegion == null && this.fHighlightEnclosingPeerCharacters) {
                int n2 = iDocument.getLength();
                boolean bl3 = n2 != this.fPreviousLengthOfDocument;
                this.fPreviousLengthOfDocument = n2;
                if (n != 16 && !this.fDocumentChanged && !bl3 && iRegion2.equals(this.fPreviousSelection)) {
                    return;
                }
                if (n == 1) {
                    this.fPreviousSelection = iRegion2;
                    return;
                }
                this.fDocumentChanged = false;
                if (n != 16 && !bl3 && this.fPreviousSelection != null && n != 8 && !iCharacterPairMatcherExtension.isRecomputationOfEnclosingPairRequired(iDocument, iRegion2, this.fPreviousSelection)) {
                    if (this.fCharacterPresentAtCaretLocation && !this.fHighlightCharacterAtCaretLocation) {
                        this.fCharacterPresentAtCaretLocation = false;
                        this.handleDrawRequest(null);
                    }
                    this.fPreviousSelection = iRegion2;
                    return;
                }
                iRegion = iCharacterPairMatcherExtension.findEnclosingPeerCharacters(iDocument, iRegion2.getOffset(), iRegion2.getLength());
            }
        } else {
            if (Math.abs(iRegion2.getLength()) > 0) {
                this.deactivate(true);
                return;
            }
            iRegion = this.fMatcher.match(iDocument, iRegion2.getOffset());
            bl = iRegion != null;
        }
        this.fPreviousSelection = iRegion2;
        if (iRegion == null) {
            this.deactivate(true);
            return;
        }
        if (this.fIsActive) {
            if (16 == n) {
                this.handleDrawRequest(null);
            } else if (iRegion.getOffset() != this.fPairPosition.getOffset() || iRegion.getLength() != this.fPairPosition.getLength() || this.fMatcher.getAnchor() != this.fAnchor || bl != this.fCharacterPresentAtCaretLocation) {
                this.handleDrawRequest(null);
                this.fPairPosition.isDeleted = false;
                this.fPairPosition.offset = iRegion.getOffset();
                this.fPairPosition.length = iRegion.getLength();
                this.fAnchor = this.fMatcher.getAnchor();
                this.fCharacterPresentAtCaretLocation = bl;
                this.handleDrawRequest(null);
            }
        } else {
            this.fIsActive = true;
            this.fPairPosition.isDeleted = false;
            this.fPairPosition.offset = iRegion.getOffset();
            this.fPairPosition.length = iRegion.getLength();
            this.fAnchor = this.fMatcher.getAnchor();
            this.fCharacterPresentAtCaretLocation = bl;
            this.fTextWidget.addPaintListener((PaintListener)this);
            this.fPaintPositionManager.managePosition(this.fPairPosition);
            this.handleDrawRequest(null);
        }
    }

    @Override
    public void setPositionManager(IPaintPositionManager iPaintPositionManager) {
        this.fPaintPositionManager = iPaintPositionManager;
    }

    private void installUninstallTextListener(boolean bl) {
        if (!(this.fMatcher instanceof ICharacterPairMatcherExtension)) {
            return;
        }
        if (bl) {
            this.fTextListener = new TextListener();
            this.fSourceViewer.addTextInputListener(this.fTextListener);
            this.fSourceViewer.addTextListener(this.fTextListener);
        } else if (this.fTextListener != null) {
            this.fSourceViewer.removeTextInputListener(this.fTextListener);
            this.fSourceViewer.removeTextListener(this.fTextListener);
            this.fTextListener = null;
        }
    }

    private class TextListener
    implements ITextListener,
    ITextInputListener {
        private TextListener() {
        }

        @Override
        public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
            MatchingCharacterPainter.this.fDocument = null;
        }

        @Override
        public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
            MatchingCharacterPainter.this.fDocument = iDocument2;
            MatchingCharacterPainter.this.fDocumentChanged = true;
        }

        @Override
        public void textChanged(TextEvent textEvent) {
            if (!MatchingCharacterPainter.this.fHighlightEnclosingPeerCharacters || !(MatchingCharacterPainter.this.fMatcher instanceof ICharacterPairMatcherExtension)) {
                return;
            }
            if (!textEvent.getViewerRedrawState()) {
                return;
            }
            String string = textEvent.getText();
            String string2 = textEvent.getReplacedText();
            ICharacterPairMatcherExtension iCharacterPairMatcherExtension = (ICharacterPairMatcherExtension)((Object)MatchingCharacterPainter.this.fMatcher);
            if (this.searchForCharacters(string, iCharacterPairMatcherExtension) || this.searchForCharacters(string2, iCharacterPairMatcherExtension)) {
                MatchingCharacterPainter.this.paint(8);
            }
        }

        private boolean searchForCharacters(String string, ICharacterPairMatcherExtension iCharacterPairMatcherExtension) {
            if (string == null) {
                return false;
            }
            int n = 0;
            while (n < string.length()) {
                if (iCharacterPairMatcherExtension.isMatchedChar(string.charAt(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

