/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public class LineNumberRulerColumn
implements IVerticalRulerColumn {
    private static final boolean IS_MAC = Util.isMac();
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private int fScrollPos;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private Font fFont;
    private int[] fIndentation;
    private boolean fSensitiveToTextChanges = false;
    private Color fForeground;
    private Color fBackground;
    private int fCachedNumberOfDigits = -1;
    private boolean fRelayoutRequired = false;
    private Object fRunnableLock = new Object();
    private boolean fIsRunnablePosted = false;
    private Runnable fRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = LineNumberRulerColumn.this.fRunnableLock;
            synchronized (object) {
                LineNumberRulerColumn.this.fIsRunnablePosted = false;
            }
            LineNumberRulerColumn.this.redraw();
        }
    };
    private MouseHandler fMouseHandler;

    public void setForeground(Color color) {
        this.fForeground = color;
    }

    protected Color getForeground() {
        return this.fForeground;
    }

    public void setBackground(Color color) {
        this.fBackground = color;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        }
    }

    protected Color getBackground(Display display) {
        if (this.fBackground == null) {
            return display.getSystemColor(25);
        }
        return this.fBackground;
    }

    @Override
    public Control getControl() {
        return this.fCanvas;
    }

    @Override
    public int getWidth() {
        return this.fIndentation[0];
    }

    protected boolean updateNumberOfDigits() {
        if (this.fCachedTextViewer == null) {
            return false;
        }
        int n = this.computeNumberOfDigits();
        if (this.fCachedNumberOfDigits != n) {
            this.fCachedNumberOfDigits = n;
            return true;
        }
        return false;
    }

    protected int computeNumberOfDigits() {
        IDocument iDocument = this.fCachedTextViewer.getDocument();
        int n = iDocument == null ? 0 : iDocument.getNumberOfLines();
        int n2 = 2;
        while ((double)n > Math.pow(10.0, n2) - 1.0) {
            ++n2;
        }
        return n2;
    }

    protected void layout(boolean bl) {
        ITextViewerExtension iTextViewerExtension;
        Control control;
        if (!bl) {
            this.fRelayoutRequired = true;
            return;
        }
        this.fRelayoutRequired = false;
        if (this.fCachedTextViewer instanceof ITextViewerExtension && (control = (iTextViewerExtension = (ITextViewerExtension)((Object)this.fCachedTextViewer)).getControl()) instanceof Composite && !control.isDisposed()) {
            Composite composite = (Composite)control;
            composite.layout(true);
        }
    }

    protected void computeIndentations() {
        if (this.fCanvas == null || this.fCanvas.isDisposed()) {
            return;
        }
        GC gC = new GC((Drawable)this.fCanvas);
        try {
            gC.setFont(this.fCanvas.getFont());
            this.fIndentation = new int[this.fCachedNumberOfDigits + 1];
            char[] cArray = new char[this.fCachedNumberOfDigits];
            Arrays.fill(cArray, '9');
            String string = new String(cArray);
            Point point = gC.stringExtent(string);
            this.fIndentation[0] = point.x;
            int n = 1;
            while (n <= this.fCachedNumberOfDigits) {
                point = gC.stringExtent(string.substring(0, n));
                this.fIndentation[n] = this.fIndentation[0] - point.x;
                ++n;
            }
        }
        finally {
            gC.dispose();
        }
    }

    @Override
    public Control createControl(CompositeRuler compositeRuler, Composite composite) {
        this.fParentRuler = compositeRuler;
        this.fCachedTextViewer = compositeRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fCanvas = new Canvas(composite, 524288){

            public void addMouseListener(MouseListener mouseListener) {
                if (mouseListener == LineNumberRulerColumn.this.fMouseHandler) {
                    super.addMouseListener(mouseListener);
                } else {
                    TypedListener typedListener = null;
                    if (mouseListener != null) {
                        typedListener = new TypedListener((SWTEventListener)mouseListener);
                    }
                    this.addListener(8, (Listener)typedListener);
                }
            }
        };
        this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        this.fCanvas.setForeground(this.fForeground);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent paintEvent) {
                if (LineNumberRulerColumn.this.fCachedTextViewer != null) {
                    LineNumberRulerColumn.this.doubleBufferPaint(paintEvent.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                LineNumberRulerColumn.this.handleDispose();
                LineNumberRulerColumn.this.fCachedTextViewer = null;
                LineNumberRulerColumn.this.fCachedTextWidget = null;
            }
        });
        this.fMouseHandler = new MouseHandler();
        this.fCanvas.addMouseListener((MouseListener)this.fMouseHandler);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)this.fMouseHandler);
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener(this.fInternalListener);
            this.fCachedTextViewer.addTextListener(this.fInternalListener);
            if (this.fFont == null && this.fCachedTextWidget != null && !this.fCachedTextWidget.isDisposed()) {
                this.fFont = this.fCachedTextWidget.getFont();
            }
        }
        if (this.fFont != null) {
            this.fCanvas.setFont(this.fFont);
        }
        this.updateNumberOfDigits();
        this.computeIndentations();
        return this.fCanvas;
    }

    protected void handleDispose() {
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener(this.fInternalListener);
            this.fCachedTextViewer.removeTextListener(this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    private void doubleBufferPaint(GC gC) {
        Rectangle rectangle;
        Point point = this.fCanvas.getSize();
        if (point.x <= 0 || point.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            rectangle = this.fBuffer.getBounds();
            if (rectangle.width != point.x || rectangle.height != point.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), point.x, point.y);
        }
        rectangle = new GC((Drawable)this.fBuffer);
        rectangle.setFont(this.fCanvas.getFont());
        if (this.fForeground != null) {
            rectangle.setForeground(this.fForeground);
        }
        try {
            rectangle.setBackground(this.getBackground(this.fCanvas.getDisplay()));
            rectangle.fillRectangle(0, 0, point.x, point.y);
            ILineRange iLineRange = JFaceTextUtil.getVisibleModelLines(this.fCachedTextViewer);
            if (iLineRange == null) {
                return;
            }
            this.fScrollPos = this.fCachedTextWidget.getTopPixel();
            this.doPaint((GC)rectangle, iLineRange);
        }
        finally {
            rectangle.dispose();
        }
        gC.drawImage(this.fBuffer, 0, 0);
    }

    protected int getVisibleLinesInViewport() {
        return LineNumberRulerColumn.getVisibleLinesInViewport(this.fCachedTextWidget);
    }

    protected final boolean isViewerCompletelyShown() {
        return JFaceTextUtil.isShowingEntireContents(this.fCachedTextWidget);
    }

    void doPaint(GC gC, ILineRange iLineRange) {
        Display display = this.fCachedTextWidget.getDisplay();
        int n = -JFaceTextUtil.getHiddenTopLinePixels(this.fCachedTextWidget);
        int n2 = LineNumberRulerColumn.end(iLineRange);
        int n3 = iLineRange.getStartLine();
        while (n3 < n2) {
            int n4 = JFaceTextUtil.modelLineToWidgetLine(this.fCachedTextViewer, n3);
            if (n4 != -1) {
                int n5 = this.fCachedTextWidget.getLinePixel(n4 + 1) - this.fCachedTextWidget.getLinePixel(n4);
                this.paintLine(n3, n, n5, gC, display);
                n += n5;
            }
            ++n3;
        }
    }

    private static int end(ILineRange iLineRange) {
        return iLineRange.getStartLine() + iLineRange.getNumberOfLines();
    }

    protected String createDisplayString(int n) {
        return Integer.toString(n + 1);
    }

    private int getBaselineBias(GC gC, int n) {
        int n2 = this.fCachedTextWidget.getOffsetAtLine(n);
        int n3 = this.fCachedTextWidget.getBaseline(n2);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n4 = fontMetrics.getAscent() + fontMetrics.getLeading();
        int n5 = n3 - n4;
        return Math.max(0, n5);
    }

    protected void paintLine(int n, int n2, int n3, GC gC, Display display) {
        int n4 = JFaceTextUtil.modelLineToWidgetLine(this.fCachedTextViewer, n);
        String string = this.createDisplayString(n);
        int n5 = this.fIndentation[string.length()];
        int n6 = this.getBaselineBias(gC, n4);
        gC.drawString(string, n5, n2 + n6, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void postRedraw() {
        Display display;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (display = this.fCanvas.getDisplay()) != null) {
            Object object = this.fRunnableLock;
            synchronized (object) {
                if (this.fIsRunnablePosted) {
                    return;
                }
                this.fIsRunnablePosted = true;
            }
            display.asyncExec(this.fRunnable);
        }
    }

    @Override
    public void redraw() {
        if (this.fRelayoutRequired) {
            this.layout(true);
            return;
        }
        if (this.fCachedTextViewer != null && this.fCanvas != null && !this.fCanvas.isDisposed()) {
            if (IS_MAC) {
                this.fCanvas.redraw();
                this.fCanvas.update();
            } else {
                GC gC = new GC((Drawable)this.fCanvas);
                this.doubleBufferPaint(gC);
                gC.dispose();
            }
        }
    }

    @Override
    public void setModel(IAnnotationModel iAnnotationModel) {
    }

    @Override
    public void setFont(Font font) {
        this.fFont = font;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setFont(this.fFont);
            this.updateNumberOfDigits();
            this.computeIndentations();
        }
    }

    protected CompositeRuler getParentRuler() {
        return this.fParentRuler;
    }

    static int getVisibleLinesInViewport(StyledText styledText) {
        Rectangle rectangle;
        if (styledText != null && !(rectangle = styledText.getClientArea()).isEmpty()) {
            int n = 0;
            int n2 = rectangle.height - 1;
            int n3 = JFaceTextUtil.getLineIndex(styledText, n);
            int n4 = JFaceTextUtil.getLineIndex(styledText, n2);
            return n4 - n3;
        }
        return -1;
    }

    class InternalListener
    implements IViewportListener,
    ITextListener {
        private boolean fCachedRedrawState = true;

        InternalListener() {
        }

        @Override
        public void viewportChanged(int n) {
            if (this.fCachedRedrawState && n != LineNumberRulerColumn.this.fScrollPos) {
                LineNumberRulerColumn.this.redraw();
            }
        }

        @Override
        public void textChanged(TextEvent textEvent) {
            this.fCachedRedrawState = textEvent.getViewerRedrawState();
            if (!this.fCachedRedrawState) {
                return;
            }
            if (LineNumberRulerColumn.this.updateNumberOfDigits()) {
                LineNumberRulerColumn.this.computeIndentations();
                LineNumberRulerColumn.this.layout(textEvent.getViewerRedrawState());
                return;
            }
            boolean bl = LineNumberRulerColumn.this.isViewerCompletelyShown();
            if (bl || LineNumberRulerColumn.this.fSensitiveToTextChanges || textEvent.getDocumentEvent() == null) {
                LineNumberRulerColumn.this.postRedraw();
            }
            LineNumberRulerColumn.this.fSensitiveToTextChanges = bl;
        }
    }

    class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        private int fCachedViewportSize;
        private int fStartLineOffset;
        private int fStartLineNumber;
        private int fAutoScrollDirection;
        private boolean fIsListeningForMove = false;

        MouseHandler() {
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                this.stopSelecting();
                this.stopAutoScroll();
            }
        }

        public void mouseDown(MouseEvent mouseEvent) {
            LineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
            if (mouseEvent.button == 1) {
                this.startSelecting((mouseEvent.stateMask & 0x20000) != 0);
            }
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
            LineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
            this.stopSelecting();
            this.stopAutoScroll();
        }

        public void mouseMove(MouseEvent mouseEvent) {
            if (this.fIsListeningForMove && !this.autoScroll(mouseEvent)) {
                int n = LineNumberRulerColumn.this.fParentRuler.toDocumentLineNumber(mouseEvent.y);
                this.expandSelection(n);
            }
            LineNumberRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(mouseEvent.x, mouseEvent.y);
        }

        private void startSelecting(boolean bl) {
            try {
                IDocument iDocument = LineNumberRulerColumn.this.fCachedTextViewer.getDocument();
                int n = LineNumberRulerColumn.this.fParentRuler.getLineOfLastMouseButtonActivity();
                StyledText styledText = LineNumberRulerColumn.this.fCachedTextViewer.getTextWidget();
                if (styledText != null && !styledText.isFocusControl()) {
                    styledText.setFocus();
                }
                if (bl && LineNumberRulerColumn.this.fCachedTextViewer instanceof ITextViewerExtension5 && styledText != null) {
                    ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)LineNumberRulerColumn.this.fCachedTextViewer);
                    int n2 = styledText.getCaretOffset();
                    int n3 = iTextViewerExtension5.widgetOffset2ModelOffset(n2);
                    Point point = LineNumberRulerColumn.this.fCachedTextViewer.getSelectedRange();
                    int n4 = n3 == point.x ? point.x + point.y : point.x;
                    this.fStartLineNumber = iDocument.getLineOfOffset(n4);
                    this.fStartLineOffset = n4;
                    this.expandSelection(n);
                } else {
                    this.fStartLineNumber = n;
                    this.fStartLineOffset = iDocument.getLineInformation(this.fStartLineNumber).getOffset();
                    LineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(this.fStartLineOffset, 0);
                }
                this.fCachedViewportSize = LineNumberRulerColumn.this.getVisibleLinesInViewport();
                this.fIsListeningForMove = true;
            }
            catch (BadLocationException badLocationException) {}
        }

        private void stopSelecting() {
            this.fIsListeningForMove = false;
        }

        private void expandSelection(int n) {
            try {
                int n2;
                int n3;
                IDocument iDocument = LineNumberRulerColumn.this.fCachedTextViewer.getDocument();
                IRegion iRegion = iDocument.getLineInformation(n);
                Display display = LineNumberRulerColumn.this.fCachedTextWidget.getDisplay();
                Point point = display.getCursorLocation();
                Point point2 = LineNumberRulerColumn.this.fCachedTextWidget.toControl(point);
                if (point2.x < 0) {
                    n3 = iRegion.getOffset();
                } else {
                    try {
                        n2 = LineNumberRulerColumn.this.fCachedTextWidget.getOffsetAtLocation(point2);
                        Point point3 = LineNumberRulerColumn.this.fCachedTextWidget.getLocationAtOffset(n2);
                        if (point3.x > point2.x) {
                            --n2;
                        }
                        if (LineNumberRulerColumn.this.fCachedTextViewer instanceof ITextViewerExtension5) {
                            ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)((Object)LineNumberRulerColumn.this.fCachedTextViewer);
                            n3 = iTextViewerExtension5.widgetOffset2ModelOffset(n2);
                        } else {
                            n3 = n2 + LineNumberRulerColumn.this.fCachedTextViewer.getVisibleRegion().getOffset();
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        int n4;
                        ITextViewerExtension5 iTextViewerExtension5;
                        n2 = iRegion.getOffset() + iRegion.getLength();
                        if (LineNumberRulerColumn.this.fCachedTextViewer instanceof ITextViewerExtension5) {
                            iTextViewerExtension5 = (ITextViewerExtension5)((Object)LineNumberRulerColumn.this.fCachedTextViewer);
                            n4 = iTextViewerExtension5.modelOffset2WidgetOffset(n2);
                        } else {
                            n4 = n2 - LineNumberRulerColumn.this.fCachedTextViewer.getVisibleRegion().getOffset();
                        }
                        iTextViewerExtension5 = LineNumberRulerColumn.this.fCachedTextWidget.getLocationAtOffset(n4);
                        n3 = ((Point)iTextViewerExtension5).x < point2.x ? n2 : iRegion.getOffset();
                    }
                }
                n2 = Math.min(this.fStartLineOffset, n3);
                int n5 = Math.max(this.fStartLineOffset, n3);
                if (n < this.fStartLineNumber) {
                    LineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(n5, n2 - n5);
                } else {
                    LineNumberRulerColumn.this.fCachedTextViewer.setSelectedRange(n2, n5 - n2);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        private void stopAutoScroll() {
            this.fAutoScrollDirection = 0;
        }

        private boolean autoScroll(MouseEvent mouseEvent) {
            Rectangle rectangle = LineNumberRulerColumn.this.fCanvas.getClientArea();
            if (mouseEvent.y > rectangle.height) {
                this.autoScroll(1024);
                return true;
            }
            if (mouseEvent.y < 0) {
                this.autoScroll(128);
                return true;
            }
            this.stopAutoScroll();
            return false;
        }

        private void autoScroll(int n) {
            if (this.fAutoScrollDirection == n) {
                return;
            }
            final Display display = LineNumberRulerColumn.this.fCanvas.getDisplay();
            Runnable runnable = null;
            switch (n) {
                case 128: {
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            int n;
                            if (MouseHandler.this.fAutoScrollDirection == 128 && (n = MouseHandler.this.getInclusiveTopIndex()) > 0) {
                                LineNumberRulerColumn.this.fCachedTextViewer.setTopIndex(n - 1);
                                MouseHandler.this.expandSelection(n - 1);
                                display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                    break;
                }
                case 1024: {
                    runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (MouseHandler.this.fAutoScrollDirection == 1024) {
                                int n = MouseHandler.this.getInclusiveTopIndex();
                                LineNumberRulerColumn.this.fCachedTextViewer.setTopIndex(n + 1);
                                MouseHandler.this.expandSelection(n + 1 + MouseHandler.this.fCachedViewportSize);
                                display.timerExec(5, (Runnable)this);
                            }
                        }
                    };
                }
            }
            if (runnable != null) {
                this.fAutoScrollDirection = n;
                display.timerExec(5, runnable);
            }
        }

        private int getInclusiveTopIndex() {
            if (LineNumberRulerColumn.this.fCachedTextWidget != null && !LineNumberRulerColumn.this.fCachedTextWidget.isDisposed()) {
                return JFaceTextUtil.getPartialTopIndex(LineNumberRulerColumn.this.fCachedTextViewer);
            }
            return -1;
        }
    }
}

