/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.revisions.RevisionPainter;
import org.eclipse.jface.internal.text.source.DiffPainter;
import org.eclipse.jface.text.revisions.IRevisionListener;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class LineNumberChangeRulerColumn
extends LineNumberRulerColumn
implements IChangeRulerColumn,
IRevisionRulerColumn,
IRevisionRulerColumnExtension {
    private IAnnotationModel fAnnotationModel;
    private boolean fCharacterDisplay;
    private final RevisionPainter fRevisionPainter;
    private final DiffPainter fDiffPainter;
    private boolean fShowNumbers = true;

    public LineNumberChangeRulerColumn(ISharedTextColors iSharedTextColors) {
        Assert.isNotNull((Object)iSharedTextColors);
        this.fRevisionPainter = new RevisionPainter(this, iSharedTextColors);
        this.fDiffPainter = new DiffPainter(this, iSharedTextColors);
    }

    @Override
    public Control createControl(CompositeRuler compositeRuler, Composite composite) {
        Control control = super.createControl(compositeRuler, composite);
        this.fRevisionPainter.setParentRuler(compositeRuler);
        this.fDiffPainter.setParentRuler(compositeRuler);
        return control;
    }

    @Override
    public int getLineOfLastMouseButtonActivity() {
        return this.getParentRuler().getLineOfLastMouseButtonActivity();
    }

    @Override
    public int toDocumentLineNumber(int n) {
        return this.getParentRuler().toDocumentLineNumber(n);
    }

    @Override
    public void setModel(IAnnotationModel iAnnotationModel) {
        this.setAnnotationModel(iAnnotationModel);
        this.fRevisionPainter.setModel(iAnnotationModel);
        this.fDiffPainter.setModel(iAnnotationModel);
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.layout(true);
        this.postRedraw();
    }

    private void setAnnotationModel(IAnnotationModel iAnnotationModel) {
        if (this.fAnnotationModel != iAnnotationModel) {
            this.fAnnotationModel = iAnnotationModel;
        }
    }

    public void setDisplayMode(boolean bl) {
        if (bl != this.fCharacterDisplay) {
            this.fCharacterDisplay = bl;
            this.updateNumberOfDigits();
            this.computeIndentations();
            this.layout(true);
        }
    }

    @Override
    public IAnnotationModel getModel() {
        return this.fAnnotationModel;
    }

    @Override
    protected String createDisplayString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fShowNumbers) {
            stringBuffer.append(super.createDisplayString(n));
        }
        if (this.fCharacterDisplay && this.getModel() != null) {
            stringBuffer.append(this.fDiffPainter.getDisplayCharacter(n));
        }
        return stringBuffer.toString();
    }

    @Override
    protected int computeNumberOfDigits() {
        int n = this.fCharacterDisplay && this.getModel() != null ? (this.fShowNumbers ? super.computeNumberOfDigits() + 1 : 1) : (this.fShowNumbers ? super.computeNumberOfDigits() : 0);
        if (this.fRevisionPainter.hasInformation()) {
            n += this.fRevisionPainter.getRequiredWidth();
        }
        return n;
    }

    @Override
    public void addVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeVerticalRulerListener(IVerticalRulerListener iVerticalRulerListener) {
        throw new UnsupportedOperationException();
    }

    @Override
    void doPaint(GC gC, ILineRange iLineRange) {
        Color color = gC.getForeground();
        if (iLineRange != null) {
            if (this.fRevisionPainter.hasInformation()) {
                this.fRevisionPainter.paint(gC, iLineRange);
            } else if (this.fDiffPainter.hasInformation()) {
                this.fDiffPainter.paint(gC, iLineRange);
            }
        }
        gC.setForeground(color);
        if (this.fShowNumbers || this.fCharacterDisplay) {
            super.doPaint(gC, iLineRange);
        }
    }

    @Override
    public IAnnotationHover getHover() {
        int n = this.getParentRuler().getLineOfLastMouseButtonActivity();
        if (this.fRevisionPainter.hasHover(n)) {
            return this.fRevisionPainter.getHover();
        }
        if (this.fDiffPainter.hasHover(n)) {
            return this.fDiffPainter.getHover();
        }
        return null;
    }

    @Override
    public void setHover(IAnnotationHover iAnnotationHover) {
        this.fRevisionPainter.setHover(iAnnotationHover);
        this.fDiffPainter.setHover(iAnnotationHover);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.fRevisionPainter.setBackground(color);
        this.fDiffPainter.setBackground(color);
    }

    @Override
    public void setAddedColor(Color color) {
        this.fDiffPainter.setAddedColor(color);
    }

    @Override
    public void setChangedColor(Color color) {
        this.fDiffPainter.setChangedColor(color);
    }

    @Override
    public void setDeletedColor(Color color) {
        this.fDiffPainter.setDeletedColor(color);
    }

    @Override
    public void setRevisionInformation(RevisionInformation revisionInformation) {
        this.fRevisionPainter.setRevisionInformation(revisionInformation);
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.layout(true);
        this.postRedraw();
    }

    @Override
    public ISelectionProvider getRevisionSelectionProvider() {
        return this.fRevisionPainter.getRevisionSelectionProvider();
    }

    @Override
    public void setRevisionRenderingMode(IRevisionRulerColumnExtension.RenderingMode renderingMode) {
        this.fRevisionPainter.setRenderingMode(renderingMode);
    }

    public void showLineNumbers(boolean bl) {
        if (this.fShowNumbers != bl) {
            this.fShowNumbers = bl;
            this.updateNumberOfDigits();
            this.computeIndentations();
            this.layout(true);
        }
    }

    @Override
    public int getWidth() {
        int n = super.getWidth();
        return n > 0 ? n : 8;
    }

    public boolean isShowingLineNumbers() {
        return this.fShowNumbers;
    }

    public boolean isShowingRevisionInformation() {
        return this.fRevisionPainter.hasInformation();
    }

    public boolean isShowingChangeInformation() {
        return this.fDiffPainter.hasInformation();
    }

    @Override
    public void showRevisionAuthor(boolean bl) {
        this.fRevisionPainter.showRevisionAuthor(bl);
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.layout(true);
        this.postRedraw();
    }

    @Override
    public void showRevisionId(boolean bl) {
        this.fRevisionPainter.showRevisionId(bl);
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.layout(true);
        this.postRedraw();
    }

    @Override
    public void addRevisionListener(IRevisionListener iRevisionListener) {
        this.fRevisionPainter.addRevisionListener(iRevisionListener);
    }

    @Override
    public void removeRevisionListener(IRevisionListener iRevisionListener) {
        this.fRevisionPainter.removeRevisionListener(iRevisionListener);
    }

    @Override
    protected void handleDispose() {
        this.fRevisionPainter.setParentRuler(null);
        this.fRevisionPainter.setModel(null);
        this.fDiffPainter.setParentRuler(null);
        this.fDiffPainter.setModel(null);
        super.handleDispose();
    }
}

