/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.ILineDifferExtension2;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class LineChangeHover
implements IAnnotationHover,
IAnnotationHoverExtension,
IInformationProviderExtension2 {
    @Override
    public String getHoverInfo(ISourceViewer iSourceViewer, int n) {
        return null;
    }

    protected String formatSource(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            String string2 = this.getTabReplacement();
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '\t') {
                    stringBuffer.replace(n, n + 1, string2);
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    protected String getTabReplacement() {
        return "\t";
    }

    private String computeContent(ISourceViewer iSourceViewer, int n, int n2, int n3) {
        ILineDiffer iLineDiffer = this.getDiffer(iSourceViewer);
        if (iLineDiffer == null) {
            return null;
        }
        LinkedList<ILineDiffInfo> linkedList = new LinkedList<ILineDiffInfo>();
        int n4 = n;
        while (n4 <= n2) {
            ILineDiffInfo iLineDiffInfo = iLineDiffer.getLineInfo(n4);
            if (iLineDiffInfo != null) {
                linkedList.add(iLineDiffInfo);
            }
            ++n4;
        }
        return this.decorateText(linkedList, n3);
    }

    /*
     * Unable to fully structure code
     */
    protected String decorateText(List var1_1, int var2_2) {
        var3_3 = "";
        var4_4 = 0;
        for (ILineDiffInfo var6_6 : var1_1) {
            var7_7 = var6_6.getOriginalText();
            var8_8 = var6_6.getChangeType();
            var9_9 = 0;
            if (var8_8 == 1) {
                ++var4_4;
            } else if (var8_8 == 2) {
                var3_3 = String.valueOf(var3_3) + "> " + (var7_7.length > 0 ? var7_7[var9_9++] : "");
                --var2_2;
            } else if (var8_8 == 0) {
                ++var2_2;
            }
            if (var2_2 != 0) ** GOTO lbl23
            return this.trimTrailing(var3_3);
lbl-1000:
            // 1 sources

            {
                var3_3 = String.valueOf(var3_3) + "- " + var7_7[var9_9];
                --var4_4;
                if (--var2_2 == 0) {
                    return this.trimTrailing(var3_3);
                }
                ++var9_9;
lbl23:
                // 2 sources

                ** while (var9_9 < var7_7.length)
            }
lbl24:
            // 1 sources

        }
        if ((var3_3 = var3_3.trim()).length() == 0 && var4_4-- > 0 && var2_2-- > 0) {
            var3_3 = String.valueOf(var3_3) + "+ ";
        }
        while (var4_4-- > 0 && var2_2-- > 0) {
            var3_3 = String.valueOf(var3_3) + "\n+ ";
        }
        return var3_3;
    }

    private String trimTrailing(String string) {
        int n = string.length() - 1;
        while (n >= 0 && Character.isWhitespace(string.charAt(n))) {
            --n;
        }
        return string.substring(0, n + 1);
    }

    private ILineDiffer getDiffer(ISourceViewer iSourceViewer) {
        IAnnotationModel iAnnotationModel;
        IAnnotationModel iAnnotationModel2 = iSourceViewer.getAnnotationModel();
        if (iAnnotationModel2 == null) {
            return null;
        }
        if (iAnnotationModel2 instanceof IAnnotationModelExtension && (iAnnotationModel = ((IAnnotationModelExtension)iAnnotationModel2).getAnnotationModel((Object)"diff")) != null) {
            iAnnotationModel2 = iAnnotationModel;
        }
        if (iAnnotationModel2 instanceof ILineDiffer) {
            if (iAnnotationModel2 instanceof ILineDifferExtension2 && ((ILineDifferExtension2)iAnnotationModel2).isSuspended()) {
                return null;
            }
            return (ILineDiffer)iAnnotationModel2;
        }
        return null;
    }

    protected Point computeLineRange(ISourceViewer iSourceViewer, int n, int n2, int n3) {
        ILineDiffer iLineDiffer = this.getDiffer(iSourceViewer);
        if (iLineDiffer == null) {
            return new Point(-1, -1);
        }
        int n4 = n;
        ILineDiffInfo iLineDiffInfo = iLineDiffer.getLineInfo(n4);
        while (n4 >= n2 && iLineDiffInfo != null && (iLineDiffInfo.getChangeType() == 2 || iLineDiffInfo.getChangeType() == 1)) {
            iLineDiffInfo = iLineDiffer.getLineInfo(--n4);
        }
        int n5 = Math.min(n4 + 1, n);
        n4 = n;
        iLineDiffInfo = iLineDiffer.getLineInfo(n4);
        while (n4 <= n3 && iLineDiffInfo != null && (iLineDiffInfo.getChangeType() == 2 || iLineDiffInfo.getChangeType() == 1)) {
            iLineDiffInfo = iLineDiffer.getLineInfo(++n4);
        }
        int n6 = Math.max(n4 - 1, n);
        return new Point(n5, n6);
    }

    @Override
    public Object getHoverInfo(ISourceViewer iSourceViewer, ILineRange iLineRange, int n) {
        int n2 = this.adaptFirstLine(iSourceViewer, iLineRange.getStartLine());
        int n3 = this.adaptLastLine(iSourceViewer, iLineRange.getStartLine() + iLineRange.getNumberOfLines() - 1);
        String string = this.computeContent(iSourceViewer, n2, n3, n);
        return this.formatSource(string);
    }

    private int adaptFirstLine(ISourceViewer iSourceViewer, int n) {
        int n2;
        ILineDiffInfo iLineDiffInfo;
        ILineDiffer iLineDiffer = this.getDiffer(iSourceViewer);
        if (iLineDiffer != null && n > 0 && (iLineDiffInfo = iLineDiffer.getLineInfo(n2 = n - 1)) != null && iLineDiffInfo.getChangeType() == 0 && iLineDiffInfo.getRemovedLinesBelow() > 0) {
            return n2;
        }
        return n;
    }

    private int adaptLastLine(ISourceViewer iSourceViewer, int n) {
        ILineDiffInfo iLineDiffInfo;
        ILineDiffer iLineDiffer = this.getDiffer(iSourceViewer);
        if (iLineDiffer != null && n > 0 && (iLineDiffInfo = iLineDiffer.getLineInfo(n)) != null && iLineDiffInfo.getChangeType() == 0) {
            return n - 1;
        }
        return n;
    }

    @Override
    public ILineRange getHoverLineRange(ISourceViewer iSourceViewer, int n) {
        IDocument iDocument = iSourceViewer.getDocument();
        if (iDocument != null) {
            Point point = this.computeLineRange(iSourceViewer, n, 0, Math.max(0, iDocument.getNumberOfLines() - 1));
            if (point.x != -1 && point.y != -1) {
                return new LineRange(point.x, point.y - point.x + 1);
            }
        }
        return null;
    }

    @Override
    public boolean canHandleMouseCursor() {
        return false;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return null;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new IInformationControlCreator(){

            @Override
            public IInformationControl createInformationControl(Shell shell) {
                return new DefaultInformationControl(shell, null, null);
            }
        };
    }
}

