/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;

public class DefaultCharacterPairMatcher
implements ICharacterPairMatcher,
ICharacterPairMatcherExtension {
    private int fAnchor = -1;
    private final CharPairs fPairs;
    private final String fPartitioning;
    private final boolean fCaretEitherSideOfBracket;

    public DefaultCharacterPairMatcher(char[] cArray, String string) {
        this(cArray, string, false);
    }

    public DefaultCharacterPairMatcher(char[] cArray, String string, boolean bl) {
        Assert.isLegal((cArray.length % 2 == 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)string);
        this.fPairs = new CharPairs(cArray);
        this.fPartitioning = string;
        this.fCaretEitherSideOfBracket = bl;
    }

    public DefaultCharacterPairMatcher(char[] cArray) {
        this(cArray, "__dftl_partitioning");
    }

    @Override
    public IRegion match(IDocument iDocument, int n) {
        if (iDocument == null || n < 0 || n > iDocument.getLength()) {
            return null;
        }
        try {
            return this.performMatch(iDocument, n);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    @Override
    public IRegion match(IDocument iDocument, int n, int n2) {
        int n3;
        block4: {
            if (iDocument == null || n < 0 || n > iDocument.getLength() || Math.abs(n2) > 1) {
                return null;
            }
            try {
                char c;
                n3 = n + n2;
                if (Math.abs(n2) != 1) break block4;
                char c2 = c = n2 > 0 ? iDocument.getChar(n) : iDocument.getChar(n3);
                if (this.fPairs.contains(c)) break block4;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        int n4 = this.getOffsetAdjustment(iDocument, n3, n2);
        return this.match(iDocument, n3 += n4);
    }

    @Override
    public IRegion findEnclosingPeerCharacters(IDocument iDocument, int n, int n2) {
        if (iDocument == null || n < 0 || n > iDocument.getLength()) {
            return null;
        }
        IRegion iRegion = this.match(iDocument, n, n2);
        this.fAnchor = 1;
        if (iRegion != null) {
            return iRegion;
        }
        try {
            String string = TextUtilities.getContentType((IDocument)iDocument, (String)this.fPartitioning, (int)n, (boolean)false);
            DocumentPartitionAccessor documentPartitionAccessor = new DocumentPartitionAccessor(iDocument, this.fPartitioning, string);
            IRegion iRegion2 = this.findEnclosingPeers(iDocument, documentPartitionAccessor, n, n2, 0, iDocument.getLength());
            if (iRegion2 != null) {
                return iRegion2;
            }
            documentPartitionAccessor = new DocumentPartitionAccessor(iDocument, this.fPartitioning, "__dftl_partition_content_type");
            return this.findEnclosingPeers(iDocument, documentPartitionAccessor, n, n2, 0, iDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            this.fAnchor = -1;
            return null;
        }
    }

    @Override
    public boolean isMatchedChar(char c) {
        return this.fPairs.contains(c);
    }

    @Override
    public boolean isMatchedChar(char c, IDocument iDocument, int n) {
        return this.isMatchedChar(c);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRecomputationOfEnclosingPairRequired(IDocument iDocument, IRegion iRegion, IRegion iRegion2) {
        int n = iRegion2.getOffset();
        int n2 = iRegion.getOffset();
        int n3 = n + iRegion2.getLength();
        int n4 = n2 + iRegion.getLength();
        try {
            int n5;
            int n6;
            int n7;
            block12: {
                String string;
                String string2 = TextUtilities.getContentType((IDocument)iDocument, (String)this.fPartitioning, (int)n3, (boolean)false);
                String string3 = TextUtilities.getContentType((IDocument)iDocument, (String)this.fPartitioning, (int)n4, (boolean)false);
                if (!string2.equals(string3)) {
                    return true;
                }
                String string4 = TextUtilities.getContentType((IDocument)iDocument, (String)this.fPartitioning, (int)n, (boolean)true);
                if (!string4.equals(string = TextUtilities.getContentType((IDocument)iDocument, (String)this.fPartitioning, (int)n2, (boolean)true))) {
                    return true;
                }
                if (n4 > n3) {
                    n7 = n3;
                    n6 = n4;
                } else {
                    n7 = n4;
                    n6 = n3;
                }
                n5 = Math.max(n7 - 1, 0);
                while (true) {
                    if (n5 > n6) {
                        if (n2 <= n) break;
                        n7 = n;
                        n6 = n2;
                        break block12;
                    }
                    if (this.isMatchedChar(iDocument.getChar(n5))) {
                        return true;
                    }
                    ++n5;
                }
                n7 = n2;
                n6 = n;
            }
            n5 = Math.max(n7 - 1, 0);
            while (true) {
                if (n5 > n6) {
                    return false;
                }
                if (this.isMatchedChar(iDocument.getChar(n5))) {
                    return true;
                }
                ++n5;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private int getOffsetAdjustment(IDocument iDocument, int n, int n2) {
        block7: {
            block6: {
                if (n2 == 0 || Math.abs(n2) > 1 || n >= iDocument.getLength()) {
                    return 0;
                }
                try {
                    if (n2 >= 0) break block6;
                    if (this.fPairs.isStartCharacter(iDocument.getChar(n))) {
                        return 1;
                    }
                    break block7;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (this.fCaretEitherSideOfBracket && this.fPairs.isEndCharacter(iDocument.getChar(n - 1))) {
                return -1;
            }
        }
        return 0;
    }

    private IRegion performMatch(IDocument iDocument, int n) throws BadLocationException {
        int n2;
        int n3;
        int n4;
        boolean bl;
        int n5;
        int n6;
        int n7 = n6 = n - 1 >= 0 ? iDocument.getChar(n - 1) : 0;
        if (this.fCaretEitherSideOfBracket) {
            int n8 = n5 = n != iDocument.getLength() ? iDocument.getChar(n) : 0;
            if (this.fPairs.isEndCharacter((char)n6) && !this.fPairs.isEndCharacter((char)n5)) {
                n5 = n6;
                n6 = iDocument.getChar(Math.max(--n - 1, 0));
            } else if (this.fPairs.isStartCharacter((char)n5) && !this.fPairs.contains((char)n6)) {
                n6 = n5;
                n5 = iDocument.getChar(++n);
            }
            bl = this.fPairs.contains((char)n6) && this.fPairs.isStartCharacter((char)n6);
            int n9 = n4 = this.fPairs.contains((char)n5) && !this.fPairs.isStartCharacter((char)n5) ? 1 : 0;
            if (!bl && n4 == 0) {
                return null;
            }
            n3 = bl ? n6 : n5;
        } else {
            if (!this.fPairs.contains((char)n6)) {
                return null;
            }
            bl = this.fPairs.isStartCharacter((char)n6);
            n3 = n6;
        }
        int n10 = this.fAnchor = bl ? 1 : 0;
        int n11 = bl ? n : (n5 = this.fCaretEitherSideOfBracket ? n - 1 : n - 2);
        n4 = bl ? n - 1 : (this.fCaretEitherSideOfBracket ? n + 1 : n);
        String string = TextUtilities.getContentType((IDocument)iDocument, (String)this.fPartitioning, (int)(!bl && this.fCaretEitherSideOfBracket ? n : Math.max(n - 1, 0)), (boolean)false);
        DocumentPartitionAccessor documentPartitionAccessor = new DocumentPartitionAccessor(iDocument, this.fPartitioning, string);
        int n12 = this.findMatchingPeer(documentPartitionAccessor, (char)n3, this.fPairs.getMatching((char)n3), bl, bl ? iDocument.getLength() : -1, n5);
        if (n12 == -1) {
            return null;
        }
        int n13 = n2 = bl ? n12 + 1 : n12;
        if (n2 == n4) {
            return null;
        }
        return new Region(Math.min(n4, n2), Math.abs(n2 - n4));
    }

    private int findMatchingPeer(DocumentPartitionAccessor documentPartitionAccessor, char c, char c2, boolean bl, int n, int n2) throws BadLocationException {
        int n3 = n2;
        while (n3 != n) {
            char c3 = documentPartitionAccessor.getChar(n3);
            if (documentPartitionAccessor.isMatch(n3, c2)) {
                return n3;
            }
            if (c3 == c && documentPartitionAccessor.inPartition(n3) && (n3 = this.findMatchingPeer(documentPartitionAccessor, c, c2, bl, n, documentPartitionAccessor.getNextPosition(n3, bl))) == -1) {
                return -1;
            }
            n3 = documentPartitionAccessor.getNextPosition(n3, bl);
        }
        return -1;
    }

    private IRegion findEnclosingPeers(IDocument iDocument, DocumentPartitionAccessor documentPartitionAccessor, int n, int n2, int n3, int n4) throws BadLocationException {
        int n5;
        int n6;
        char c;
        int n7;
        int n8;
        char[] cArray = this.fPairs.fPairs;
        if (n2 >= 0) {
            n8 = n;
            n7 = n + n2;
        } else {
            n7 = n;
            n8 = n + n2;
        }
        boolean bl = false;
        boolean bl2 = false;
        int[][] nArray = new int[cArray.length][2];
        char c2 = c = n8 != iDocument.getLength() ? documentPartitionAccessor.getChar(n8) : (char)'\u0000';
        if (this.fPairs.isEndCharacter(c)) {
            n6 = documentPartitionAccessor.getNextPosition(n8, false);
            n5 = n8;
        } else {
            n6 = n8;
            n5 = documentPartitionAccessor.getNextPosition(n8, true);
        }
        while (n6 >= n3 && !bl || n5 < n4 && !bl2) {
            int n9;
            int n10;
            char c3 = '\u0000';
            while (c3 < nArray.length) {
                nArray[c3][1] = 0;
                nArray[c3][0] = 0;
                ++c3;
            }
            block2: while (n6 >= n3 && !bl) {
                c3 = documentPartitionAccessor.getChar(n6);
                n10 = this.getCharacterIndex(c3, iDocument, n6);
                if (n10 != -1 && documentPartitionAccessor.inPartition(n6)) {
                    if (n10 % 2 == 0) {
                        int[] nArray2 = nArray[n10 / 2];
                        nArray2[0] = nArray2[0] - 1;
                    } else {
                        int[] nArray3 = nArray[n10 / 2];
                        nArray3[0] = nArray3[0] + 1;
                    }
                    n9 = 0;
                    while (n9 < nArray.length) {
                        if (nArray[n9][0] == -1) {
                            bl = true;
                            break block2;
                        }
                        ++n9;
                    }
                }
                n6 = documentPartitionAccessor.getNextPosition(n6, false);
            }
            block4: while (n5 < n4 && !bl2) {
                c3 = documentPartitionAccessor.getChar(n5);
                n10 = this.getCharacterIndex(c3, iDocument, n5);
                if (n10 != -1 && documentPartitionAccessor.inPartition(n5)) {
                    if (n10 % 2 == 0) {
                        int[] nArray4 = nArray[n10 / 2];
                        nArray4[1] = nArray4[1] + 1;
                    } else {
                        int[] nArray5 = nArray[n10 / 2];
                        nArray5[1] = nArray5[1] - 1;
                    }
                    n9 = 0;
                    while (n9 < nArray.length) {
                        if (nArray[n9][1] == -1 && nArray[n9][0] == -1) {
                            bl2 = true;
                            break block4;
                        }
                        ++n9;
                    }
                }
                n5 = documentPartitionAccessor.getNextPosition(n5, true);
            }
            if (n6 <= n8 && n5 >= n7 - 1) continue;
            n6 = documentPartitionAccessor.getNextPosition(n6, false);
            n5 = documentPartitionAccessor.getNextPosition(n5, true);
            bl = false;
            bl2 = false;
        }
        if (n6 < n3 || ++n5 > n4) {
            return null;
        }
        return new Region(n6, n5 - n6);
    }

    private int getCharacterIndex(char c, IDocument iDocument, int n) {
        char[] cArray = this.fPairs.fPairs;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == c && this.isMatchedChar(c, iDocument, n)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    @Override
    public int getAnchor() {
        return this.fAnchor;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void clear() {
        this.fAnchor = -1;
    }

    private static class CharPairs {
        private final char[] fPairs;

        public CharPairs(char[] cArray) {
            this.fPairs = cArray;
        }

        public boolean contains(char c) {
            char[] cArray = this.fPairs;
            int n = 0;
            int n2 = cArray.length;
            while (n < n2) {
                if (c == cArray[n]) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public boolean isOpeningCharacter(char c, boolean bl) {
            int n = 0;
            while (n < this.fPairs.length) {
                if (bl && this.getStartChar(n) == c) {
                    return true;
                }
                if (!bl && this.getEndChar(n) == c) {
                    return true;
                }
                n += 2;
            }
            return false;
        }

        public boolean isStartCharacter(char c) {
            return this.isOpeningCharacter(c, true);
        }

        public boolean isEndCharacter(char c) {
            return this.isOpeningCharacter(c, false);
        }

        public char getMatching(char c) {
            int n = 0;
            while (n < this.fPairs.length) {
                if (this.getStartChar(n) == c) {
                    return this.getEndChar(n);
                }
                if (this.getEndChar(n) == c) {
                    return this.getStartChar(n);
                }
                n += 2;
            }
            Assert.isTrue((boolean)false);
            return '\u0000';
        }

        private char getStartChar(int n) {
            return this.fPairs[n];
        }

        private char getEndChar(int n) {
            return this.fPairs[n + 1];
        }
    }

    private static class DocumentPartitionAccessor {
        private final IDocument fDocument;
        private final String fPartitioning;
        private final String fPartition;
        private ITypedRegion fCachedPartition;
        private int fLength;

        public DocumentPartitionAccessor(IDocument iDocument, String string, String string2) {
            this.fDocument = iDocument;
            this.fPartitioning = string;
            this.fPartition = string2;
            this.fLength = iDocument.getLength();
        }

        public char getChar(int n) throws BadLocationException {
            return this.fDocument.getChar(n);
        }

        public boolean isMatch(int n, char c) throws BadLocationException {
            return this.getChar(n) == c && this.inPartition(n);
        }

        public boolean inPartition(int n) {
            ITypedRegion iTypedRegion = this.getPartition(n);
            return iTypedRegion != null && iTypedRegion.getType().equals(this.fPartition);
        }

        public int getNextPosition(int n, boolean bl) {
            ITypedRegion iTypedRegion = this.getPartition(n);
            if (iTypedRegion == null || this.fPartition.equals(iTypedRegion.getType())) {
                return this.simpleIncrement(n, bl);
            }
            if (bl) {
                int n2 = iTypedRegion.getOffset() + iTypedRegion.getLength();
                if (n < n2) {
                    return n2;
                }
            } else {
                int n3 = iTypedRegion.getOffset();
                if (n > n3) {
                    return n3 - 1;
                }
            }
            return this.simpleIncrement(n, bl);
        }

        private int simpleIncrement(int n, boolean bl) {
            return n + (bl ? 1 : -1);
        }

        private ITypedRegion getPartition(int n) {
            if (this.fCachedPartition == null || !DocumentPartitionAccessor.contains((IRegion)this.fCachedPartition, n)) {
                Assert.isTrue((n >= 0 && n <= this.fLength ? 1 : 0) != 0);
                try {
                    this.fCachedPartition = TextUtilities.getPartition((IDocument)this.fDocument, (String)this.fPartitioning, (int)n, (boolean)false);
                }
                catch (BadLocationException badLocationException) {
                    this.fCachedPartition = null;
                }
            }
            return this.fCachedPartition;
        }

        private static boolean contains(IRegion iRegion, int n) {
            int n2 = iRegion.getOffset();
            return n2 <= n && n < n2 + iRegion.getLength();
        }
    }
}

